/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.FeatureType;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.Filter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.GETMAPValidator;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.WMService;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class GetMapXmlReader
extends XmlRequestReader {
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();

    public GetMapXmlReader(WMService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WmsException {
        GetMapRequest getMapRequest = new GetMapRequest((WMService)this.getServiceRef());
        getMapRequest.setHttpServletRequest(req);
        boolean validateSchema = this.wantToValidate(req);
        try {
            this.parseGetMapXML(reader, getMapRequest, validateSchema);
        }
        catch (UnknownHostException unh) {
            throw new WmsException("unknown host - " + unh.getLocalizedMessage() + " - if its in a !DOCTYPE, remove the !DOCTYPE tag.");
        }
        catch (SAXParseException se) {
            throw new WmsException("line " + se.getLineNumber() + " column " + se.getColumnNumber() + " -- " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        return getMapRequest;
    }

    /*
     * Exception decompiling
     */
    private void parseGetMapXML(Reader xml, GetMapRequest getMapRequest, boolean validateSchema) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 357->361)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handlePostGet(Node rootNode, SLDParser sldParser, GetMapRequest getMapRequest) throws Exception {
        HttpServletRequest request = getMapRequest.getHttpServletRequest();
        String qString = request.getQueryString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("reading request: " + qString);
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        GetMapKvpReader kvpReader = new GetMapKvpReader(requestParams, (WMService)this.getServiceRef());
        String version = kvpReader.getRequestVersion();
        getMapRequest.setVersion(version);
        kvpReader.parseMandatoryParameters(getMapRequest, false);
        kvpReader.parseOptionalParameters(getMapRequest);
        StyledLayerDescriptor sld = sldParser.parseDescriptor(rootNode);
        this.processStyles(getMapRequest, sld);
    }

    private void processStyles(GetMapRequest getMapRequest, StyledLayerDescriptor sld) throws Exception {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList layers = new ArrayList();
        ArrayList styles = new ArrayList();
        StyledLayer sl = null;
        int i = 0;
        while (i < slCount) {
            MapLayerInfo currLayer = new MapLayerInfo();
            sl = styledLayers[i];
            String layerName = sl.getName();
            if (layerName == null) {
                throw new WmsException("A UserLayer without layer name was passed");
            }
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                UserLayer ul = (UserLayer)sl;
                currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore()));
                if (ul.getInlineFeatureType().getDefaultGeometry().getCoordinateSystem() == null) {
                    LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
                    FeatureType currFt = ul.getInlineFeatureType();
                    DefaultQuery q = new DefaultQuery(currFt.getTypeName(), Filter.NONE);
                    FeatureReader ilReader = ul.getInlineFeatureDatastore().getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
                    DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
                    MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(ilReader, (CoordinateReferenceSystem)crs));
                    currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo((DataStore)reTypedDS));
                }
            } else {
                try {
                    currLayer.setFeature(GetMapKvpReader.findFeatureLayer(getMapRequest, layerName));
                }
                catch (Exception e) {
                    currLayer.setCoverage(GetMapKvpReader.findCoverageLayer(getMapRequest, layerName));
                }
            }
            GetMapKvpReader.addStyles(getMapRequest, currLayer, styledLayers[i], layers, styles);
            ++i;
        }
        getMapRequest.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        getMapRequest.setStyles(styles);
    }

    private void parseBBox(GetMapRequest getMapRequest, Node nodeGetMap) throws Exception {
        Node bboxNode = this.getNode(nodeGetMap, "BoundingBox");
        if (bboxNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'BoundingBox' in GetMap tag");
        }
        List coordList = ExpressionDOMParser.parseCoords((Node)bboxNode);
        if (coordList.size() != 2) {
            throw new Exception("GetMap XML parser - node 'BoundingBox' in GetMap tag should have 2 coordinates in it");
        }
        Envelope env = new Envelope();
        int size = coordList.size();
        int i = 0;
        while (i < size) {
            env.expandToInclude((Coordinate)coordList.get(i));
            ++i;
        }
        getMapRequest.setBbox(env);
        NamedNodeMap atts = bboxNode.getAttributes();
        Node srsNode = atts.getNamedItem("srsName");
        if (srsNode != null) {
            String srs = srsNode.getNodeValue();
            String epsgCode = srs.substring(srs.indexOf(35) + 1);
            epsgCode = "EPSG:" + epsgCode;
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMapRequest.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
    }

    private void parseXMLOutput(Node nodeGetMap, GetMapRequest getMapRequest) throws Exception {
        Node sizeNode;
        String bgColor;
        String bufferValue;
        Node outputNode = this.getNode(nodeGetMap, "Output");
        if (outputNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Output' in GetMap tag");
        }
        String format = this.getNodeValue(outputNode, "Format");
        if (format == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Format' in GetMap/Output tag");
        }
        getMapRequest.setFormat(format);
        String trans = this.getNodeValue(outputNode, "Transparent");
        if (trans != null) {
            if (trans.equalsIgnoreCase("false") || trans.equalsIgnoreCase("0")) {
                getMapRequest.setTransparent(false);
            } else {
                getMapRequest.setTransparent(true);
            }
        }
        if ((bufferValue = this.getNodeValue(outputNode, "Buffer")) != null) {
            getMapRequest.setBuffer(Integer.parseInt(bufferValue));
        }
        if ((bgColor = this.getNodeValue(outputNode, "BGcolor")) != null) {
            getMapRequest.setBgColor(Color.decode(bgColor));
        }
        if ((sizeNode = this.getNode(outputNode, "Size")) == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Size' in GetMap/Output tag");
        }
        String width = this.getNodeValue(sizeNode, "Width");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Width' in GetMap/Output/Size tag");
        }
        getMapRequest.setWidth(Integer.parseInt(width));
        String height = this.getNodeValue(sizeNode, "Height");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Height' in GetMap/Output/Size tag");
        }
        getMapRequest.setHeight(Integer.parseInt(height));
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    public String getNodeValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child.getChildNodes().item(0).getNodeValue();
                }
            }
            ++i;
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateSchemaSLD(File f, GetMapRequest getMapRequest) throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = null;
        try {
            FileInputStream in;
            block5: {
                in = null;
                try {
                    in = new FileInputStream(f);
                    errors = validator.validateSLD((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                    if (in == null) break block5;
                }
                in.close();
            }
            if (errors.size() == 0) return;
            in = new FileInputStream(f);
            throw new WmsException(SLDValidator.getErrorMessage((InputStream)in, (List)errors));
        }
        catch (IOException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            if (!LOGGER.isLoggable(Level.WARNING)) throw new WmsException(e, msg, "parseSldParam");
            LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "parseSldParam");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateSchemaGETMAP(File f, GetMapRequest getMapRequest) throws Exception {
        GETMAPValidator validator = new GETMAPValidator();
        List errors = null;
        try {
            FileInputStream in;
            block5: {
                in = null;
                try {
                    in = new FileInputStream(f);
                    errors = validator.validateGETMAP((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                    if (in == null) break block5;
                }
                in.close();
            }
            if (errors.size() == 0) return;
            in = new FileInputStream(f);
            throw new WmsException(GETMAPValidator.getErrorMessage((InputStream)in, (List)errors));
        }
        catch (IOException e) {
            String msg = "Creating remote GETMAP url: " + e.getMessage();
            if (!LOGGER.isLoggable(Level.WARNING)) throw new WmsException(e, msg, "GETMAP validator");
            LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "GETMAP validator");
        }
    }

    private boolean wantToValidate(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return (queryString = queryString.toLowerCase()).startsWith("validateschema") || queryString.indexOf("&validateschema") != -1;
    }
}

