/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.util.List;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.WMSRequest;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetMapRequest
extends WMSRequest {
    static final Color DEFAULT_BG = Color.white;
    public static final String SE_XML = "SE_XML";
    private static final String TRANSACTION_REQUEST_TYPE = "GetMap";
    private MandatoryParameters mandatoryParams = new MandatoryParameters();
    private OptionalParameters optionalParams = new OptionalParameters();

    public GetMapRequest(WMService service) {
        super(TRANSACTION_REQUEST_TYPE, service);
    }

    public Envelope getBbox() {
        return this.mandatoryParams.bbox;
    }

    public Color getBgColor() {
        return this.optionalParams.bgColor;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.optionalParams.crs;
    }

    public String getExceptions() {
        return this.optionalParams.exceptions;
    }

    public String getFormat() {
        return this.mandatoryParams.format;
    }

    public int getHeight() {
        return this.mandatoryParams.height;
    }

    public MapLayerInfo[] getLayers() {
        return this.mandatoryParams.layers;
    }

    public List getStyles() {
        return this.mandatoryParams.styles;
    }

    public List getFilters() {
        return this.optionalParams.filters;
    }

    public boolean isTransparent() {
        return this.optionalParams.transparent;
    }

    public int getBuffer() {
        return this.optionalParams.buffer;
    }

    public int getWidth() {
        return this.mandatoryParams.width;
    }

    public int getKMScore() {
        return this.optionalParams.KMScore;
    }

    public boolean getKMattr() {
        return this.optionalParams.KMattr;
    }

    public void setBbox(Envelope bbox) {
        this.mandatoryParams.bbox = bbox;
    }

    public void setBgColor(Color bgColor) {
        this.optionalParams.bgColor = bgColor;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.optionalParams.crs = crs;
    }

    public void setExceptions(String exceptions) {
        this.optionalParams.exceptions = exceptions;
    }

    public void setFormat(String format) {
        this.mandatoryParams.format = format;
    }

    public void setHeight(int height) {
        this.mandatoryParams.height = height;
    }

    public void setLayers(MapLayerInfo[] layers) {
        this.mandatoryParams.layers = layers;
    }

    public void setStyles(List styles) {
        this.mandatoryParams.styles = styles;
    }

    public void setFilters(List filters) {
        this.optionalParams.filters = filters;
    }

    public void setTransparent(boolean transparent) {
        this.optionalParams.transparent = transparent;
    }

    public void setBuffer(int buffer) {
        this.optionalParams.buffer = buffer;
    }

    public void setWidth(int width) {
        this.mandatoryParams.width = width;
    }

    public void setKMScore(int score) {
        this.optionalParams.KMScore = score;
    }

    public void setKMattr(boolean on) {
        this.optionalParams.KMattr = on;
    }

    private static final Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    private class MandatoryParameters {
        MapLayerInfo[] layers;
        List styles;
        Envelope bbox;
        int width;
        int height;
        String format;

        private MandatoryParameters() {
        }
    }

    private class OptionalParameters {
        Color bgColor = DEFAULT_BG;
        CoordinateReferenceSystem crs;
        List filters;
        String exceptions = "SE_XML";
        boolean transparent = false;
        int buffer;
        int KMScore = 40;
        boolean KMattr = true;

        private OptionalParameters() {
        }
    }
}

