/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetMapReflectKvpReader
extends GetMapKvpReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers.wms");
    private static final Map WMS_DEFAULTS = new HashMap();

    static {
        WMS_DEFAULTS.put("FORMAT", "image/png");
        WMS_DEFAULTS.put("WIDTH", "256");
        WMS_DEFAULTS.put("HEIGHT", "256");
        WMS_DEFAULTS.put("SRS", "EPSG:4326");
        WMS_DEFAULTS.put("TRANSPARENT", "true");
        WMS_DEFAULTS.put("STYLES", "");
        WMS_DEFAULTS.put("BBOX", "-180,-90,180,90");
        WMS_DEFAULTS.put("KMSCORE", "30");
    }

    public GetMapReflectKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetMapRequest request = new GetMapRequest((WMService)this.service);
        request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        request.setVersion(version);
        this.addDefaults();
        this.parseMandatoryParameters(request, true);
        this.parseOptionalParameters(request);
        return request;
    }

    public void addDefaults() {
        Iterator defaultPairsIterator = WMS_DEFAULTS.keySet().iterator();
        while (defaultPairsIterator.hasNext()) {
            Object key = defaultPairsIterator.next();
            if (this.kvpPairs.containsKey(key)) continue;
            this.kvpPairs.put(key, WMS_DEFAULTS.get(key));
        }
    }
}

