/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;
import org.xml.sax.InputSource;

public class GetMapKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers.wms");
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    private boolean stylesRequired = true;

    public GetMapKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
    }

    public void setStylesRequired(boolean parseStyles) {
        this.stylesRequired = parseStyles;
    }

    public boolean isStylesRquired() {
        return this.stylesRequired;
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetMapRequest request = new GetMapRequest((WMService)this.service);
        request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        request.setVersion(version);
        this.parseMandatoryParameters(request, true);
        this.parseOptionalParameters(request);
        return request;
    }

    public void parseOptionalParameters(GetMapRequest request) throws WmsException {
        String KMAttr;
        String transparentValue;
        String epsgCode = this.getValue("SRS");
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                request.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
        boolean transparent = (transparentValue = this.getValue("TRANSPARENT")) == null ? false : Boolean.valueOf(transparentValue);
        request.setTransparent(transparent);
        String bgcolor = this.getValue("BGCOLOR");
        if (bgcolor != null) {
            try {
                request.setBgColor(Color.decode(bgcolor));
            }
            catch (NumberFormatException nfe) {
                throw new WmsException("BGCOLOR " + bgcolor + " incorrectly specified (0xRRGGBB format expected)");
            }
        }
        this.parseFilterParam(request);
        String bufferValue = this.getValue("BUFFER");
        int buffer = 0;
        if (bufferValue != null) {
            try {
                buffer = Integer.parseInt(bufferValue);
            }
            catch (NumberFormatException nfe) {
                throw new WmsException("BUFFER " + bufferValue + " incorrectly specified (expected an integer)");
            }
        }
        request.setBuffer(buffer);
        String KMScore = this.getValue("KMSCORE");
        if (KMScore != null) {
            try {
                if (KMScore.equalsIgnoreCase("vector")) {
                    KMScore = "100";
                } else if (KMScore.equalsIgnoreCase("raster")) {
                    KMScore = "0";
                }
                Integer s = new Integer(KMScore);
                int score = s;
                if (score < 0 || score > 100) {
                    throw new NumberFormatException("KMScore not between 0 and 100. If you wish not to use it, do not specify KMScore as a parameter.");
                }
                request.setKMScore(score);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Set KMScore: " + score);
                }
            }
            catch (NumberFormatException e) {
                throw new WmsException("KMScore parameter (" + KMScore + ") incorrectly specified. " + "Expecting an integer value between between 0 and 100");
            }
        }
        if ((KMAttr = this.getValue("KMATTR")) != null) {
            if (KMAttr.equalsIgnoreCase("no") || KMAttr.equalsIgnoreCase("false") || KMAttr.equalsIgnoreCase("0")) {
                request.setKMattr(false);
            } else {
                request.setKMattr(true);
            }
        }
    }

    public void parseMandatoryParameters(GetMapRequest request, boolean parseStylesLayers) throws WmsException {
        try {
            int width = Integer.parseInt(this.getValue("WIDTH"));
            int height = Integer.parseInt(this.getValue("HEIGHT"));
            request.setWidth(width);
            request.setHeight(height);
        }
        catch (NumberFormatException ex) {
            throw new WmsException("WIDTH and HEIGHT incorrectly specified");
        }
        String format = this.getValue("FORMAT");
        if (format == null) {
            throw new WmsException("parameter FORMAT is required");
        }
        request.setFormat(format);
        Envelope bbox = this.parseBbox(this.getValue("BBOX"));
        request.setBbox(bbox);
        if (parseStylesLayers) {
            this.parseLayersAndStyles(request);
        }
    }

    protected Envelope parseBbox(String bboxParam) throws WmsException {
        try {
            return super.parseBbox(bboxParam);
        }
        catch (ServiceException e) {
            throw new WmsException(e);
        }
    }

    private List parseAttributes(FeatureTypeInfo[] layers) throws WmsException {
        String rawAtts = this.getValue("ATTRIBUTES");
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("parsing attributes " + rawAtts);
        }
        if (rawAtts == null || "".equals(rawAtts)) {
            return Collections.EMPTY_LIST;
        }
        List byFeatureTypes = GetMapKvpReader.readFlat((String)rawAtts, (String)"|");
        int nLayers = layers.length;
        if (byFeatureTypes.size() != nLayers) {
            throw new WmsException(String.valueOf(byFeatureTypes.size()) + " lists of attributes specified, expected " + layers.length, String.valueOf(((Object)((Object)this)).getClass().getName()) + "::parseAttributes()");
        }
        int i = 0;
        while (i < nLayers) {
            rawAtts = (String)byFeatureTypes.get(i);
            List atts = GetMapKvpReader.readFlat((String)rawAtts, (String)",");
            byFeatureTypes.set(i, atts);
            try {
                FeatureType schema = layers[i].getFeatureType();
                Iterator attIt = atts.iterator();
                while (attIt.hasNext()) {
                    String attName = (String)attIt.next();
                    if (attName.length() > 0) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("checking that " + attName + " is valid");
                        }
                        if ("#FID".equalsIgnoreCase(attName) || "#BOUNDS".equalsIgnoreCase(attName)) {
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("special attribute name requested: " + attName);
                            continue;
                        }
                        if (schema.getAttributeType(attName) != null) continue;
                        throw new WmsException("Attribute '" + attName + "' requested for layer " + schema.getTypeName() + " does not exists");
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("removing empty attribute name from request");
                    }
                    attIt.remove();
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("attributes requested for " + schema.getTypeName() + " checked: " + rawAtts);
                }
            }
            catch (IOException e) {
                throw new WmsException(e);
            }
            ++i;
        }
        return byFeatureTypes;
    }

    protected List parseStylesParam(GetMapRequest request, MapLayerInfo[] layers) throws WmsException {
        String rawStyles = this.getValue("STYLES");
        ArrayList<Style> styles = new ArrayList<Style>(layers.length);
        int numLayers = layers.length;
        if ("".equals(rawStyles)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Assigning default style to all the requested layers");
            }
            int i = 0;
            while (i < numLayers) {
                if (layers[i].getType() == MapLayerInfo.TYPE_VECTOR) {
                    styles.add(layers[i].getFeature().getDefaultStyle());
                } else if (layers[i].getType() == MapLayerInfo.TYPE_RASTER) {
                    styles.add(layers[i].getCoverage().getDefaultStyle());
                }
                ++i;
            }
        } else {
            List styleNames = GetMapKvpReader.readFlat((String)rawStyles, (String)",");
            if (numLayers != styleNames.size()) {
                String msg = String.valueOf(numLayers) + " layers requested, but found " + styleNames.size() + " styles specified. " + "Since SLD parameter is not yet implemented, the STYLES parameter " + "is mandatory and MUST have exactly one value per requested layer";
                throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
            }
            int i = 0;
            while (i < numLayers) {
                Style currStyle;
                String currStyleName = (String)styleNames.get(i);
                MapLayerInfo currLayer = layers[i];
                if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                    if (currStyleName == null || "".equals(currStyleName)) {
                        currStyle = currLayer.getFeature().getDefaultStyle();
                    } else {
                        currStyle = GetMapKvpReader.findStyle(request, currStyleName);
                        if (currStyle == null) {
                            String msg = "No default style has been defined for " + currLayer.getName();
                            throw new WmsException(msg, "StyleNotDefined");
                        }
                    }
                    try {
                        this.checkStyle(currStyle, layers[i].getFeature().getFeatureType());
                    }
                    catch (IOException e) {
                        throw new WmsException("Error obtaining FeatureType for layer " + layers[i].getName());
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("establishing " + currStyleName + " style for " + layers[i].getName());
                    }
                    styles.add(currStyle);
                } else if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                    if (currStyleName == null || "".equals(currStyleName)) {
                        currStyle = currLayer.getCoverage().getDefaultStyle();
                    } else {
                        currStyle = GetMapKvpReader.findStyle(request, currStyleName);
                        if (currStyle == null) {
                            String msg = "No default style has been defined for " + currLayer.getName();
                            throw new WmsException(msg, "GetMapKvpReader::parseStyles()");
                        }
                    }
                    styles.add(currStyle);
                }
                ++i;
            }
        }
        return styles;
    }

    public static Style findStyle(GetMapRequest request, String currStyleName) {
        Map configuredStyles = request.getWMS().getData().getStyles();
        Style currStyle = (Style)configuredStyles.get(currStyleName);
        return currStyle;
    }

    private void checkStyle(Style style, FeatureType fType) throws WmsException {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        int length = styleAttributes.length;
        int i = 0;
        while (i < length) {
            String attName = styleAttributes[i];
            if (fType.getAttributeType(attName) == null) {
                throw new WmsException("The requested Style can not be used with this featureType.  The style specifies an attribute of " + attName + " and the featureType definition is: " + fType);
            }
            ++i;
        }
    }

    protected void parseLayersAndStyles(GetMapRequest request) throws WmsException {
        String sldParam = this.getValue("SLD");
        String sldBodyParam = this.getValue("SLD_BODY");
        if (sldBodyParam != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            this.parseSldBodyParam(request);
        } else if (sldParam != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from reomte SLD");
            }
            this.parseSldParam(request);
        } else {
            MapLayerInfo[] featureTypes = null;
            List styles = null;
            featureTypes = this.parseLayersParam(request);
            request.setLayers(featureTypes);
            if (this.isStylesRquired()) {
                styles = this.parseStylesParam(request, featureTypes);
                if (this.isStylesRquired()) {
                    request.setStyles(styles);
                }
            }
        }
    }

    protected void parseSldBodyParam(GetMapRequest request) throws WmsException {
        Reader reader;
        String sldBody = this.getValue("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to parse SLD body: " + sldBody);
        }
        if (this.getValue("VALIDATESCHEMA") != null) {
            reader = this.getReaderFromString(sldBody);
            SLDValidator validator = new SLDValidator();
            List errors = null;
            InputSource in = new InputSource(reader);
            errors = validator.validateSLD(in, request.getHttpServletRequest().getSession().getServletContext());
            if (errors.size() != 0) {
                reader = this.getReaderFromString(sldBody);
                throw new WmsException(SLDValidator.getErrorMessage((Reader)reader, (List)errors));
            }
        }
        reader = this.getReaderFromString(sldBody);
        SLDParser parser = new SLDParser(styleFactory, reader);
        StyledLayerDescriptor sld = parser.parseSLD();
        this.parseStyledLayerDescriptor(request, sld);
    }

    private Reader getReaderFromString(String sldBody) {
        return new StringReader(sldBody);
    }

    protected void parseFilterParam(GetMapRequest request) throws WmsException {
        String rawFilter = this.getValue("FILTER");
        String rawCqlFilter = this.getValue("CQL_FILTER");
        String rawIdFilter = this.getValue("FEATUREID");
        if (request.getLayers() == null) {
            return;
        }
        int numLayers = request.getLayers().length;
        if (numLayers == 0) {
            throw new RuntimeException("parseFilterParam must be called after the layer list has been built!");
        }
        ArrayList<Filter> filters = null;
        if (rawFilter != null && !rawFilter.equals("")) {
            try {
                filters = this.readOGCFilter(rawFilter);
            }
            catch (ServiceException e) {
                throw new WmsException(e);
            }
        }
        if (rawIdFilter != null && !rawIdFilter.equals("")) {
            if (filters != null) {
                throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + rawFilter + ", fid: " + rawFilter);
            }
            filters = this.readFidFilters(rawFilter);
        }
        if (rawCqlFilter != null && !rawCqlFilter.equals("")) {
            if (filters != null) {
                throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + rawFilter + ", fid: " + rawFilter + ", cql: " + rawCqlFilter);
            }
            try {
                filters = this.readCQLFilter(rawCqlFilter);
            }
            catch (ServiceException e) {
                throw new WmsException(e);
            }
        }
        if (filters == null) {
            return;
        }
        if (numLayers != filters.size()) {
            if (filters.size() == 1) {
                Filter f = (Filter)filters.get(0);
                filters = new ArrayList<Filter>(numLayers);
                int i = 0;
                while (i < filters.size()) {
                    filters.add(f);
                    ++i;
                }
            } else {
                String msg = String.valueOf(numLayers) + " layers requested, but found " + filters.size() + " filters specified. " + "When you specify the FILTER parameter, you must provide just one, \n" + " that will be applied to all layers, or exactly one for each requested layer";
                throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
            }
        }
        request.setFilters(filters);
    }

    protected void parseSldParam(GetMapRequest request) throws WmsException {
        SLDParser parser;
        URL sldUrl;
        String urlValue = this.getValue("SLD");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("about to load remote SLD document: '" + urlValue + "'");
        }
        try {
            sldUrl = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new WmsException(e, msg, "parseSldParam");
        }
        if (this.getValue("VALIDATESCHEMA") != null) {
            SLDValidator validator = new SLDValidator();
            List errors = null;
            try {
                InputStream in = this.getInputStream(sldUrl);
                errors = validator.validateSLD(in, request.getHttpServletRequest().getSession().getServletContext());
                in.close();
                if (errors.size() != 0) {
                    throw new WmsException(SLDValidator.getErrorMessage((InputStream)sldUrl.openStream(), (List)errors));
                }
            }
            catch (IOException e) {
                String msg = "Creating remote SLD url: " + e.getMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, msg, e);
                }
                throw new WmsException(e, msg, "parseSldParam");
            }
        }
        try {
            parser = new SLDParser(styleFactory, this.getInputStream(sldUrl));
        }
        catch (IOException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new WmsException(e, msg, "parseSldParam");
        }
        StyledLayerDescriptor sld = parser.parseSLD();
        this.parseStyledLayerDescriptor(request, sld);
    }

    private void parseStyledLayerDescriptor(GetMapRequest request, StyledLayerDescriptor sld) throws WmsException {
        StyledLayer[] styledLayers;
        int slCount;
        MapLayerInfo[] libraryModeLayers = null;
        if (this.getValue("LAYERS") != null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("request comes in \"library\" mode");
            }
            libraryModeLayers = this.parseLayersParam(request);
        }
        if ((slCount = (styledLayers = sld.getStyledLayers()).length) == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        Style currStyle = null;
        if (libraryModeLayers != null) {
            int lCount = libraryModeLayers.length;
            int i = 0;
            while (i < lCount) {
                currLayer = libraryModeLayers[i];
                if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                    currStyle = this.findStyleOf(request, currLayer.getFeature(), styledLayers);
                } else if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                    currStyle = GetMapKvpReader.findStyle(request, "raster");
                }
                layers.add(currLayer);
                styles.add(currStyle);
                ++i;
            }
        } else {
            StyledLayer sl = null;
            int i = 0;
            while (i < slCount) {
                sl = styledLayers[i];
                String layerName = sl.getName();
                if (layerName == null) {
                    throw new WmsException("A UserLayer without layer name was passed");
                }
                currLayer = new MapLayerInfo();
                if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                    UserLayer ul = (UserLayer)sl;
                    currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore()));
                } else {
                    try {
                        currLayer.setFeature(GetMapKvpReader.findFeatureLayer(request, layerName));
                    }
                    catch (WmsException e) {
                        currLayer.setCoverage(GetMapKvpReader.findCoverageLayer(request, layerName));
                    }
                }
                if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                    GetMapKvpReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
                } else if (currLayer.getType() == MapLayerInfo.TYPE_RASTER) {
                    currStyle = GetMapKvpReader.findStyle(request, "raster");
                    layers.add(currLayer);
                    styles.add(currStyle);
                }
                ++i;
            }
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    public static void addStyles(GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List layers, List styles) throws WmsException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            t = 0;
            while (t < length) {
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() != null) {
                    boolean matches;
                    String ftc_name = ftc.getFeatureTypeName();
                    try {
                        matches = currLayer.getFeature().getFeatureType().isDescendedFrom(null, ftc_name) || currLayer.getFeature().getFeatureType().getTypeName().equalsIgnoreCase(ftc_name);
                    }
                    catch (Exception e) {
                        matches = false;
                    }
                    if (!matches) {
                        // empty if block
                    }
                }
                ++t;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        t = 0;
        while (t < length) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpReader.findStyle(request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
            } else {
                layers.add(currLayer);
                styles.add(layerStyles[t]);
            }
            ++t;
        }
    }

    private Style findStyleOf(GetMapRequest request, FeatureTypeInfo layer, StyledLayer[] styledLayers) throws WmsException {
        FeatureType type;
        Style style = null;
        String layerName = layer.getName();
        int i = 0;
        while (i < styledLayers.length) {
            StyledLayer sl = styledLayers[i];
            if (layerName.equals(sl.getName())) {
                if (sl instanceof UserLayer) {
                    Style[] styles = ((UserLayer)sl).getUserStyles();
                    if (styles == null || styles.length <= 0) break;
                    style = styles[0];
                    break;
                }
                if (sl instanceof NamedLayer) {
                    Style[] styles = ((NamedLayer)sl).getStyles();
                    if (styles != null && styles.length > 0) {
                        style = styles[0];
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpReader.findStyle(request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + sl);
            }
            ++i;
        }
        if (style == null) {
            style = layer.getDefaultStyle();
        }
        try {
            type = layer.getFeatureType();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error getting FeatureType, this should never happen!");
        }
        this.checkStyle(style, type);
        return style;
    }

    protected MapLayerInfo[] parseLayersParam(GetMapRequest request) throws WmsException {
        String layersParam = this.getValue("LAYERS");
        List layerNames = GetMapKvpReader.readFlat((String)layersParam, (String)",");
        ArrayList<String> realLayerNames = new ArrayList<String>();
        String layerName = null;
        Data catalog = request.getWMS().getData();
        String rawStyles = this.getValue("STYLES");
        List styleNames = GetMapKvpReader.readFlat((String)rawStyles, (String)",");
        int l_counter = 0;
        int s_counter = styleNames.size();
        Iterator it = layerNames.iterator();
        while (it.hasNext()) {
            layerName = (String)it.next();
            Integer layerType = catalog.getLayerType(layerName);
            if (layerType == null) {
                String catalogLayerName = null;
                int counter = l_counter;
                Iterator c_keys = catalog.getLayerNames().iterator();
                while (c_keys.hasNext()) {
                    catalogLayerName = (String)c_keys.next();
                    try {
                        FeatureTypeInfo ftype = GetMapKvpReader.findFeatureLayer(request, catalogLayerName);
                        String wmsPath = ftype.getWmsPath();
                        if (wmsPath != null && wmsPath.matches(".*/" + layerName)) {
                            realLayerNames.add(catalogLayerName);
                            if (++l_counter > s_counter) {
                                rawStyles = String.valueOf(rawStyles.length() > 0 ? String.valueOf(rawStyles) + "," : rawStyles) + ftype.getDefaultStyle().getName();
                            }
                        }
                    }
                    catch (WmsException e_1) {
                        try {
                            CoverageInfo cv = GetMapKvpReader.findCoverageLayer(request, catalogLayerName);
                            String wmsPath = cv.getWmsPath();
                            if (wmsPath != null && wmsPath.matches(".*/" + layerName)) {
                                realLayerNames.add(catalogLayerName);
                                if (++l_counter > s_counter) {
                                    rawStyles = String.valueOf(rawStyles.length() > 0 ? String.valueOf(rawStyles) + "," : rawStyles) + cv.getDefaultStyle().getName();
                                }
                            }
                        }
                        catch (WmsException wmsException) {
                            // empty catch block
                        }
                    }
                    if (counter != l_counter) continue;
                    throw new WmsException(layerName + ": no such layer on this server", "LayerNotDefined");
                }
                continue;
            }
            realLayerNames.add(layerName);
            ++l_counter;
        }
        this.kvpPairs.put("STYLES", rawStyles);
        int layerCount = realLayerNames.size();
        if (layerCount == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        MapLayerInfo[] layers = new MapLayerInfo[layerCount];
        int i = 0;
        while (i < layerCount) {
            layerName = (String)realLayerNames.get(i);
            layers[i] = new MapLayerInfo();
            try {
                FeatureTypeInfo ftype = GetMapKvpReader.findFeatureLayer(request, layerName);
                layers[i].setFeature(ftype);
            }
            catch (WmsException e) {
                CoverageInfo cv = GetMapKvpReader.findCoverageLayer(request, layerName);
                layers[i].setCoverage(cv);
            }
            ++i;
        }
        return layers;
    }

    public static FeatureTypeInfo findFeatureLayer(GetMapRequest request, String layerName) throws WmsException {
        Data catalog = request.getWMS().getData();
        FeatureTypeInfo ftype = null;
        Integer layerType = catalog.getLayerType(layerName);
        if (Data.TYPE_VECTOR != layerType) {
            throw new WmsException(layerName + ": no such layer on this server", "LayerNotDefined");
        }
        ftype = catalog.getFeatureTypeInfo(layerName);
        return ftype;
    }

    public static CoverageInfo findCoverageLayer(GetMapRequest request, String layerName) throws WmsException {
        Data catalog = request.getWMS().getData();
        CoverageInfo cv = null;
        Integer layerType = catalog.getLayerType(layerName);
        if (Data.TYPE_RASTER != layerType) {
            throw new WmsException(layerName + ": no such layer on this server", "LayerNotDefined");
        }
        cv = catalog.getCoverageInfo(layerName);
        return cv;
    }

    private InputStream getInputStream(URL sldUrl) throws IOException {
        URLConnection conn = sldUrl.openConnection();
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = "";
            }
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(conn.getInputStream());
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
            return conn.getInputStream();
        }
        return conn.getInputStream();
    }

    public void filterBaseMap(Map layers, Map styles) {
        String currentLayers = null;
        try {
            currentLayers = this.getValue("LAYERS");
        }
        catch (NullPointerException e) {
            LOGGER.fine("No layers defined. This is either wrong or they are listing the layers in an SLD document specified with the SLD= parameter");
            return;
        }
        String currentStyles = this.getValue("STYLES");
        String[] baseLayers = layers.keySet().toArray(new String[0]);
        String[] baseStyles = styles.keySet().toArray(new String[0]);
        boolean replacedOne = false;
        int i = 0;
        while (i < baseLayers.length) {
            int index = currentLayers.indexOf(baseLayers[i]);
            if (index > -1) {
                String newLayers;
                replacedOne = true;
                LOGGER.info("Using BASEMAP layer: " + baseLayers[i]);
                currentLayers = newLayers = currentLayers.replaceFirst(baseLayers[i], (String)layers.get(baseLayers[i]));
                if (styles != null && !styles.equals("")) {
                    String newStyles;
                    currentStyles = newStyles = currentStyles.replaceFirst(baseStyles[i], (String)styles.get(baseStyles[i]));
                }
            }
            ++i;
        }
        if (replacedOne) {
            this.kvpPairs.remove("LAYERS");
            this.kvpPairs.put("LAYERS", currentLayers);
            this.kvpPairs.remove("STYLES");
            this.kvpPairs.put("STYLES", currentStyles);
        }
    }
}

