/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.FactoryConfigurationError;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.operation.TransformException;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetLegendGraphicKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER;
    private static final StyleFactory styleFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.requests.GetLegendGraphicKvpReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
        styleFactory = StyleFactoryFinder.createStyleFactory();
    }

    public GetLegendGraphicKvpReader(Map params, WMService service) {
        super(params, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetLegendGraphicRequest request = new GetLegendGraphicRequest((WMService)this.getServiceRef());
        request.setHttpServletRequest(httpRequest);
        String version = super.getRequestVersion();
        String layer = this.getValue("LAYER");
        MapLayerInfo mli = new MapLayerInfo();
        try {
            WMS wms = request.getWMS();
            Data catalog = wms.getData();
            FeatureTypeInfo fti = catalog.getFeatureTypeInfo(layer);
            mli.setFeature(fti);
            request.setLayer(mli.getFeature().getFeatureType());
        }
        catch (NoSuchElementException e) {
            try {
                CoverageInfo cvi = request.getWMS().getData().getCoverageInfo(layer);
                mli.setCoverage(cvi);
                FeatureCollection feature = DataUtilities.wrapGc((GridCoverage)cvi.getCoverage(null, null));
                request.setLayer(feature.getFeatureType());
            }
            catch (NoSuchElementException ne) {
                throw new WmsException(ne, layer + " layer does not exists.", ne.getLocalizedMessage());
            }
            catch (TransformException te) {
                throw new WmsException(te, "Can't obtain the schema for the required layer.", te.getLocalizedMessage());
            }
            catch (FactoryConfigurationError fce) {
                throw new WmsException(fce, "Can't obtain the schema for the required layer.", fce.getLocalizedMessage());
            }
            catch (SchemaException se) {
                throw new WmsException(se, "Can't obtain the schema for the required layer.", se.getLocalizedMessage());
            }
            catch (IllegalAttributeException iae) {
                throw new WmsException(iae, "Can't obtain the schema for the required layer.", iae.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            throw new WmsException("Can't obtain the schema for the required layer.");
        }
        String format = this.getValue("FORMAT");
        if (this.getServiceRef().getApplicationContext() == null) {
            LOGGER.log(Level.SEVERE, "Application Context is null. No producer beans can be found!");
        } else {
            if (!GetLegendGraphicResponse.supportsFormat(format, (ApplicationContext)this.getServiceRef().getApplicationContext())) {
                throw new WmsException("Invalid graphic format: " + format, "InvalidFormat");
            }
            request.setFormat(format);
        }
        this.parseOptionalParameters(request, mli);
        return request;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, MapLayerInfo mli) throws WmsException {
        String exceptions;
        String height;
        String width;
        this.parseStyleAndRule(req, mli);
        String featureType = this.getValue("FEATURETYPE");
        String scale = this.getValue("SCALE");
        if (scale != null && !"".equals(scale)) {
            double scaleFactor = Double.valueOf(scale);
            req.setScale(scaleFactor);
        }
        if ((width = this.getValue("WIDTH")) != null && !"".equals(width)) {
            int legendW = Integer.valueOf(width);
            req.setWidth(legendW);
        }
        if ((height = this.getValue("HEIGHT")) != null && !"".equals(height)) {
            int legendH = Integer.valueOf(height);
            req.setHeight(legendH);
        }
        if ((exceptions = this.getValue("EXCEPTIONS")) != null) {
            req.setExceptionsFormat(exceptions);
        }
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, MapLayerInfo layer) throws WmsException {
        Style[] styles;
        String styleName = this.getValue("STYLE");
        String sldUrl = this.getValue("SLD");
        String sldBody = this.getValue("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("looking for style " + styleName);
        }
        Style sldStyle = null;
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            styles = this.loadRemoteStyle(sldUrl);
            sldStyle = this.findStyle(styleName, styles);
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            styles = this.parseSldBody(sldBody);
            sldStyle = this.findStyle(styleName, styles);
        } else if (styleName != null && !"".equals(styleName)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            sldStyle = req.getWMS().getData().getStyle(styleName);
        } else {
            sldStyle = layer.getDefaultStyle();
        }
        req.setStyle(sldStyle);
        String rule = this.getValue("RULE");
        Rule sldRule = this.extractRule(sldStyle, rule);
        if (sldRule != null) {
            req.setRule(sldRule);
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("request in library mode, looking for style " + styleName);
        }
        StringBuffer noMatchNames = new StringBuffer();
        int i = 0;
        while (i < styles.length) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i < styles.length) {
                noMatchNames.append(", ");
            }
            ++i;
        }
        throw new NoSuchElementException(String.valueOf(styleName) + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws WmsException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new WmsException(e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new WmsException(e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws WmsException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws WmsException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new WmsException(e);
        }
        if (styles == null || styles.length == 0) {
            throw new WmsException("Document contains no styles");
        }
        return styles;
    }

    private Rule extractRule(Style sldStyle, String rule) throws WmsException {
        Rule sldRule = null;
        if (rule != null && !"".equals(rule)) {
            FeatureTypeStyle[] fts = sldStyle.getFeatureTypeStyles();
            int i = 0;
            while (i < fts.length) {
                Rule[] rules = fts[i].getRules();
                int r = 0;
                while (r < rules.length) {
                    if (rule.equalsIgnoreCase(rules[r].getName())) {
                        sldRule = rules[r];
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("found requested rule: " + rule);
                        break;
                    }
                    ++r;
                }
                ++i;
            }
            if (sldRule == null) {
                throw new WmsException("Style " + sldStyle.getName() + " does not contains a rule named " + rule);
            }
        }
        return sldRule;
    }
}

