/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;

public class DescribeLayerKvpRequestReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.vfny.geoserver.wms.requests.DescribeLayerKvpRequestReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Logger.getLogger(clazz.getPackage().getName());
    }

    public DescribeLayerKvpRequestReader(Map params, WMService service) {
        super(params, service);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        int layerCount;
        DescribeLayerRequest req = new DescribeLayerRequest((WMService)this.service);
        req.setHttpServletRequest(request);
        String layersParam = this.getValue("LAYERS");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layersParam);
        }
        List layers = DescribeLayerKvpRequestReader.readFlat((String)layersParam, (String)",");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(layers.toString());
        }
        if ((layerCount = layers.size()) == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        Data catalog = req.getWMS().getData();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(catalog.toString());
        }
        String layerName = null;
        MapLayerInfo layer = null;
        int i = 0;
        while (i < layerCount) {
            block14: {
                layerName = (String)layers.get(i);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Looking for layer " + layerName);
                }
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("looking featuretypeinfos");
                    }
                    FeatureTypeInfo ftype = catalog.getFeatureTypeInfo(layerName);
                    layer = new MapLayerInfo();
                    layer.setFeature(ftype);
                    req.addLayer(layer);
                }
                catch (NoSuchElementException fex) {
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("looking coverageinfos");
                        }
                        CoverageInfo cinfo = catalog.getCoverageInfo(layerName);
                        layer = new MapLayerInfo();
                        layer.setCoverage(cinfo);
                        req.addLayer(layer);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(layerName + " found");
                        }
                    }
                    catch (NoSuchElementException cex) {
                        throw new WmsException(cex, String.valueOf(layerName) + ": no such layer on this server", "LayerNotDefined");
                    }
                    req.addLayer(layer);
                    if (!LOGGER.isLoggable(Level.FINE)) break block14;
                    LOGGER.fine(layerName + " found");
                }
            }
            ++i;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsed request " + (Object)((Object)req));
        }
        return req;
    }
}

