/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.sld.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.ExceptionHandler;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.sld.SldException;
import org.vfny.geoserver.sld.requests.PutStylesKvpReader;
import org.vfny.geoserver.sld.requests.PutStylesRequest;
import org.vfny.geoserver.sld.responses.PutStylesResponse;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.XmlCharsetDetector;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PutStyles
extends AbstractService {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.sld.servlets");
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    public final String success_mime_type = "application/vnd.ogc.success+xml";

    public PutStyles(WMS wms) {
        super("WMS", "PutStyles", (Service)wms);
    }

    protected boolean isServiceEnabled(HttpServletRequest req) {
        return true;
    }

    protected Response getResponseHandler() {
        return new PutStylesResponse();
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new PutStylesKvpReader(params, this);
    }

    protected XmlRequestReader getXmlRequestReader() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    protected ExceptionHandler getExceptionHandler() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PutStylesRequest serviceRequest;
        LOGGER.info("PutStyles.doGet()");
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        PutStylesKvpReader requestReader = new PutStylesKvpReader(requestParams, this);
        try {
            serviceRequest = (PutStylesRequest)requestReader.getRequest(request);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        ServletContext context = request.getSession().getServletContext();
        try {
            this.processSLD(serviceRequest, request, response, context);
        }
        catch (SldException e) {
            throw new ServletException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response, Reader requestXml) throws ServletException, IOException {
        PutStyles.LOGGER.fine("PutStyles POST");
        if (requestXml == null) {
            requestXml = new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)request.getInputStream()));
        }
        temp = File.createTempFile("putStylesPost", "xml");
        temp.deleteOnExit();
        fos = new FileOutputStream(temp);
        out = new BufferedOutputStream(fos);
        sb = new StringBuffer();
        if (requestXml != null) ** GOTO lbl15
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            chr = (char)c;
            out.write(c);
            sb.append(chr);
lbl15:
            // 2 sources

            ** while (-1 != (c = requestXml.read()))
        }
lbl16:
        // 1 sources

        requestXml.close();
        out.flush();
        out.close();
        requestXml = new BufferedReader(new FileReader(temp));
        serviceRequest = new PutStylesRequest(this);
        serviceRequest.setSldBody(sb.toString());
        context = request.getSession().getServletContext();
        try {
            this.processSLD(serviceRequest, request, response, context);
        }
        catch (SldException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Node generateDOM(Reader reader) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        Element rootNode = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource input = new InputSource(reader);
            Document dom = db.parse(input);
            rootNode = dom.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    public String getNodeValue(Node node) {
        return node.getChildNodes().item(0).getNodeValue();
    }

    public String getNodeChildValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child.getChildNodes().item(0).getNodeValue();
                }
            }
            ++i;
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    private void processSLD(PutStylesRequest serviceRequest, HttpServletRequest request, HttpServletResponse response, ServletContext context) throws IOException, SldException {
        File style_dir;
        LOGGER.info("Processing SLD");
        String sld_remote = serviceRequest.getSLD();
        if (sld_remote != null && !sld_remote.equals("")) {
            throw new UnsupportedOperationException("SLD= param not yet implemented. Use SLD_BODY=");
        }
        String sld_body = serviceRequest.getSldBody();
        if (sld_body == null || sld_body == "") {
            throw new IllegalArgumentException("The body of the SLD cannot be empty!");
        }
        File temp = File.createTempFile("putStyles", "xml");
        temp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(temp);
        BufferedOutputStream tempOut = new BufferedOutputStream(fos);
        byte[] bytes = sld_body.getBytes();
        int i = 0;
        while (i < bytes.length) {
            tempOut.write(bytes[i]);
            ++i;
        }
        tempOut.flush();
        tempOut.close();
        BufferedInputStream fs = new BufferedInputStream(new FileInputStream(temp));
        CharArrayReader xml = new CharArrayReader(sld_body.toCharArray());
        Node rootNode = this.generateDOM(xml);
        SLDValidator validator = new SLDValidator();
        List errors = validator.validateSLD((InputStream)fs, context);
        if (errors.size() != 0) {
            throw new SldException(SLDValidator.getErrorMessage((Reader)xml, (List)errors));
        }
        Node n_namedLayer = this.getNode(rootNode, "NamedLayer");
        Node n_layerName = this.getNode(n_namedLayer, "Name");
        Node n_userStyle = this.getNode(n_namedLayer, "UserStyle");
        Node n_styleName = this.getNode(n_userStyle, "Name");
        String layerName = this.getNodeValue(n_layerName);
        String styleName = this.getNodeValue(n_styleName);
        LOGGER.info("PutStyles SLD:\nLayer: " + layerName + ", style: " + styleName);
        StyleConfig style = new StyleConfig();
        style.setId(styleName);
        File data_dir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            style_dir = GeoserverDataDirectory.findConfigDir((File)data_dir, (String)"styles");
        }
        catch (ConfigurationException cfe) {
            LOGGER.warning("no style dir found, creating new one");
            style_dir = new File(data_dir, "styles");
        }
        File styleFile = new File(style_dir, String.valueOf(styleName) + ".sld");
        LOGGER.info("Saving new SLD file to " + styleFile.getPath());
        StringBuffer sldText = new StringBuffer();
        sldText.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sldText.append("<StyledLayerDescriptor version=\"1.0.0\"\n");
        sldText.append("\txsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\"\n");
        sldText.append("\txmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\"\n");
        sldText.append("\txmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        sldText.append("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        FileOutputStream style_fos = new FileOutputStream(styleFile);
        String sldBody = serviceRequest.getSldBody();
        int start = sldBody.indexOf("<NamedLayer>");
        int end = sldBody.indexOf("</NamedLayer>");
        sldText.append(sldBody.substring(start, end));
        sldText.append("</NamedLayer>\n");
        sldText.append("</StyledLayerDescriptor>");
        style_fos.write(sldText.toString().getBytes());
        style_fos.flush();
        style_fos.close();
        style.setFilename(styleFile);
        DataConfig dataConfig = ConfigRequests.getDataConfig((HttpServletRequest)request);
        dataConfig.addStyle(styleName, style);
        List keys = dataConfig.getFeatureTypeConfigKeys();
        Iterator it = keys.iterator();
        layerName = null;
        while (it.hasNext()) {
            String o = it.next().toString();
            String[] os = o.split(":");
            if (!os[1].equalsIgnoreCase(layerName)) continue;
            layerName = o;
            break;
        }
        if (layerName != null) {
            FeatureTypeConfig featureTypeConfig = dataConfig.getFeatureTypeConfig(layerName);
            featureTypeConfig.setDefaultStyle(styleName);
        }
        LOGGER.info("sending back result");
        String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sld:success>success</sld:success>";
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        byte[] msg = message.getBytes();
        out.write(msg);
        out.flush();
    }
}

