/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapXmlReader;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetMap
extends WMService {
    public static final String URLENCODED = "application/x-www-form-urlencoded";

    public GetMap(WMS wms) {
        super("GetMap", wms);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isURLEncoded(request)) {
            this.doGet(request, response);
            return;
        }
        Request serviceRequest = null;
        this.curRequest = request;
        if (!this.isServiceEnabled(request)) {
            response.sendError(503);
            return;
        }
        try {
            GetMapXmlReader xmlPostReader = new GetMapXmlReader(this);
            BufferedReader xml = request.getReader();
            serviceRequest = xmlPostReader.read(xml, request);
        }
        catch (ServiceException se) {
            this.sendError(response, se);
            return;
        }
        catch (Throwable e) {
            this.sendError(response, e);
            return;
        }
        this.doService(request, response, serviceRequest);
    }

    protected Response getResponseHandler() {
        return new GetMapResponse(this.getWMS(), (ApplicationContext)this.getApplicationContext());
    }

    protected XmlRequestReader getXmlRequestReader() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    protected KvpRequestReader getKvpReader(Map params) {
        Map layers = this.getWMS().getBaseMapLayers();
        Map styles = this.getWMS().getBaseMapStyles();
        GetMapKvpReader kvp = new GetMapKvpReader(params, this);
        if (layers != null && !((Object)layers).equals("")) {
            kvp.filterBaseMap(layers, styles);
        }
        return kvp;
    }

    public boolean isURLEncoded(HttpServletRequest req) {
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(URLENCODED);
    }
}

