/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.pdf;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.pdf.PDFMapProducer;

public class PDFMapProducerFactory
implements GetMapProducerFactorySpi {
    static final String MIME_TYPE = "application/pdf";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("application/pdf");

    public String getName() {
        return "Portable Document Format (PDF) map producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        try {
            Class.forName("com.lowagie.text.pdf.PdfTemplate");
            Class.forName("com.lowagie.text.Document");
            Class.forName("com.lowagie.text.FontFactory");
            Class.forName("com.lowagie.text.pdf.DefaultFontMapper");
            Class.forName("com.lowagie.text.pdf.PdfContentByte");
            Class.forName("com.lowagie.text.pdf.PdfTemplate");
            Class.forName("com.lowagie.text.pdf.PdfWriter");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean canProduce(String mapFormat) {
        return MIME_TYPE.equals(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (!this.canProduce(mapFormat)) {
            throw new IllegalArgumentException(mapFormat + " not supported by this map producer");
        }
        return new PDFMapProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

