/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.EncodeKML;

class KMZMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.kmz");
    private EncodeKML kmlEncoder;
    private File temp;

    KMZMapProducer() {
    }

    public void abort(Service gs) {
        this.kmlEncoder.abort();
    }

    public String getContentType() {
        return "application/vnd.google-earth.kmz";
    }

    public void abort() {
        LOGGER.fine("aborting KMZ map response");
        if (this.kmlEncoder != null) {
            LOGGER.info("aborting KMZ encoder");
            this.kmlEncoder.abort();
        }
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        this.kmlEncoder = new EncodeKML(map);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        ZipOutputStream outZ = new ZipOutputStream(out);
        this.kmlEncoder.encodeKMZ(outZ);
        outZ.finish();
        ((FilterOutputStream)outZ).flush();
    }
}

