/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import javax.xml.transform.TransformerException;
import org.geotools.data.DataSourceException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.AbortedException;

public class KMLWriter
extends OutputStreamWriter {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter == null ? (class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter = KMLWriter.class$("org.vfny.geoserver.wms.responses.map.kml.KMLWriter")) : class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter).getPackage().getName());
    private static DecimalFormat formatter;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    private double scaleDenominator = 1.0;
    private static final double TOLERANCE = 1.0E-6;
    private CoordinateReferenceSystem sourceCrs;
    private GeometryTransformer transformer;
    private WMSMapContext mapContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$map$kml$KMLWriter;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public KMLWriter(OutputStream out, WMSMapContext mapContext) {
        super(out);
        this.mapContext = mapContext;
        this.transformer = new GeometryTransformer();
        this.transformer.setOmitXMLDeclaration(true);
        this.transformer.setNamespaceDeclarationEnabled(true);
        GeoServer config = mapContext.getRequest().getGeoServer();
        this.transformer.setNumDecimals(config.getNumDecimals());
    }

    public void setMaximunFractionDigits(int numDigits) {
        formatter.setMaximumFractionDigits(numDigits);
    }

    public int getMaximunFractionDigits() {
        return formatter.getMaximumFractionDigits();
    }

    public void setMinimunFractionDigits(int numDigits) {
        formatter.setMinimumFractionDigits(numDigits);
    }

    public int getMinimunFractionDigits() {
        return formatter.getMinimumFractionDigits();
    }

    public void setRequestedScale(double scale) {
        this.scaleDenominator = scale;
    }

    public void setSourceCrs(CoordinateReferenceSystem crs) {
        this.sourceCrs = crs;
    }

    public void write(double d) throws IOException {
        this.write(formatter.format(d));
    }

    public void newline() throws IOException {
        super.write(10);
    }

    public void writeFeaturesAsRaster(FeatureCollection features, MapLayer layer, int order) throws IOException, AbortedException {
        Style style = layer.getStyle();
        try {
            FeatureType featureType = features.getSchema();
            this.setUpWriterHandler(featureType);
            FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
            this.processStylersRaster(features, fts, layer, order);
            LOGGER.fine("encoded " + featureType.getTypeName().toString());
        }
        catch (NoSuchElementException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAttributeException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void writeFeaturesAsVectors(FeatureCollection features, MapLayer layer) throws IOException, AbortedException {
        Style style = layer.getStyle();
        try {
            FeatureType featureType = features.getSchema();
            this.setUpWriterHandler(featureType);
            FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
            this.processStylersVector(features, fts, layer);
            LOGGER.fine("encoded " + featureType.getTypeName().toString());
        }
        catch (NoSuchElementException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAttributeException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void startFolder(String name, String description) throws IOException {
        this.write("<Folder>");
        if (name != null) {
            this.write("<name>" + name + "</name>");
        }
        if (description != null) {
            this.write("<description>" + description + "</description>");
        }
    }

    public void startDocument(String name, String description) throws IOException {
        this.write("<Document>");
        if (name != null) {
            this.write("<name>" + name + "</name>");
        }
        if (description != null) {
            this.write("<description>" + description + "</description>");
        }
    }

    public void endFolder() throws IOException {
        this.write("</Folder>");
    }

    public void endDocument() throws IOException {
        this.write("</Document>");
    }

    private void setUpWriterHandler(FeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        ArrayList atts = new ArrayList(0);
    }

    protected void writeGeometry(Geometry geom, GeometryTransformer trans) throws IOException, TransformerException {
        if (this.isMultiPart(geom)) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                this.writeGeometry(geom.getGeometryN(i), trans);
            }
        } else {
            StringWriter tempWriter = new StringWriter();
            trans.transform((Object)geom, (Writer)tempWriter);
            String tempBuffer = tempWriter.toString();
            this.write(tempBuffer.replaceAll("gml:", ""));
        }
    }

    protected void writeLookAt(Geometry geom, GeometryTransformer trans) throws IOException, TransformerException {
        Coordinate[] coordinates = this.getCentroid(geom).getCoordinates();
        this.write("<LookAt>");
        this.write("<longitude>" + coordinates[0].x + "</longitude>");
        this.write("<latitude>" + coordinates[0].y + "</latitude>");
        this.write("<range>700</range>");
        this.write("<tilt>10.0</tilt>");
        this.write("<heading>10.0</heading>");
        this.write("</LookAt>");
    }

    protected void writePlaceMarkPoint(Geometry geom, GeometryTransformer trans) throws IOException, TransformerException {
        Coordinate[] coordinates = this.getCentroid(geom).getCoordinates();
        this.write("<Point><coordinates>" + coordinates[0].x + "," + coordinates[0].y + "," + coordinates[0].z + "</coordinates></Point>");
    }

    protected boolean isMultiPart(Geometry geom) {
        Class<?> geomClass = geom.getClass();
        return geomClass.equals(class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = KMLWriter.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon) || geomClass.equals(class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = KMLWriter.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) || geomClass.equals(class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = KMLWriter.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString);
    }

    private void processStylersVector(FeatureCollection features, FeatureTypeStyle[] featureStylers, MapLayer layer) throws IOException, IllegalAttributeException {
        int ftsLength = featureStylers.length;
        for (int i = 0; i < ftsLength; ++i) {
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = features.getSchema().getTypeName();
            if (typeName == null || !features.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList ruleList = new ArrayList();
            ArrayList elseRuleList = new ArrayList();
            this.populateRuleLists(rules, ruleList, elseRuleList, false);
            if (ruleList.size() == 0 && elseRuleList.size() == 0) {
                return;
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            FeatureIterator reader = features.features();
            while (true) {
                try {
                    while (reader.hasNext()) {
                        Rule r;
                        boolean doElse = true;
                        Feature feature = reader.next();
                        StringBuffer featureLabel = new StringBuffer("");
                        this.startDocument(feature.getID(), layer.getTitle());
                        this.write("<Style id=\"GeoServerStyle" + feature.getID() + "\">");
                        Iterator it = ruleList.iterator();
                        while (it.hasNext()) {
                            r = (Rule)it.next();
                            LOGGER.finer("applying rule: " + r.toString());
                            Filter filter = r.getFilter();
                            if (filter != null && !filter.contains(feature)) continue;
                            doElse = false;
                            LOGGER.finer("processing Symobolizer ...");
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            this.processVectorSymbolizers(feature, symbolizers, (Range)scaleRange, featureLabel);
                        }
                        if (doElse) {
                            LOGGER.finer("rules with an else filter");
                            it = elseRuleList.iterator();
                            while (it.hasNext()) {
                                r = (Rule)it.next();
                                Symbolizer[] symbolizers = r.getSymbolizers();
                                LOGGER.finer("processing Symobolizer ...");
                                this.processVectorSymbolizers(feature, symbolizers, (Range)scaleRange, featureLabel);
                            }
                        }
                        this.write("</Style>");
                        String fTitle = featureLabel.toString();
                        if (fTitle.equals("")) {
                            fTitle = feature.getID();
                        }
                        this.write("<Placemark>");
                        this.write("<name><![CDATA[" + featureLabel + "]]></name>");
                        FeatureType schema = features.getSchema();
                        StringBuffer description = new StringBuffer();
                        this.makeDescription(feature, schema, description);
                        this.write("<description><![CDATA[" + description.toString() + "]]></description>");
                        this.writeLookAt(this.findGeometry(feature), this.transformer);
                        this.write("<styleUrl>#GeoServerStyle" + feature.getID() + "</styleUrl>");
                        this.write("<MultiGeometry>");
                        this.writePlaceMarkPoint(this.findGeometry(feature), this.transformer);
                        this.writeGeometry(this.findGeometry(feature), this.transformer);
                        this.write("</MultiGeometry>");
                        this.write("</Placemark>");
                        this.newline();
                        this.endDocument();
                    }
                }
                catch (Exception e) {
                    LOGGER.warning("KML transform for feature failed " + e.getMessage());
                    continue;
                }
                break;
            }
            features.close(reader);
        }
    }

    private void processStylersRaster(FeatureCollection features, FeatureTypeStyle[] featureStylers, MapLayer layer, int order) throws IOException, IllegalAttributeException {
        this.startFolder("layer_" + order, layer.getTitle());
        int layerCounter = order;
        int ftStylesLength = featureStylers.length;
        for (int i = 0; i < ftStylesLength; ++i) {
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = features.getSchema().getTypeName();
            if (typeName == null || !features.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList ruleList = new ArrayList();
            ArrayList elseRuleList = new ArrayList();
            this.populateRuleLists(rules, ruleList, elseRuleList, true);
            if (ruleList.size() == 0 && elseRuleList.size() == 0) {
                return;
            }
            FeatureIterator reader = features.features();
            try {
                Rule r;
                if (!reader.hasNext()) continue;
                boolean doElse = true;
                Feature feature = reader.next();
                Iterator it = ruleList.iterator();
                while (it.hasNext()) {
                    r = (Rule)it.next();
                    LOGGER.finer("applying rule: " + r.toString());
                    Filter filter = r.getFilter();
                    if (filter != null && !filter.contains(feature)) continue;
                    doElse = false;
                    LOGGER.finer("processing raster-result Symobolizer ...");
                    Symbolizer[] symbolizers = r.getSymbolizers();
                    this.processRasterSymbolizers(feature, symbolizers, order);
                    ++layerCounter;
                }
                if (doElse) {
                    LOGGER.finer("rules with an else filter");
                    it = elseRuleList.iterator();
                    while (it.hasNext()) {
                        r = (Rule)it.next();
                        Symbolizer[] symbolizers = r.getSymbolizers();
                        LOGGER.finer("processing raster-result Symobolizer ...");
                        this.processRasterSymbolizers(feature, symbolizers, order);
                        ++layerCounter;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warning("KML transform for feature failed " + e.getMessage());
            }
            features.close(reader);
        }
        this.endFolder();
    }

    private void populateRuleLists(Rule[] rules, List ruleList, List elseRuleList, boolean ignoreScale) {
        int rulesLength = rules.length;
        for (int j = 0; j < rulesLength; ++j) {
            Rule r = rules[j];
            if (ignoreScale) {
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
                continue;
            }
            if (!this.isWithinScale(r)) continue;
            if (r.hasElseFilter()) {
                elseRuleList.add(r);
                continue;
            }
            ruleList.add(r);
        }
    }

    private void makeDescription(Feature feature, FeatureType schema, StringBuffer description) {
        if (this.mapContext.getRequest().getKMattr()) {
            description.append("<table border='1'>");
            description.append("<tr><th colspan=").append(schema.getAttributeCount()).append(" scope='col'>").append(schema.getTypeName()).append(" </th></tr>");
            description.append("<tr>");
            int attrCount = schema.getAttributeCount();
            for (int j = 0; j < attrCount; ++j) {
                description.append("<td>").append(schema.getAttributeType(j).getName()).append("</td>");
            }
            description.append("</tr>");
            AttributeType[] types = schema.getAttributeTypes();
            description.append("<tr>");
            int typesLength = types.length;
            for (int j = 0; j < typesLength; ++j) {
                if ((class$com$vividsolutions$jts$geom$Geometry == null ? KMLWriter.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(types[j].getType())) {
                    description.append("<td>");
                    description.append("[GEOMETRY]");
                    description.append("</td>");
                    continue;
                }
                description.append("<td>");
                description.append(feature.getAttribute(types[j].getName()));
                description.append("</td>");
            }
            description.append("</tr>");
            description.append("</table>");
        }
    }

    private void processVectorSymbolizers(Feature feature, Symbolizer[] symbolizers, Range scaleRange, StringBuffer featureLabel) throws IOException, TransformerException {
        int length = symbolizers.length;
        for (int m = 0; m < length; ++m) {
            LOGGER.finer("applying symbolizer " + symbolizers[m]);
            if (symbolizers[m] instanceof TextSymbolizer) {
                TextSymbolizer ts = (TextSymbolizer)symbolizers[m];
                Expression ex = ts.getLabel();
                featureLabel.append((String)ex.getValue(feature));
                Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
                this.writeStyle(style, feature.getID(), symbolizers[m]);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.writeStyle(style, feature.getID(), symbolizers[m]);
        }
    }

    private void processRasterSymbolizers(Feature feature, Symbolizer[] symbolizers, int order) throws IOException, TransformerException {
        if (symbolizers.length < 1) {
            return;
        }
        LOGGER.finer("applying one symbolizer: " + symbolizers[0].toString());
        Envelope envelope = this.mapContext.getRequest().getBbox();
        this.write("<GroundOverlay>" + "<name>" + feature.getID() + "</name>" + "<drawOrder>" + order + "</drawOrder>" + "<Icon>");
        double[] BBOX = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        this.write("<href>layer_" + order + ".png</href>" + "<viewRefreshMode>never</viewRefreshMode>" + "<viewBoundScale>0.75</viewBoundScale>" + "</Icon>" + "<LatLonBox>" + "<north>" + BBOX[3] + "</north>" + "<south>" + BBOX[1] + "</south>" + "<east>" + BBOX[2] + "</east>" + "<west>" + BBOX[0] + "</west>" + "</LatLonBox>" + "</GroundOverlay>");
    }

    private boolean processSymbolizers(FeatureCollection features, Feature feature, Symbolizer[] symbolizers, Range scaleRange, MapLayer layer, int order, int layerCounter, StringBuffer title, boolean vectorResult) throws IOException, TransformerException {
        boolean res = false;
        int length = symbolizers.length;
        for (int m = 0; m < length; ++m) {
            LOGGER.finer("applying symbolizer " + symbolizers[m]);
            if (symbolizers[m] instanceof RasterSymbolizer) {
                res = true;
                continue;
            }
            if (vectorResult) {
                if (symbolizers[m] instanceof TextSymbolizer) {
                    TextSymbolizer ts = (TextSymbolizer)symbolizers[m];
                    Expression ex = ts.getLabel();
                    String value = (String)ex.getValue(feature);
                    title.append(value);
                    Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
                    this.writeStyle(style, feature.getID(), symbolizers[m]);
                    continue;
                }
                Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
                this.writeStyle(style, feature.getID(), symbolizers[m]);
                continue;
            }
            if (!vectorResult) {
                Envelope envelope = this.mapContext.getRequest().getBbox();
                this.write("<GroundOverlay>" + "<name>" + feature.getID() + "</name>" + "<drawOrder>" + order + "</drawOrder>" + "<Icon>");
                double[] BBOX = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
                this.write("<href>layer_" + order + ".png</href>" + "<viewRefreshMode>never</viewRefreshMode>" + "<viewBoundScale>0.75</viewBoundScale>" + "</Icon>" + "<LatLonBox>" + "<north>" + BBOX[3] + "</north>" + "<south>" + BBOX[1] + "</south>" + "<east>" + BBOX[2] + "</east>" + "<west>" + BBOX[0] + "</west>" + "</LatLonBox>" + "</GroundOverlay>");
                continue;
            }
            LOGGER.info("KMZ processSymbolizerz unknown case. Please report error.");
        }
        return res;
    }

    private void writeStyle(Style2D style, String id, Symbolizer sym) throws IOException {
        if (style instanceof PolygonStyle2D && sym instanceof PolygonSymbolizer) {
            int opacity;
            if (((PolygonStyle2D)style).getFill() == null && ((PolygonStyle2D)style).getStroke() == null) {
                LOGGER.info("Empty PolygonSymbolizer, using default fill and stroke.");
            }
            StringBuffer styleString = new StringBuffer();
            PolygonSymbolizer polySym = (PolygonSymbolizer)sym;
            styleString.append("<IconStyle>");
            if (!this.mapContext.getRequest().getKMattr()) {
                styleString.append("<color>#00ffffff</color>");
            }
            styleString.append("<Icon><href>root://icons/palette-3.png</href><x>224</x><w>32</w><h>32</h></Icon>");
            styleString.append("</IconStyle>");
            styleString.append("<PolyStyle><color>");
            if (polySym.getFill() != null) {
                Paint p;
                opacity = 255;
                if (polySym.getFill().getOpacity() != null) {
                    float op = this.getOpacity(polySym.getFill().getOpacity());
                    opacity = new Float(255.0f * op).intValue();
                }
                if ((p = ((PolygonStyle2D)style).getFill()) instanceof Color) {
                    styleString.append("#").append(this.intToHex(opacity)).append(this.colorToHex((Color)p));
                } else {
                    styleString.append("#ffaaaaaa");
                }
            } else {
                styleString.append("#ffaaaaaa");
            }
            styleString.append("</color>");
            if (polySym.getStroke() != null) {
                styleString.append("<outline>1</outline>");
            } else {
                styleString.append("<outline>0</outline>");
            }
            styleString.append("</PolyStyle>");
            if (polySym.getStroke() != null) {
                Paint p;
                styleString.append("<LineStyle><color>");
                opacity = 255;
                if (polySym.getStroke().getOpacity() != null) {
                    float op = this.getOpacity(polySym.getStroke().getOpacity());
                    opacity = new Float(255.0f * op).intValue();
                }
                if ((p = ((PolygonStyle2D)style).getContour()) instanceof Color) {
                    styleString.append("#").append(this.intToHex(opacity)).append(this.colorToHex((Color)p));
                } else {
                    styleString.append("#ffaaaaaa");
                }
                styleString.append("</color>");
                if (polySym.getStroke().getWidth() != null) {
                    int width = this.getWidth(polySym.getStroke().getWidth());
                    styleString.append("<width>").append(width).append("</width>");
                }
                styleString.append("</LineStyle>");
            }
            this.write(styleString.toString());
        } else if (style instanceof LineStyle2D && sym instanceof LineSymbolizer) {
            if (((LineStyle2D)style).getStroke() == null) {
                LOGGER.info("Empty LineSymbolizer, using default stroke.");
            }
            LineSymbolizer lineSym = (LineSymbolizer)sym;
            StringBuffer styleString = new StringBuffer();
            styleString.append("<IconStyle>");
            if (!this.mapContext.getRequest().getKMattr()) {
                styleString.append("<color>#00ffffff</color>");
            }
            styleString.append("</IconStyle>");
            styleString.append("<LineStyle><color>");
            if (lineSym.getStroke() != null) {
                Paint p;
                int opacity = 255;
                if (lineSym.getStroke().getOpacity() != null) {
                    float op = this.getOpacity(lineSym.getStroke().getOpacity());
                    opacity = new Float(255.0f * op).intValue();
                }
                if ((p = ((LineStyle2D)style).getContour()) instanceof Color) {
                    styleString.append("#").append(this.intToHex(opacity)).append(this.colorToHex((Color)p));
                } else {
                    styleString.append("#ffaaaaaa");
                }
                styleString.append("</color>");
                if (lineSym.getStroke().getWidth() != null) {
                    int width = this.getWidth(lineSym.getStroke().getWidth());
                    styleString.append("<width>").append(width).append("</width>");
                }
            } else {
                styleString.append("#ffaaaaaa");
                styleString.append("</color><width>1</width>");
            }
            styleString.append("</LineStyle>");
            this.write(styleString.toString());
        } else if (style instanceof TextStyle2D && sym instanceof TextSymbolizer) {
            StringBuffer styleString = new StringBuffer();
            TextSymbolizer textSym = (TextSymbolizer)sym;
            styleString.append("<LabelStyle><color>");
            if (textSym.getFill() != null) {
                Paint p;
                int opacity = 255;
                if (textSym.getFill().getOpacity() != null) {
                    float op = this.getOpacity(textSym.getFill().getOpacity());
                    opacity = new Float(255.0f * op).intValue();
                }
                if ((p = ((TextStyle2D)style).getFill()) instanceof Color) {
                    styleString.append("#").append(this.intToHex(opacity)).append(this.colorToHex((Color)p));
                } else {
                    styleString.append("#ffaaaaaa");
                }
                styleString.append("</color></LabelStyle>");
            } else {
                styleString.append("#ffaaaaaa");
                styleString.append("</color></LabelStyle>");
            }
            this.write(styleString.toString());
        }
    }

    private void writeRasterStyle(String href, String id) throws IOException {
        StringBuffer styleString = new StringBuffer();
        styleString.append("<Style id=\"GeoServerStyle").append(id).append("\">");
        styleString.append("<IconStyle><Icon><href>").append(href).append("</href><viewRefreshMode>never</viewRefreshMode>").append("<viewBoundScale>0.75</viewBoundScale><w>").append(this.mapContext.getMapWidth()).append("</w><h>").append(this.mapContext.getMapHeight()).append("</h></Icon></IconStyle>");
        styleString.append("<PolyStyle><fill>0</fill><outline>0</outline></PolyStyle>");
        styleString.append("</Style>");
        this.write(styleString.toString());
    }

    private boolean isWithinScale(Rule r) {
        double min = r.getMinScaleDenominator();
        double max = r.getMaxScaleDenominator();
        return min - 1.0E-6 <= this.scaleDenominator && max + 1.0E-6 >= this.scaleDenominator;
    }

    private Geometry findGeometry(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        Geometry geom = geomName == null ? f.getDefaultGeometry() : (Geometry)f.getAttribute(geomName);
        if (s instanceof PointSymbolizer) {
            geom = this.getCentroid(geom);
        }
        return geom;
    }

    private Geometry findGeometry(Feature f) {
        Geometry geom = f.getDefaultGeometry();
        if (!CRS.equalsIgnoreMetadata((Object)this.sourceCrs, (Object)this.mapContext.getCoordinateReferenceSystem())) {
            try {
                MathTransform transform = CRS.transform((CoordinateReferenceSystem)this.sourceCrs, (CoordinateReferenceSystem)this.mapContext.getCoordinateReferenceSystem(), (boolean)true);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform);
            }
            catch (MismatchedDimensionException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
            catch (TransformException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
            catch (FactoryException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
        }
        return geom;
    }

    public Geometry getCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
            for (int t = 0; t < gc.getNumGeometries(); ++t) {
                pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
            }
            return g.getFactory().createMultiPoint(pts);
        }
        return g.getCentroid();
    }

    private CoordinateReferenceSystem findGeometryCS(Feature f, Symbolizer s) {
        String geomName = this.getGeometryPropertyName(s);
        if (geomName != null) {
            return ((GeometryAttributeType)f.getFeatureType().getAttributeType(geomName)).getCoordinateSystem();
        }
        return f.getFeatureType().getDefaultGeometry().getCoordinateSystem();
    }

    private String getGeometryPropertyName(Symbolizer s) {
        String geomName = null;
        if (s instanceof PolygonSymbolizer) {
            geomName = ((PolygonSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof PointSymbolizer) {
            geomName = ((PointSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof LineSymbolizer) {
            geomName = ((LineSymbolizer)s).getGeometryPropertyName();
        } else if (s instanceof TextSymbolizer) {
            geomName = ((TextSymbolizer)s).getGeometryPropertyName();
        }
        return geomName;
    }

    private String intToHex(int i) {
        String prelim = Integer.toHexString(i);
        if (prelim.length() < 2) {
            prelim = "0" + prelim;
        }
        return prelim;
    }

    private String colorToHex(Color c) {
        return this.intToHex(c.getBlue()) + this.intToHex(c.getGreen()) + this.intToHex(c.getRed());
    }

    private float getOpacity(Symbolizer sym) {
        float alpha = 1.0f;
        Expression exp = null;
        if (sym instanceof PolygonSymbolizer) {
            exp = ((PolygonSymbolizer)sym).getFill().getOpacity();
        } else if (sym instanceof LineSymbolizer) {
            exp = ((LineSymbolizer)sym).getStroke().getOpacity();
        } else if (sym instanceof PointSymbolizer) {
            exp = ((PointSymbolizer)sym).getGraphic().getOpacity();
        } else if (sym instanceof TextSymbolizer) {
            exp = ((TextSymbolizer)sym).getFill().getOpacity();
        } else {
            LOGGER.info("Symbolizer not matched; was of class: " + sym);
        }
        if (exp == null) {
            LOGGER.info("Could not determine proper symbolizer opacity.");
            return alpha;
        }
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private float getOpacity(Expression exp) {
        float alpha = 1.0f;
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private int getWidth(Expression exp) {
        int alpha = 1;
        Object obj = exp.getValue(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.intValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Locale locale = new Locale("en", "US");
        DecimalFormatSymbols decimalSymbols = new DecimalFormatSymbols(locale);
        decimalSymbols.setDecimalSeparator('.');
        formatter = new DecimalFormat();
        formatter.setDecimalFormatSymbols(decimalSymbols);
        formatter.setGroupingSize(0);
        formatter.setDecimalSeparatorAlwaysShown(false);
        formatter.setDecimalFormatSymbols(null);
        formatter.setMaximumFractionDigits(5);
        formatter.setMinimumFractionDigits(0);
    }
}

