/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.EncodeKML;

class KMLMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.kml");
    private EncodeKML kmlEncoder;

    KMLMapProducer() {
    }

    public void abort(Service gs) {
        this.kmlEncoder.abort();
    }

    public String getContentType() {
        return "application/vnd.google-earth.kml+xml";
    }

    public void abort() {
        LOGGER.fine("aborting KML map response");
        if (this.kmlEncoder != null) {
            LOGGER.info("aborting KML encoder");
            this.kmlEncoder.abort();
        }
    }

    public void produceMap(WMSMapContext map) throws WmsException {
        this.kmlEncoder = new EncodeKML(map);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.kmlEncoder.encodeKML(out);
    }
}

