/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.styling.Style;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wms.responses.map.SVGWriter;

public class SVGEncoder {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String SVG_HEADER = "<?xml version=\"1.0\" standalone=\"no\"?>\n\t<!DOCTYPE svg \n\tPUBLIC \"-//W3C//DTD SVG 20001102//EN\" \n\t\"http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd\">\n<svg \n\tstroke=\"green\" \n\tfill=\"none\" \n\tstroke-width=\"0.001%\" \n\twidth=\"_width_\" \n\theight=\"_height_\" \n\tviewBox=\"_viewBox_\" \n\tpreserveAspectRatio=\"xMidYMid meet\">\n";
    private static final String SVG_FOOTER = "</svg>\n";
    private Envelope referenceSpace = null;
    private Feature currentFeature = null;
    private Geometry currentGeometry = null;
    private FeatureType featureType;
    private SVGWriter writer;
    private String width = "100%";
    private String height = "100%";
    private boolean collectGeometries = false;
    private boolean abortProcess = false;
    private double minCoordDistance = 0.0;
    int coordsSkipCount = 0;
    int coordsWriteCount = 0;
    private boolean writeHeader = true;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;

    public boolean isAborted() {
        return this.abortProcess;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setCollect(boolean collect) {
        this.collectGeometries = collect;
    }

    public void setReferenceSpace(Envelope env) {
        this.setReferenceSpace(env, 5000.0f);
    }

    public void setWriteHeader(boolean includeHeader) {
        this.writeHeader = includeHeader;
    }

    public void setReferenceSpace(Envelope env, float blurFactor) {
        this.referenceSpace = env;
        if (blurFactor > 0.0f) {
            double maxDimension = Math.max(env.getWidth(), env.getHeight());
            this.minCoordDistance = maxDimension / (double)blurFactor;
        } else {
            this.minCoordDistance = env.getWidth() + env.getHeight();
        }
    }

    public void encode(FeatureResults features, OutputStream out) throws IOException {
        FeatureResults[] results = new FeatureResults[]{features};
        this.encode(null, results, null, out);
    }

    public void encode(FeatureTypeInfo[] layers, FeatureResults[] results, Style[] styles, OutputStream out) throws IOException {
        this.writer = new SVGWriter(out);
        this.abortProcess = false;
        this.coordsWriteCount = 0;
        long t = System.currentTimeMillis();
        this.ensureSVGSpace(results);
        this.writeHeader();
        this.writeDefs(layers);
        try {
            this.writeLayers(layers, results, styles);
        }
        catch (AbortedException ex) {
            return;
        }
        if (this.writeHeader) {
            this.writer.write(SVG_FOOTER);
        }
        this.writer.flush();
        t = System.currentTimeMillis() - t;
        LOGGER.info("SVG generated in " + t + " ms, written " + this.coordsWriteCount + " coordinates, skipped " + this.coordsSkipCount);
    }

    private void writeHeader() throws IOException {
        if (this.writeHeader) {
            String viewBox = this.createViewBox();
            String header = SVG_HEADER.replaceAll("_viewBox_", viewBox);
            header = header.replaceAll("_width_", this.width);
            header = header.replaceAll("_height_", this.height);
            this.writer.write(header);
        }
    }

    private void writeLayers(FeatureTypeInfo[] layers, FeatureResults[] results, Style[] styles) throws IOException, AbortedException {
        int nLayers = results.length;
        int nConfigs = layers != null && layers.length >= nLayers ? nLayers : 0;
        FeatureTypeInfo layerConfig = null;
        int defMaxDecimals = this.writer.getMaximunFractionDigits();
        for (int i = 0; i < nLayers; ++i) {
            if (nConfigs == nLayers) {
                layerConfig = layers[i];
                this.writer.setMaximunFractionDigits(layerConfig.getNumDecimals());
            } else {
                this.writer.setMaximunFractionDigits(defMaxDecimals);
            }
            FeatureReader featureReader = null;
            try {
                LOGGER.fine("obtaining FeatureReader for " + layerConfig.getName());
                featureReader = results[i].reader();
                LOGGER.fine("got FeatureReader, now writing");
                String groupId = null;
                groupId = layerConfig.getTypeName();
                this.writer.write("<g id=\"" + groupId + "\" class=\"" + groupId + "\">\n");
                this.writeFeatures(featureReader);
                this.writer.write("</g>\n");
                continue;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (AbortedException ae) {
                LOGGER.info("process aborted: " + ae.getMessage());
                throw ae;
            }
            catch (Throwable t) {
                LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                ioe.setStackTrace(t.getStackTrace());
                throw ioe;
            }
            finally {
                if (featureReader != null) {
                    featureReader.close();
                }
            }
        }
    }

    private void writeDefs(FeatureTypeInfo[] layers) throws IOException {
        if (layers == null) {
            LOGGER.warning("Can't write symbol definitions, no FeatureTypes passed");
            return;
        }
        int nLayers = layers.length;
        for (int i = 0; i < nLayers; ++i) {
            Class geometryClass = layers[i].getFeatureType().getDefaultGeometry().getType();
            if (geometryClass != (class$com$vividsolutions$jts$geom$MultiPoint == null ? SVGEncoder.class$("com.vividsolutions.jts.geom.MultiPoint") : class$com$vividsolutions$jts$geom$MultiPoint) && geometryClass != (class$com$vividsolutions$jts$geom$Point == null ? SVGEncoder.class$("com.vividsolutions.jts.geom.Point") : class$com$vividsolutions$jts$geom$Point)) continue;
            this.writePointDefs();
            break;
        }
    }

    private String createViewBox() {
        String viewBox = (long)this.getX(this.referenceSpace.getMinX()) + " " + (long)(this.getY(this.referenceSpace.getMinY()) - this.referenceSpace.getHeight()) + " " + (long)this.referenceSpace.getWidth() + " " + (long)this.referenceSpace.getHeight();
        return viewBox;
    }

    private void ensureSVGSpace(FeatureResults[] results) throws IOException {
        if (this.referenceSpace == null) {
            Envelope bounds = new Envelope();
            int nLayers = results.length;
            for (int i = 0; i < nLayers; ++i) {
                Envelope layerBounds = results[i].getBounds();
                if (layerBounds == null) {
                    throw new IOException("Can't obtain the feature result's bounds");
                }
                bounds.expandToInclude(layerBounds);
            }
            LOGGER.fine("no explicit SVG space defined, using bounds " + bounds);
            this.setReferenceSpace(bounds);
        }
    }

    private void writeFeatures(FeatureReader reader) throws IOException, AbortedException {
        try {
            boolean doCollect;
            this.featureType = reader.getFeatureType();
            int prevSkipCount = this.coordsSkipCount;
            this.coordsSkipCount = 0;
            Class gtype = this.featureType.getDefaultGeometry().getType();
            boolean bl = this.collectGeometries && gtype != (class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = SVGEncoder.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point) && gtype != (class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = SVGEncoder.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) ? true : (doCollect = false);
            if (doCollect) {
                this.writer.write("<path ");
                this.writer.write("d=\"");
            }
            while (reader.hasNext()) {
                if (this.isAborted()) {
                    throw new AbortedException("writing features");
                }
                Feature ft = reader.next();
                this.writeGeometry(ft);
            }
            if (doCollect) {
                this.writer.write("\"/>\n");
            }
            LOGGER.fine("encoded " + this.featureType.getTypeName() + " skipped " + this.coordsSkipCount + " coordinates");
            this.coordsSkipCount += prevSkipCount;
        }
        catch (NoSuchElementException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAttributeException ex) {
            throw new DataSourceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void writePointDefs() throws IOException {
        this.writer.write("<defs>\n\t<circle id='point' cx='0' cy='0' r='0.01%' fill='blue'/>\n</defs>\n");
    }

    private void writeClosedPath(Coordinate[] coords) throws IOException {
        this.writer.write("<path ");
        this.writer.write("d=\"");
        this.writePathContent(coords);
        this.writer.write("Z");
        this.writer.write("\"/>\n");
    }

    private void writePathContent(Coordinate[] coords) throws IOException {
        this.writer.write('M');
        Coordinate prev = coords[0];
        Coordinate curr = null;
        this.writer.write(this.getX(prev.x));
        this.writer.write(' ');
        this.writer.write(this.getY(prev.y));
        int nCoords = coords.length;
        this.writer.write('l');
        for (int i = 1; i < nCoords; ++i) {
            curr = coords[i];
            if (i > 3 && prev.distance(curr) <= this.minCoordDistance) {
                ++this.coordsSkipCount;
                continue;
            }
            ++this.coordsWriteCount;
            this.writer.write(this.getX(curr.x) - this.getX(prev.x));
            this.writer.write(' ');
            this.writer.write(this.getY(curr.y) - this.getY(prev.y));
            this.writer.write(' ');
            prev = curr;
        }
    }

    private void writeGeometry(Feature ft) throws IOException {
        Geometry geom = ft.getDefaultGeometry();
        if (geom == null || geom.isEmpty()) {
            return;
        }
        this.currentFeature = ft;
        this.currentGeometry = geom;
        if (geom instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)geom;
            this.writeMultiPoly(mp);
        } else if (geom instanceof LineString) {
            LineString l = (LineString)geom;
            this.writePolyLine(l.getCoordinates());
        } else if (geom instanceof MultiLineString) {
            this.writeMultiLineString((MultiLineString)geom);
        } else if (geom instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)geom);
        } else if (geom instanceof Point) {
            this.writePoint((Point)geom);
        }
    }

    private void writeAttributes() throws IOException {
        if (this.currentGeometry != null) {
            Envelope env = this.currentGeometry.getEnvelopeInternal();
            this.writer.write("bounds=\"");
            this.writer.write(this.getX(env.getMinX()));
            this.writer.write(" ");
            this.writer.write(this.getY(env.getMinY()));
            this.writer.write(" ");
            this.writer.write(env.getWidth());
            this.writer.write(" ");
            this.writer.write(env.getHeight());
            this.writer.write("\" ");
        }
        int numAtts = this.currentFeature.getNumberOfAttributes();
        for (int i = 0; i < numAtts; ++i) {
            Object att = this.currentFeature.getAttribute(i);
            if (att instanceof Geometry) continue;
            this.writer.writeAttribute(this.featureType.getAttributeType(i).getName(), att);
        }
    }

    private void writeMultiPoint(MultiPoint mp) throws IOException {
        this.writer.write("<g ");
        this.writeId();
        this.writeAttributes();
        this.writer.write(">\n");
        int npoints = mp.getNumGeometries();
        for (int i = 0; i < npoints; ++i) {
            this.writer.write("\t");
            this.writePoint((Point)mp.getGeometryN(i));
        }
        this.writer.write("</g>");
    }

    private void writePoint(Point p) throws IOException {
        this.writer.write("<use xlink:href=\"#point\" x=\"");
        this.writer.write(this.getX(p.getX()));
        this.writer.write("\" y=\"");
        this.writer.write(this.getY(p.getY()));
        this.writer.write("\" ");
        this.writeAttributes();
        this.writer.write("/>");
        this.writer.newline();
        ++this.coordsWriteCount;
    }

    private void writePolyLine(Coordinate[] coords) throws IOException {
        this.writer.write("<path fill=\"none\" ");
        this.writeAttributes();
        this.writer.write(" d=\"");
        this.writePathContent(coords);
        this.writer.write("\"/>");
        this.writer.newline();
    }

    private void writeMultiLineString(MultiLineString mls) throws IOException {
        this.writer.write("<path fill=\"none\" ");
        this.writeAttributes();
        this.writer.write(" d=\"");
        int n = mls.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.writePathContent(mls.getGeometryN(i).getCoordinates());
        }
        this.writer.write("\"/>");
        this.writer.newline();
    }

    private void writeMultiPoly(MultiPolygon mpoly) throws IOException {
        int n = mpoly.getNumGeometries();
        this.writer.write("<path ");
        this.writeId();
        this.writeAttributes();
        this.writer.write("d=\"");
        for (int i = 0; i < n; ++i) {
            Polygon poly = (Polygon)mpoly.getGeometryN(i);
            this.writePolyContent(poly);
        }
        this.writer.write("\"/>");
        this.writer.newline();
    }

    private void writeId() throws IOException {
        this.writer.write("id=\"");
        this.writer.write(this.currentFeature.getID());
        this.writer.write("\" ");
    }

    private void writePoly(Polygon poly) throws IOException {
        LineString shell = poly.getExteriorRing();
        int nHoles = poly.getNumInteriorRing();
        this.writeClosedPath(shell.getCoordinates());
        for (int i = 0; i < nHoles; ++i) {
            this.writeClosedPath(poly.getInteriorRingN(i).getCoordinates());
        }
    }

    private void writePolyContent(Polygon poly) throws IOException {
        LineString shell = poly.getExteriorRing();
        int nHoles = poly.getNumInteriorRing();
        this.writePathContent(shell.getCoordinates());
        this.writer.write("Z");
        for (int i = 0; i < nHoles; ++i) {
            this.writePathContent(poly.getInteriorRingN(i).getCoordinates());
            this.writer.write("Z");
        }
    }

    private double getY(double y) {
        return this.referenceSpace.getMaxY() - y + this.referenceSpace.getMinY();
    }

    private double getX(double x) {
        return x;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AbortedException
    extends Exception {
        public AbortedException(String msg) {
            super(msg);
        }
    }
}

