/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.filter.Filter;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.styling.Style;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;

public class GetMapResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$GetMapResponse == null ? (class$org$vfny$geoserver$wms$responses$GetMapResponse = GetMapResponse.class$("org.vfny.geoserver.wms.responses.GetMapResponse")) : class$org$vfny$geoserver$wms$responses$GetMapResponse).getPackage().getName());
    private GetMapProducer delegate;
    private WMSMapContext map;
    private WMS wms;
    private HashMap responseHeaders;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$GetMapResponse;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$GetMapProducerFactorySpi;

    public GetMapResponse(WMS wms, ApplicationContext applicationContext) {
        this.wms = wms;
        this.applicationContext = applicationContext;
        this.responseHeaders = new HashMap();
    }

    public HashMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public void execute(Request req) throws ServiceException {
        GetMapRequest request = (GetMapRequest)req;
        String outputFormat = request.getFormat();
        this.delegate = this.getDelegate(outputFormat, this.wms);
        FeatureTypeInfo[] layers = request.getLayers();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        this.map = new WMSMapContext(request);
        Envelope env = request.getBbox();
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new WmsException("The request bounding box has zero area: " + env);
        }
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            this.map.setAreaOfInterest(request.getBbox(), mapcrs);
        } else {
            this.map.setAreaOfInterest(request.getBbox());
        }
        this.map.setMapWidth(request.getWidth());
        this.map.setMapHeight(request.getHeight());
        this.map.setBgColor(request.getBgColor());
        this.map.setTransparent(request.isTransparent());
        LOGGER.fine("setting up map");
        boolean cachingPossible = request.getHttpServletRequest().getMethod().equals("GET");
        int maxAge = Integer.MAX_VALUE;
        for (int i = 0; i < layers.length; ++i) {
            FeatureSource source;
            if (cachingPossible) {
                if (layers[i].isCachingEnabled()) {
                    int nma = Integer.parseInt(layers[i].getCacheMaxAge());
                    if (nma < maxAge) {
                        maxAge = nma;
                    }
                } else {
                    cachingPossible = false;
                }
            }
            Style style = styles[i];
            try {
                source = layers[i].getFeatureSource();
            }
            catch (IOException exp) {
                LOGGER.log(Level.SEVERE, "Getting feature source: " + exp.getMessage(), exp);
                throw new WmsException(null, "Internal error : " + exp.getMessage());
            }
            DefaultMapLayer layer = new DefaultMapLayer(source, style);
            Filter definitionFilter = layers[i].getDefinitionQuery();
            if (definitionFilter != null) {
                DefaultQuery definitionQuery = new DefaultQuery(source.getSchema().getTypeName(), definitionFilter);
                layer.setQuery((Query)definitionQuery);
            }
            this.map.addLayer((MapLayer)layer);
        }
        this.delegate.produceMap(this.map);
        if (cachingPossible) {
            this.responseHeaders.put("Cache-Control", "max-age=" + maxAge);
        }
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.delegate == null) {
            throw new IllegalStateException("No request has been processed");
        }
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        LOGGER.finer("returning content encoding null");
        return null;
    }

    public void abort(Service gs) {
        if (this.delegate != null) {
            LOGGER.fine("asking delegate for aborting the process");
            this.delegate.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            if (this.delegate == null) {
                throw new IllegalStateException("No GetMapDelegate is setted, make sure you have called execute and it has succeed");
            }
            LOGGER.finer("asking delegate for write to " + out);
            this.delegate.writeTo(out);
        }
        finally {
            try {
                this.map.clearLayerList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GetMapProducer getDelegate(String outputFormat, WMS wms) throws WmsException {
        Map beans = this.applicationContext.getBeansOfType(class$org$vfny$geoserver$wms$GetMapProducerFactorySpi == null ? (class$org$vfny$geoserver$wms$GetMapProducerFactorySpi = GetMapResponse.class$("org.vfny.geoserver.wms.GetMapProducerFactorySpi")) : class$org$vfny$geoserver$wms$GetMapProducerFactorySpi);
        Collection producers = beans.values();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetMapProducerFactorySpi factory = (GetMapProducerFactorySpi)iter.next();
            if (!factory.canProduce(outputFormat)) continue;
            return factory.createMapProducer(outputFormat, wms);
        }
        WmsException e = new WmsException("There is no support for creating maps in " + outputFormat + " format");
        e.setCode("InvalidFormat");
        throw e;
    }

    public Set getMapFormats() {
        Set wmsGetMapFormats = GetMapResponse.loadImageFormats(this.applicationContext);
        return wmsGetMapFormats;
    }

    public static Set loadImageFormats(ApplicationContext applicationContext) {
        Map beans = applicationContext.getBeansOfType(class$org$vfny$geoserver$wms$GetMapProducerFactorySpi == null ? (class$org$vfny$geoserver$wms$GetMapProducerFactorySpi = GetMapResponse.class$("org.vfny.geoserver.wms.GetMapProducerFactorySpi")) : class$org$vfny$geoserver$wms$GetMapProducerFactorySpi);
        Collection producers = beans.values();
        HashSet formats = new HashSet();
        Iterator iter = producers.iterator();
        while (iter.hasNext()) {
            GetMapProducerFactorySpi producer = (GetMapProducerFactorySpi)iter.next();
            formats.addAll(producer.getSupportedFormats());
        }
        return formats;
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

