/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geotools.feature.FeatureType;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;
import org.xml.sax.InputSource;

public class GetMapKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers.wms");
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    private boolean stylesRequired = true;

    public GetMapKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
    }

    public void setStylesRequired(boolean parseStyles) {
        this.stylesRequired = parseStyles;
    }

    public boolean isStylesRquired() {
        return this.stylesRequired;
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetMapRequest request = new GetMapRequest((WMService)this.service);
        request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        request.setVersion(version);
        this.parseMandatoryParameters(request, true);
        this.parseOptionalParameters(request);
        return request;
    }

    public void parseOptionalParameters(GetMapRequest request) throws WmsException {
        String KMAttr;
        String KMScore;
        String transparentValue;
        String epsgCode = this.getValue("SRS");
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                request.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
        boolean transparent = (transparentValue = this.getValue("TRANSPARENT")) == null ? false : Boolean.valueOf(transparentValue);
        request.setTransparent(transparent);
        String bgcolor = this.getValue("BGCOLOR");
        if (bgcolor != null) {
            try {
                request.setBgColor(Color.decode(bgcolor));
            }
            catch (NumberFormatException nfe) {
                throw new WmsException("BGCOLOR " + bgcolor + " incorrectly specified (0xRRGGBB format expected)");
            }
        }
        if ((KMScore = this.getValue("KMSCORE")) != null) {
            try {
                if (KMScore.equalsIgnoreCase("vector")) {
                    KMScore = "100";
                } else if (KMScore.equalsIgnoreCase("raster")) {
                    KMScore = "0";
                }
                Integer s = new Integer(KMScore);
                int score = s;
                if (score < 0 || score > 100) {
                    throw new NumberFormatException("KMScore not between 0 and 100. If you wish not to use it, do not specify KMScore as a parameter.");
                }
                request.setKMScore(score);
                LOGGER.info("Set KMScore: " + score);
            }
            catch (NumberFormatException e) {
                throw new WmsException("KMScore parameter (" + KMScore + ") incorrectly specified. " + "Expecting an integer value between between 0 and 100");
            }
        }
        if ((KMAttr = this.getValue("KMATTR")) != null) {
            if (KMAttr.equalsIgnoreCase("no") || KMAttr.equalsIgnoreCase("false") || KMAttr.equalsIgnoreCase("0")) {
                request.setKMattr(false);
            } else {
                request.setKMattr(true);
            }
        }
    }

    public void parseMandatoryParameters(GetMapRequest request, boolean parseStylesLayers) throws WmsException {
        try {
            int width = Integer.parseInt(this.getValue("WIDTH"));
            int height = Integer.parseInt(this.getValue("HEIGHT"));
            request.setWidth(width);
            request.setHeight(height);
        }
        catch (NumberFormatException ex) {
            throw new WmsException("WIDTH and HEIGHT incorrectly specified");
        }
        String format = this.getValue("FORMAT");
        if (format == null) {
            throw new WmsException("parameter FORMAT is required");
        }
        request.setFormat(format);
        Envelope bbox = this.parseBbox();
        request.setBbox(bbox);
        if (parseStylesLayers) {
            this.parseLayersAndStyles(request);
        }
    }

    private List parseAttributes(FeatureTypeInfo[] layers) throws WmsException {
        String rawAtts = this.getValue("ATTRIBUTES");
        LOGGER.finer("parsing attributes " + rawAtts);
        if (rawAtts == null || "".equals(rawAtts)) {
            return Collections.EMPTY_LIST;
        }
        List byFeatureTypes = KvpRequestReader.readFlat((String)rawAtts, (String)"|");
        int nLayers = layers.length;
        if (byFeatureTypes.size() != nLayers) {
            throw new WmsException(byFeatureTypes.size() + " lists of attributes specified, expected " + layers.length, ((Object)((Object)this)).getClass().getName() + "::parseAttributes()");
        }
        for (int i = 0; i < nLayers; ++i) {
            rawAtts = (String)byFeatureTypes.get(i);
            List atts = KvpRequestReader.readFlat((String)rawAtts, (String)",");
            byFeatureTypes.set(i, atts);
            try {
                FeatureType schema = layers[i].getFeatureType();
                Iterator attIt = atts.iterator();
                while (attIt.hasNext()) {
                    String attName = (String)attIt.next();
                    if (attName.length() > 0) {
                        LOGGER.finer("checking that " + attName + " is valid");
                        if ("#FID".equalsIgnoreCase(attName) || "#BOUNDS".equalsIgnoreCase(attName)) {
                            LOGGER.finer("special attribute name requested: " + attName);
                            continue;
                        }
                        if (schema.getAttributeType(attName) != null) continue;
                        throw new WmsException("Attribute '" + attName + "' requested for layer " + schema.getTypeName() + " does not exists");
                    }
                    LOGGER.finest("removing empty attribute name from request");
                    attIt.remove();
                }
                LOGGER.finest("attributes requested for " + schema.getTypeName() + " checked: " + rawAtts);
                continue;
            }
            catch (IOException e) {
                throw new WmsException(e);
            }
        }
        return byFeatureTypes;
    }

    protected Envelope parseBbox() throws WmsException {
        Envelope bbox = null;
        String bboxParam = this.getValue("BBOX");
        Object[] bboxValues = KvpRequestReader.readFlat((String)bboxParam, (String)",").toArray();
        if (bboxValues.length != 4) {
            throw new WmsException(bboxParam + " is not a valid pair of coordinates", ((Object)((Object)this)).getClass().getName());
        }
        try {
            double minx = Double.parseDouble(bboxValues[0].toString());
            double miny = Double.parseDouble(bboxValues[1].toString());
            double maxx = Double.parseDouble(bboxValues[2].toString());
            double maxy = Double.parseDouble(bboxValues[3].toString());
            bbox = new Envelope(minx, maxx, miny, maxy);
            if (minx > maxx) {
                throw new WmsException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
            }
            if (miny > maxy) {
                throw new WmsException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
            }
        }
        catch (NumberFormatException ex) {
            throw new WmsException(ex, "Illegal value for BBOX parameter: " + bboxParam, ((Object)((Object)this)).getClass().getName() + "::parseBbox()");
        }
        return bbox;
    }

    protected List parseStylesParam(GetMapRequest request, FeatureTypeInfo[] layers) throws WmsException {
        String rawStyles = this.getValue("STYLES");
        ArrayList<Style> styles = new ArrayList<Style>(layers.length);
        int numLayers = layers.length;
        if ("".equals(rawStyles)) {
            LOGGER.finer("Assigning default style to all the requested layers");
            for (int i = 0; i < numLayers; ++i) {
                styles.add(layers[i].getDefaultStyle());
            }
        } else {
            List styleNames = KvpRequestReader.readFlat((String)rawStyles, (String)",");
            if (numLayers != styleNames.size()) {
                String msg = numLayers + " layers requested, but found " + styleNames.size() + " styles specified. " + "Since SLD parameter is not yet implemented, the STYLES parameter " + "is mandatory and MUST have exactly one value per requested layer";
                throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
            }
            for (int i = 0; i < numLayers; ++i) {
                Style currStyle;
                String currStyleName = (String)styleNames.get(i);
                FeatureTypeInfo currLayer = layers[i];
                if (null == currStyleName || "".equals(currStyleName)) {
                    currStyle = currLayer.getDefaultStyle();
                } else {
                    currStyle = GetMapKvpReader.findStyle(request, currStyleName);
                    if (currStyle == null) {
                        String msg = "No default style has been defined for " + currLayer.getName();
                        throw new WmsException(msg, "StyleNotDefined");
                    }
                }
                try {
                    this.checkStyle(currStyle, layers[i].getFeatureType());
                }
                catch (IOException e) {
                    throw new WmsException("Error obtaining FeatureType for layer " + layers[i].getName());
                }
                LOGGER.fine("establishing " + currStyleName + " style for " + layers[i].getName());
                styles.add(currStyle);
            }
        }
        return styles;
    }

    public static Style findStyle(GetMapRequest request, String currStyleName) {
        Map configuredStyles = request.getWMS().getData().getStyles();
        Style currStyle = (Style)configuredStyles.get(currStyleName);
        return currStyle;
    }

    private void checkStyle(Style style, FeatureType fType) throws WmsException {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        for (int i = 0; i < styleAttributes.length; ++i) {
            String attName = styleAttributes[i];
            if (fType.getAttributeType(attName) != null) continue;
            throw new WmsException("The requested Style can not be used with this featureType.  The style specifies an attribute of " + attName + " and the featureType definition is: " + fType);
        }
    }

    protected void parseLayersAndStyles(GetMapRequest request) throws WmsException {
        String sldParam = this.getValue("SLD");
        String sldBodyParam = this.getValue("SLD_BODY");
        if (sldBodyParam != null) {
            LOGGER.fine("Getting layers and styles from SLD_BODY");
            this.parseSldBodyParam(request);
        } else if (sldParam != null) {
            LOGGER.fine("Getting layers and styles from reomte SLD");
            this.parseSldParam(request);
        } else {
            FeatureTypeInfo[] featureTypes = null;
            List styles = null;
            featureTypes = this.parseLayersParam(request);
            request.setLayers(featureTypes);
            if (this.isStylesRquired()) {
                styles = this.parseStylesParam(request, featureTypes);
                if (this.isStylesRquired()) {
                    request.setStyles(styles);
                }
            }
        }
    }

    protected void parseSldBodyParam(GetMapRequest request) throws WmsException {
        Reader reader;
        String sldBody = this.getValue("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to parse SLD body: " + sldBody);
        }
        if (this.getValue("VALIDATESCHEMA") != null) {
            reader = this.getReaderFromString(sldBody);
            SLDValidator validator = new SLDValidator();
            List errors = null;
            InputSource in = new InputSource(reader);
            errors = validator.validateSLD(in, request.getHttpServletRequest().getSession().getServletContext());
            if (errors.size() != 0) {
                reader = this.getReaderFromString(sldBody);
                throw new WmsException(SLDValidator.getErrorMessage((Reader)reader, (List)errors));
            }
        }
        reader = this.getReaderFromString(sldBody);
        SLDParser parser = new SLDParser(styleFactory, reader);
        StyledLayerDescriptor sld = parser.parseSLD();
        this.parseStyledLayerDescriptor(request, sld);
    }

    private Reader getReaderFromString(String sldBody) {
        return new StringReader(sldBody);
    }

    protected void parseSldParam(GetMapRequest request) throws WmsException {
        SLDParser parser;
        URL sldUrl;
        String urlValue = this.getValue("SLD");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("about to load remote SLD document: '" + urlValue + "'");
        }
        try {
            sldUrl = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "parseSldParam");
        }
        if (this.getValue("VALIDATESCHEMA") != null) {
            SLDValidator validator = new SLDValidator();
            List errors = null;
            try {
                InputStream in = this.getInputStream(sldUrl);
                errors = validator.validateSLD(in, request.getHttpServletRequest().getSession().getServletContext());
                in.close();
                if (errors.size() != 0) {
                    throw new WmsException(SLDValidator.getErrorMessage((InputStream)sldUrl.openStream(), (List)errors));
                }
            }
            catch (IOException e) {
                String msg = "Creating remote SLD url: " + e.getMessage();
                LOGGER.log(Level.WARNING, msg, e);
                throw new WmsException(e, msg, "parseSldParam");
            }
        }
        try {
            parser = new SLDParser(styleFactory, this.getInputStream(sldUrl));
        }
        catch (IOException e) {
            String msg = "Creating remote SLD url: " + e.getMessage();
            LOGGER.log(Level.WARNING, msg, e);
            throw new WmsException(e, msg, "parseSldParam");
        }
        StyledLayerDescriptor sld = parser.parseSLD();
        this.parseStyledLayerDescriptor(request, sld);
    }

    private void parseStyledLayerDescriptor(GetMapRequest request, StyledLayerDescriptor sld) throws WmsException {
        StyledLayer[] styledLayers;
        int slCount;
        FeatureTypeInfo[] libraryModeLayers = null;
        if (null != this.getValue("LAYERS")) {
            LOGGER.info("request comes in \"library\" mode");
            libraryModeLayers = this.parseLayersParam(request);
        }
        if ((slCount = (styledLayers = sld.getStyledLayers()).length) == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<FeatureTypeInfo> layers = new ArrayList<FeatureTypeInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        if (null != libraryModeLayers) {
            int lCount = libraryModeLayers.length;
            for (int i = 0; i < lCount; ++i) {
                FeatureTypeInfo currLayer = libraryModeLayers[i];
                Style currStyle = this.findStyleOf(request, currLayer, styledLayers);
                layers.add(currLayer);
                styles.add(currStyle);
            }
        } else {
            StyledLayer sl = null;
            for (int i = 0; i < slCount; ++i) {
                FeatureTypeInfo currLayer;
                sl = styledLayers[i];
                String layerName = sl.getName();
                if (null == layerName) {
                    throw new WmsException("A UserLayer without layer name was passed");
                }
                if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                    UserLayer ul = (UserLayer)sl;
                    currLayer = new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore(), ul.getInlineFeatureType());
                } else {
                    currLayer = GetMapKvpReader.findLayer(request, layerName);
                }
                GetMapKvpReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
            }
        }
        request.setLayers(layers.toArray(new FeatureTypeInfo[layers.size()]));
        request.setStyles(styles);
    }

    public static void addStyles(GetMapRequest request, FeatureTypeInfo currLayer, StyledLayer layer, List layers, List styles) throws WmsException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            for (t = 0; t < ftcs.length; ++t) {
                boolean matches;
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() == null) continue;
                String ftc_name = ftc.getFeatureTypeName();
                try {
                    matches = currLayer.getFeatureType().isDescendedFrom(null, ftc_name) || currLayer.getFeatureType().getTypeName().equalsIgnoreCase(ftc_name);
                }
                catch (Exception e) {
                    matches = false;
                }
                if (matches) continue;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        for (t = 0; t < layerStyles.length; ++t) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpReader.findStyle(request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyles[t]);
        }
    }

    private Style findStyleOf(GetMapRequest request, FeatureTypeInfo layer, StyledLayer[] styledLayers) throws WmsException {
        FeatureType type;
        Style style = null;
        String layerName = layer.getName();
        for (int i = 0; i < styledLayers.length; ++i) {
            StyledLayer sl = styledLayers[i];
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                Style[] styles = ((UserLayer)sl).getUserStyles();
                if (null == styles || 0 >= styles.length) break;
                style = styles[0];
                break;
            }
            if (sl instanceof NamedLayer) {
                Style[] styles = ((NamedLayer)sl).getStyles();
                if (null != styles && 0 < styles.length) {
                    style = styles[0];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpReader.findStyle(request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + sl);
        }
        if (null == style) {
            style = layer.getDefaultStyle();
        }
        try {
            type = layer.getFeatureType();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error getting FeatureType, this should never happen!");
        }
        this.checkStyle(style, type);
        return style;
    }

    protected FeatureTypeInfo[] parseLayersParam(GetMapRequest request) throws WmsException {
        String layersParam = this.getValue("LAYERS");
        List layerNames = KvpRequestReader.readFlat((String)layersParam, (String)",");
        int layerCount = layerNames.size();
        if (layerCount == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        FeatureTypeInfo[] featureTypes = new FeatureTypeInfo[layerCount];
        String layerName = null;
        for (int i = 0; i < layerCount; ++i) {
            FeatureTypeInfo ftype;
            layerName = (String)layerNames.get(i);
            featureTypes[i] = ftype = GetMapKvpReader.findLayer(request, layerName);
        }
        return featureTypes;
    }

    public static FeatureTypeInfo findLayer(GetMapRequest request, String layerName) throws WmsException {
        Data catalog = request.getWMS().getData();
        FeatureTypeInfo ftype = null;
        try {
            ftype = catalog.getFeatureTypeInfo(layerName);
        }
        catch (NoSuchElementException ex) {
            WmsException e = new WmsException(ex, layerName + ": no such layer on this server", "LayerNotDefined");
            e.setCode("LayerNotDefined");
            throw e;
        }
        return ftype;
    }

    private InputStream getInputStream(URL sldUrl) throws IOException {
        URLConnection conn = sldUrl.openConnection();
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = "";
            }
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(conn.getInputStream());
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
            return conn.getInputStream();
        }
        return conn.getInputStream();
    }

    public void filterBaseMap(Map layers, Map styles) {
        String layerList = "";
        String styleList = "";
        String currentLayers = this.getValue("LAYERS");
        String[] titles = layers.keySet().toArray(new String[0]);
        boolean replacedOne = false;
        for (int i = 0; i < titles.length; ++i) {
            if (currentLayers.indexOf(titles[i]) <= -1) continue;
            replacedOne = true;
            LOGGER.info("Using BASEMAP layer: " + titles[i]);
            layerList = layerList + "," + layers.get(titles[i]);
            if (styles == null || ((Object)styles).equals("")) continue;
            styleList = styleList + "," + styles.get(titles[i]);
        }
        if (replacedOne) {
            layerList = layerList.substring(1);
            styleList = styleList.substring(1);
            this.kvpPairs.remove("LAYERS");
            this.kvpPairs.put("LAYERS", layerList);
            this.kvpPairs.remove("STYLES");
            this.kvpPairs.put("STYLES", styleList);
        }
    }
}

