/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.feature.FeatureType;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetLegendGraphicKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$requests$GetLegendGraphicKvpReader == null ? (class$org$vfny$geoserver$wms$requests$GetLegendGraphicKvpReader = GetLegendGraphicKvpReader.class$("org.vfny.geoserver.wms.requests.GetLegendGraphicKvpReader")) : class$org$vfny$geoserver$wms$requests$GetLegendGraphicKvpReader).getPackage().getName());
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    static /* synthetic */ Class class$org$vfny$geoserver$wms$requests$GetLegendGraphicKvpReader;

    public GetLegendGraphicKvpReader(Map params, WMService service) {
        super(params, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        FeatureType ft;
        FeatureTypeInfo fti;
        GetLegendGraphicRequest request = new GetLegendGraphicRequest((WMService)this.getServiceRef());
        request.setHttpServletRequest(httpRequest);
        String version = super.getRequestVersion();
        if (!"1.0.0".equals(version)) {
            throw new WmsException("Invalid SLD version number \"" + version + "\"");
        }
        String layer = this.getValue("LAYER");
        try {
            WMS wms = request.getWMS();
            Data catalog = wms.getData();
            fti = catalog.getFeatureTypeInfo(layer);
            ft = fti.getFeatureType();
        }
        catch (NoSuchElementException e) {
            throw new WmsException(layer + " layer does not exists.", "LayerNotDefined");
        }
        catch (IOException e) {
            throw new WmsException("Can't obtain the schema for the required layer.");
        }
        request.setLayer(ft);
        String format = this.getValue("FORMAT");
        if (!GetLegendGraphicResponse.supportsFormat(format)) {
            throw new WmsException("Invalid graphic format: " + format, "InvalidFormat");
        }
        request.setFormat(format);
        this.parseOptionalParameters(request, fti);
        return request;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, FeatureTypeInfo ft) throws WmsException {
        String exceptions;
        String height;
        String width;
        this.parseStyleAndRule(req, ft);
        String featureType = this.getValue("FEATURETYPE");
        String scale = this.getValue("SCALE");
        if (scale != null && !"".equals(scale)) {
            double scaleFactor = Double.valueOf(scale);
            req.setScale(scaleFactor);
        }
        if ((width = this.getValue("WIDTH")) != null && !"".equals(width)) {
            int legendW = Integer.valueOf(width);
            req.setWidth(legendW);
        }
        if ((height = this.getValue("HEIGHT")) != null && !"".equals(height)) {
            int legendH = Integer.valueOf(height);
            req.setHeight(legendH);
        }
        if ((exceptions = this.getValue("EXCEPTIONS")) != null) {
            req.setExceptionsFormat(exceptions);
        }
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, FeatureTypeInfo ftype) throws WmsException {
        Style[] styles;
        String styleName = this.getValue("STYLE");
        String sldUrl = this.getValue("SLD");
        String sldBody = this.getValue("SLD_BODY");
        LOGGER.fine("looking for style " + styleName);
        Style sldStyle = null;
        if (sldUrl != null) {
            LOGGER.finer("taking style from SLD parameter");
            styles = this.loadRemoteStyle(sldUrl);
            sldStyle = this.findStyle(styleName, styles);
        } else if (sldBody != null) {
            LOGGER.finer("taking style from SLD_BODY parameter");
            styles = this.parseSldBody(sldBody);
            sldStyle = this.findStyle(styleName, styles);
        } else if (styleName != null && !"".equals(styleName)) {
            LOGGER.finer("taking style from STYLE parameter");
            sldStyle = req.getWMS().getData().getStyle(styleName);
        } else {
            sldStyle = ftype.getDefaultStyle();
        }
        req.setStyle(sldStyle);
        String rule = this.getValue("RULE");
        Rule sldRule = this.extractRule(sldStyle, rule);
        if (sldRule != null) {
            req.setRule(sldRule);
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            LOGGER.finer("styleName is null, request in literal mode, returning first style");
            return styles[0];
        }
        LOGGER.finer("request in library mode, looking for style " + styleName);
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws WmsException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new WmsException(e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new WmsException(e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws WmsException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws WmsException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new WmsException(e);
        }
        if (styles == null || styles.length == 0) {
            throw new WmsException("Document contains no styles");
        }
        return styles;
    }

    private Rule extractRule(Style sldStyle, String rule) throws WmsException {
        Rule sldRule = null;
        if (rule != null && !"".equals(rule)) {
            FeatureTypeStyle[] fts = sldStyle.getFeatureTypeStyles();
            block0: for (int i = 0; i < fts.length; ++i) {
                Rule[] rules = fts[i].getRules();
                for (int r = 0; r < rules.length; ++r) {
                    if (!rule.equalsIgnoreCase(rules[r].getName())) continue;
                    sldRule = rules[r];
                    LOGGER.fine("found requested rule: " + rule);
                    continue block0;
                }
            }
            if (sldRule == null) {
                throw new WmsException("Style " + sldStyle.getName() + " does not contains a rule named " + rule);
            }
        }
        return sldRule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

