/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.w3c.dom.Element;

public class XmlSchemaEncoder
extends WFSDescribeFeatureTypeOutputFormat {
    WFS wfs;
    Data catalog;
    GeoServerResourceLoader resourceLoader;

    public XmlSchemaEncoder(WFS wfs, Data catalog, GeoServerResourceLoader resourceLoader) {
        super("text/xml; subtype=gml/3.1.1");
        this.wfs = wfs;
        this.catalog = catalog;
        this.resourceLoader = resourceLoader;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml; subtype=gml/3.1.1";
    }

    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        DescribeFeatureTypeType req = (DescribeFeatureTypeType)describeFeatureType.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        FeatureTypeSchemaBuilder.GML3 builder = new FeatureTypeSchemaBuilder.GML3(this.wfs, this.catalog, this.resourceLoader);
        XSDSchema schema = builder.build(featureTypeInfos, proxifiedBaseUrl);
        schema.updateElement();
        XSDResourceImpl.serialize((OutputStream)output, (Element)schema.getElement());
    }
}

