/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.xml.sax.InputSource;

public class WfsXmlReader
extends XmlRequestReader {
    WFS wfs;
    WFSConfiguration configuration;

    public WfsXmlReader(String element, WFS wfs, WFSConfiguration configuration) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.1.0"), "wfs");
        this.wfs = wfs;
        this.configuration = configuration;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        if (this.wfs.getCiteConformanceHacks()) {
            strict = Boolean.TRUE;
        }
        this.configuration.getProperties().add(Parser.Properties.PARSE_UNKNOWN_ELEMENTS);
        Parser parser = new Parser((Configuration)this.configuration);
        parser.setValidating(strict.booleanValue());
        NameSpaceInfo[] namespaces = this.configuration.getCatalog().getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            if (namespaces[i].isDefault()) continue;
            parser.getNamespaces().declarePrefix(namespaces[i].getPrefix(), namespaces[i].getURI());
        }
        InputSource source = new InputSource(reader);
        source.setEncoding(this.wfs.getCharSet().name());
        Object parsed = parser.parse(source);
        if (!"Transaction".equalsIgnoreCase(this.getElement().getLocalPart()) && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            Iterator e = parser.getValidationErrors().iterator();
            while (e.hasNext()) {
                Exception error = (Exception)e.next();
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

