/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.util.logging.Logging;
import org.geotools.xml.impl.AttributeHandler;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementHandlerImpl;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.HandlerFactory;
import org.geotools.xml.impl.ParserHandler;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class WFSHandlerFactory
implements HandlerFactory {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    Data catalog;
    FeatureTypeSchemaBuilder schemaBuilder;

    public WFSHandlerFactory(Data catalog, FeatureTypeSchemaBuilder schemaBuilder) {
        this.catalog = catalog;
        this.schemaBuilder = schemaBuilder;
    }

    public DocumentHandler createDocumentHandler(ParserHandler parser) {
        return null;
    }

    public ElementHandler createElementHandler(QName name, Handler parent, ParserHandler parser) {
        String namespaceURI = name.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = this.catalog.getDefaultNameSpace().getURI();
        }
        try {
            FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(name.getLocalPart(), namespaceURI);
            if (meta != null) {
                XSDSchema schema = this.schemaBuilder.build(meta, null);
                Iterator e = schema.getElementDeclarations().iterator();
                while (e.hasNext()) {
                    XSDElementDeclaration element = (XSDElementDeclaration)e.next();
                    if (!name.getLocalPart().equals(element.getName())) continue;
                    return new ElementHandlerImpl(element, parent, parser);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error building schema", e);
        }
        return null;
    }

    public ElementHandler createElementHandler(XSDElementDeclaration e, Handler parent, ParserHandler parser) {
        return null;
    }

    public AttributeHandler createAttributeHandler(XSDAttributeDeclaration a, Handler parent, ParserHandler parser) {
        return null;
    }
}

