/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.filter.identity.FeatureId;
import org.vfny.geoserver.global.Data;
import org.xml.sax.SAXException;

public class LockFeatureTypeResponse
extends Response {
    WFS wfs;
    Data catalog;
    WFSConfiguration configuration;
    static /* synthetic */ Class class$net$opengis$wfs$LockFeatureResponseType;

    public LockFeatureTypeResponse(WFS wfs, Data catalog, WFSConfiguration configuration) {
        super(class$net$opengis$wfs$LockFeatureResponseType == null ? (class$net$opengis$wfs$LockFeatureResponseType = LockFeatureTypeResponse.class$("net.opengis.wfs.LockFeatureResponseType")) : class$net$opengis$wfs$LockFeatureResponseType);
        this.wfs = wfs;
        this.catalog = catalog;
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        FeatureId featureId;
        Iterator i;
        LockFeatureResponseType lockResponse = (LockFeatureResponseType)value;
        if (new Version("1.1.0").equals((Object)operation.getService().getVersion())) {
            this.write1_1(lockResponse, output, operation);
            return;
        }
        String indent = this.wfs.isVerbose() ? "   " : "";
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        LockFeatureType lft = (LockFeatureType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)lft.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        writer.write("<?xml version=\"1.0\" encoding=\"" + this.wfs.getCharSet().name() + "\"?>");
        writer.write("<WFS_LockFeatureResponse \n");
        writer.write(indent + "xmlns=\"http://www.opengis.net/wfs\" " + "\n");
        writer.write(indent + "xmlns:ogc=\"http://www.opengis.net/ogc\" " + "\n");
        writer.write(indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "\n");
        writer.write(indent + "xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        writer.write(ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.0.0/WFS-transaction.xsd"));
        writer.write("\">\n");
        writer.write(indent + "<LockId>" + lockResponse.getLockId() + "</LockId>" + "\n");
        EList featuresLocked = null;
        if (lockResponse.getFeaturesLocked() != null) {
            featuresLocked = lockResponse.getFeaturesLocked().getFeatureId();
        }
        EList featuresNotLocked = null;
        if (lockResponse.getFeaturesNotLocked() != null) {
            featuresNotLocked = lockResponse.getFeaturesNotLocked().getFeatureId();
        }
        if (featuresLocked != null && !featuresLocked.isEmpty()) {
            writer.write(indent + "<FeaturesLocked>" + "\n");
            i = featuresLocked.iterator();
            while (i.hasNext()) {
                writer.write(indent + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write(indent + "</FeaturesLocked>" + "\n");
        }
        if (featuresNotLocked != null && !featuresNotLocked.isEmpty()) {
            writer.write("<FeaturesNotLocked>\n");
            i = featuresNotLocked.iterator();
            while (i.hasNext()) {
                writer.write(indent + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write("</FeaturesNotLocked>\n");
        }
        writer.write("</WFS_LockFeatureResponse>");
        writer.flush();
    }

    void write1_1(LockFeatureResponseType lockResponse, OutputStream output, Operation operation) throws IOException {
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        LockFeatureType req = (LockFeatureType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.1.0/wfs.xsd"));
        try {
            encoder.encode((Object)lockResponse, org.geoserver.wfs.xml.v1_1_0.WFS.LOCKFEATURERESPONSE, output);
        }
        catch (SAXException e) {
            if (e.getException() != null && ((Throwable)e).getCause() == null) {
                e.initCause(e.getException());
            }
            throw (IOException)new IOException().initCause(e);
        }
        output.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

