/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.FeatureStore;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InsertElementHandler
implements TransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private WFS wfs;
    private FilterFactory filterFactory;
    static /* synthetic */ Class class$net$opengis$wfs$InsertElementType;

    public InsertElementHandler(WFS wfs, FilterFactory filterFactory) {
        this.wfs = wfs;
        this.filterFactory = filterFactory;
    }

    public void checkValidity(EObject element, Map featureTypeInfos) throws WFSTransactionException {
        if ((this.wfs.getServiceLevel() & 2) == 0) {
            throw new WFSException("Transaction INSERT support is not enabled");
        }
    }

    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        LOGGER.finer("Transasction Insert:" + element);
        InsertElementType insert = (InsertElementType)element;
        long inserted = response.getTransactionSummary().getTotalInserted().longValue();
        try {
            HashMap<FeatureType, FeatureCollection> schema2features = new HashMap<FeatureType, FeatureCollection>();
            Iterator f = insert.getFeature().iterator();
            while (f.hasNext()) {
                Feature feature = (Feature)f.next();
                FeatureType schema = feature.getFeatureType();
                FeatureCollection collection = (FeatureCollection)schema2features.get(schema);
                if (collection == null) {
                    collection = new DefaultFeatureCollection(null, schema);
                    schema2features.put(schema, collection);
                }
                collection.add(feature);
            }
            HashMap schema2fids = new HashMap();
            Iterator c = schema2features.values().iterator();
            while (c.hasNext()) {
                CoordinateReferenceSystem target;
                GeometryAttributeType defaultGeometry;
                FeatureCollection collection = (FeatureCollection)c.next();
                FeatureType schema = collection.getSchema();
                QName elementName = new QName(schema.getNamespace().toString(), schema.getTypeName());
                FeatureStore store = (FeatureStore)featureStores.get(elementName);
                if (store == null) {
                    throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
                }
                if (collection == null) continue;
                if (this.wfs.getCiteConformanceHacks()) {
                    this.checkFeatureCoordinatesRange(collection);
                }
                if ((defaultGeometry = store.getSchema().getDefaultGeometry()) != null && (target = defaultGeometry.getCoordinateSystem()) != null) {
                    collection = new ReprojectingFeatureCollection(collection, target);
                }
                LOGGER.finer("Use featureValidation to check contents of insert");
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                if (fids == null) {
                    fids = new LinkedList();
                    schema2fids.put(schema.getTypeName(), fids);
                }
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.PRE_INSERT, elementName, collection));
                fids.addAll(store.addFeatures(collection));
            }
            InsertedFeatureType insertedFeature = null;
            Iterator f2 = insert.getFeature().iterator();
            while (f2.hasNext()) {
                Feature feature = (Feature)f2.next();
                FeatureType schema = feature.getFeatureType();
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                String fid = (String)fids.removeFirst();
                insertedFeature = WfsFactory.eINSTANCE.createInsertedFeatureType();
                insertedFeature.setHandle(insert.getHandle());
                insertedFeature.getFeatureId().add(this.filterFactory.featureId(fid));
                response.getInsertResults().getFeature().add(insertedFeature);
            }
        }
        catch (Exception e) {
            String msg = "Error performing insert";
            throw new WFSTransactionException(msg, e, insert.getHandle());
        }
        response.getTransactionSummary().setTotalInserted(BigInteger.valueOf(inserted += (long)insert.getFeature().size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFeatureCoordinatesRange(FeatureCollection collection) throws PointOutsideEnvelopeException {
        AttributeType[] types = collection.getSchema().getAttributeTypes();
        FeatureIterator fi = collection.features();
        try {
            while (fi.hasNext()) {
                Feature f = fi.next();
                for (int i = 0; i < types.length; ++i) {
                    Geometry geom;
                    GeometryAttributeType gat;
                    if (!(types[i] instanceof GeometryAttributeType) || (gat = (GeometryAttributeType)types[i]).getCoordinateSystem() == null || (geom = (Geometry)f.getAttribute(i)) == null) continue;
                    JTS.checkCoordinatesRange((Geometry)geom, (CoordinateReferenceSystem)gat.getCoordinateSystem());
                }
            }
        }
        finally {
            fi.close();
        }
    }

    public Class getElementClass() {
        return class$net$opengis$wfs$InsertElementType == null ? (class$net$opengis$wfs$InsertElementType = InsertElementHandler.class$("net.opengis.wfs.InsertElementType")) : class$net$opengis$wfs$InsertElementType;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        InsertElementType insert = (InsertElementType)element;
        ArrayList<QName> typeNames = new ArrayList<QName>();
        if (!insert.getFeature().isEmpty()) {
            Iterator f = insert.getFeature().iterator();
            while (f.hasNext()) {
                Feature feature = (Feature)f.next();
                String name = feature.getFeatureType().getTypeName();
                String namespaceURI = null;
                if (feature.getFeatureType().getNamespace() != null) {
                    namespaceURI = feature.getFeatureType().getNamespace().toString();
                }
                typeNames.add(new QName(namespaceURI, name));
            }
        } else {
            LOGGER.finer("Insert was empty - does not need a FeatuerSoruce");
        }
        return typeNames.toArray(new QName[typeNames.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

