/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Iterator;
import java.util.TreeSet;
import net.opengis.wfs.GetCapabilitiesType;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geotools.util.Version;
import org.vfny.geoserver.global.Data;

public class GetCapabilities {
    WFS wfs;
    Data catalog;

    public GetCapabilities(WFS wfs, Data catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public CapabilitiesTransformer run(GetCapabilitiesType request) throws WFSException {
        if (this.wfs.getCiteConformanceHacks() && request.getUpdateSequence() != null) {
            throw new WFSException("Invalid update sequence", "InvalidUpdateSequence");
        }
        if (this.wfs.getCiteConformanceHacks() && !request.isSetService()) {
            throw new WFSException("Service not set", "MissingParameterValue", "service");
        }
        if (request.getAcceptVersions() == null || request.getAcceptVersions().getVersion().isEmpty()) {
            return new CapabilitiesTransformer.WFS1_1(this.wfs, this.catalog);
        }
        Iterator i = request.getAcceptVersions().getVersion().iterator();
        while (i.hasNext()) {
            String version = (String)i.next();
            if (version.matches("[0-99]\\.[0-99]\\.[0-99]")) continue;
            String msg = version + " is an invalid version numver";
            throw new WFSException(msg, "VersionNegotiationFailed");
        }
        TreeSet<Version> provided = new TreeSet<Version>();
        provided.add(new Version("1.0.0"));
        provided.add(new Version("1.1.0"));
        TreeSet<Version> accepted = new TreeSet<Version>();
        Iterator v = request.getAcceptVersions().getVersion().iterator();
        while (v.hasNext()) {
            accepted.add(new Version((String)v.next()));
        }
        v = accepted.iterator();
        while (v.hasNext()) {
            Version version = (Version)v.next();
            if (provided.contains(version)) continue;
            v.remove();
        }
        String version = null;
        if (!accepted.isEmpty()) {
            version = ((Version)accepted.last()).toString();
        } else {
            accepted = new TreeSet();
            Iterator v2 = request.getAcceptVersions().getVersion().iterator();
            while (v2.hasNext()) {
                accepted.add(new Version((String)v2.next()));
            }
            if (((Version)accepted.last()).compareTo(provided.first()) < 0) {
                version = ((Version)provided.first()).toString();
            }
            if (((Version)accepted.first()).compareTo(provided.last()) > 0) {
                version = ((Version)provided.last()).toString();
            }
            if (version == null) {
                Version current;
                v2 = provided.iterator();
                Version last = (Version)v2.next();
                while (v2.hasNext() && (current = (Version)v2.next()).compareTo(accepted.last()) <= 0) {
                    last = current;
                }
                version = last.toString();
            }
        }
        if ("1.0.0".equals(version)) {
            return new CapabilitiesTransformer.WFS1_0(this.wfs, this.catalog);
        }
        if ("1.1.0".equals(version)) {
            return new CapabilitiesTransformer.WFS1_1(this.wfs, this.catalog);
        }
        throw new WFSException("Could not understand version:" + version);
    }
}

