/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.Reader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.xml.sax.InputSource;

public class WfsXmlReader
extends XmlRequestReader {
    WFS wfs;
    WFSConfiguration configuration;

    public WfsXmlReader(String element, WFS wfs, WFSConfiguration configuration) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.1.0"), "wfs");
        this.wfs = wfs;
        this.configuration = configuration;
    }

    public Object read(Object request, Reader reader) throws Exception {
        this.configuration.getProperties().add(Parser.Properties.PARSE_UNKNOWN_ELEMENTS);
        Parser parser = new Parser((Configuration)this.configuration);
        if (this.wfs.getCiteConformanceHacks()) {
            parser.setValidating(true);
        }
        InputSource source = new InputSource(reader);
        source.setEncoding(this.wfs.getCharSet().name());
        Object parsed = parser.parse(source);
        if (!"Transaction".equalsIgnoreCase(this.getElement().getLocalPart()) && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            Iterator e = parser.getValidationErrors().iterator();
            while (e.hasNext()) {
                Exception error = (Exception)e.next();
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

