/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaLocator;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class WFSSchemaLocator
extends SchemaLocator {
    Data catalog;
    FeatureTypeSchemaBuilder schemaBuilder;

    public WFSSchemaLocator(Configuration configuration, Data catalog, FeatureTypeSchemaBuilder schemaBuilder) {
        super(configuration);
        this.catalog = catalog;
        this.schemaBuilder = schemaBuilder;
    }

    protected XSDSchema createSchema() throws Exception {
        return this.createSchema(null);
    }

    protected XSDSchema createSchema(String baseUrl) throws Exception {
        XSDSchema wfsSchema = super.createSchema();
        Collection featureTypeInfos = this.catalog.getFeatureTypeInfos().values();
        Iterator i = featureTypeInfos.iterator();
        while (i.hasNext()) {
            FeatureTypeInfo meta = (FeatureTypeInfo)i.next();
            XSDSchema schema = this.schemaBuilder.build(new FeatureTypeInfo[]{meta}, baseUrl);
            String prefix = meta.getNameSpace().getPrefix();
            String namespaceURI = meta.getNameSpace().getURI();
            wfsSchema.getQNamePrefixToNamespaceMap().put(prefix, namespaceURI);
            Iterator t = schema.getTypeDefinitions().iterator();
            while (t.hasNext()) {
                wfsSchema.getTypeDefinitions().add(t.next());
            }
            Iterator e = schema.getElementDeclarations().iterator();
            while (e.hasNext()) {
                wfsSchema.getElementDeclarations().add(e.next());
            }
        }
        return wfsSchema;
    }
}

