/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.type.ProfileImpl;
import org.opengis.feature.type.Name;

public class TypeMappingProfile {
    Set profiles;

    public TypeMappingProfile(Set profiles) {
        this.profiles = profiles;
    }

    public AttributeType type(Class clazz) {
        ArrayList<AttributeType> assignable = new ArrayList<AttributeType>();
        Iterator p = this.profiles.iterator();
        while (p.hasNext()) {
            ProfileImpl profile = (ProfileImpl)p.next();
            Iterator i = profile.values().iterator();
            while (i.hasNext()) {
                AttributeType type = (AttributeType)i.next();
                if (type.getType().isAssignableFrom(clazz)) {
                    assignable.add(type);
                }
                if (!clazz.equals(type.getType())) continue;
                return type;
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (AttributeType)assignable.get(0);
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                AttributeType a1 = (AttributeType)o1;
                AttributeType a2 = (AttributeType)o2;
                if (a1.getType().equals(a2.getType())) {
                    return 0;
                }
                if (a1.getType().isAssignableFrom(a2.getType())) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(assignable, comparator);
        if (!assignable.get(0).equals(assignable.get(1))) {
            return (AttributeType)assignable.get(0);
        }
        return null;
    }

    public Name name(Class clazz) {
        ArrayList<Map.Entry> assignable = new ArrayList<Map.Entry>();
        Iterator p = this.profiles.iterator();
        while (p.hasNext()) {
            ProfileImpl profile = (ProfileImpl)p.next();
            Iterator i = profile.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                AttributeType type = (AttributeType)entry.getValue();
                if (type.getType().isAssignableFrom(clazz)) {
                    assignable.add(entry);
                }
                if (!clazz.equals(type.getType())) continue;
                return (Name)entry.getKey();
            }
        }
        if (assignable.isEmpty()) {
            return null;
        }
        if (assignable.size() == 1) {
            return (Name)((Map.Entry)assignable.get(0)).getKey();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                AttributeType a1 = (AttributeType)e1.getValue();
                AttributeType a2 = (AttributeType)e2.getValue();
                if (a1.getType().equals(a2.getType())) {
                    return 0;
                }
                if (a1.getType().isAssignableFrom(a2.getType())) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(assignable, comparator);
        Map.Entry e1 = (Map.Entry)assignable.get(0);
        Map.Entry e2 = (Map.Entry)assignable.get(1);
        AttributeType a1 = (AttributeType)e1.getValue();
        AttributeType a2 = (AttributeType)e2.getValue();
        if (!a1.getType().equals(a2.getType())) {
            return (Name)e1.getKey();
        }
        return null;
    }
}

