/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.InsertResultsType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionResultsType;
import net.opengis.wfs.TransactionType;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.filter.identity.FeatureId;
import org.vfny.geoserver.global.Data;
import org.xml.sax.SAXException;

public class TransactionResponse
extends Response {
    private boolean verbose = false;
    private String indent = " ";
    private String offset = "";
    WFS wfs;
    Data catalog;
    WFSConfiguration configuration;
    static /* synthetic */ Class class$net$opengis$wfs$TransactionResponseType;

    public TransactionResponse(WFS wfs, Data catalog, WFSConfiguration configuration) {
        super(class$net$opengis$wfs$TransactionResponseType == null ? (class$net$opengis$wfs$TransactionResponseType = TransactionResponse.class$("net.opengis.wfs.TransactionResponseType")) : class$net$opengis$wfs$TransactionResponseType);
        this.wfs = wfs;
        this.catalog = catalog;
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResponseType response = (TransactionResponseType)value;
        if (new Version("1.0.0").equals((Object)operation.getService().getVersion())) {
            this.v_1_0(response, output, operation);
        } else {
            this.v_1_1(response, output, operation);
        }
    }

    public void v_1_0(TransactionResponseType response, OutputStream output, Operation operation) throws IOException, ServiceException {
        TransactionResultsType result = response.getTransactionResults();
        Writer writer = new OutputStreamWriter(output);
        writer = new BufferedWriter(writer);
        String encoding = this.wfs.getCharSet().displayName();
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        writer.write(xmlHeader);
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("<wfs:WFS_TransactionResponse");
        writer.write(this.indent + "version=\"1.0.0\"");
        writer.write(this.indent + "xmlns:wfs=\"http://www.opengis.net/wfs\"");
        writer.write(this.indent + "xmlns:ogc=\"http://www.opengis.net/ogc\"");
        writer.write(this.indent + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.write(this.indent);
        writer.write("xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        TransactionType req = (TransactionType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        String baseUrl = ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.0.0/WFS-transaction.xsd");
        writer.write(baseUrl);
        writer.write("\">");
        InsertResultsType insertResults = response.getInsertResults();
        String lastHandle = null;
        boolean first = true;
        if (insertResults != null) {
            Iterator i = insertResults.getFeature().iterator();
            while (i.hasNext()) {
                InsertedFeatureType insertedFeature = (InsertedFeatureType)i.next();
                String handle = insertedFeature.getHandle();
                if (first || lastHandle == null && handle != null || lastHandle != null && handle != null && handle.equals(lastHandle)) {
                    if (!first) {
                        writer.write("</wfs:InsertResult>");
                    }
                    writer.write("<wfs:InsertResult");
                    if (insertedFeature.getHandle() != null) {
                        writer.write(" handle=\"" + insertedFeature.getHandle() + "\"");
                    }
                    writer.write(">");
                }
                Iterator id = insertedFeature.getFeatureId().iterator();
                while (id.hasNext()) {
                    FeatureId featureId = (FeatureId)id.next();
                    writer.write("<ogc:FeatureId fid=\"" + featureId.toString() + "\"/>");
                }
                first = false;
                lastHandle = handle;
            }
            writer.write("</wfs:InsertResult>");
        }
        writer.write(this.indent + "<wfs:TransactionResult");
        if (result.getHandle() != null) {
            writer.write(" handle=\"" + result.getHandle() + "\"");
        }
        writer.write(">");
        writer.write(this.indent + this.offset + "<wfs:Status>");
        writer.write(this.indent + this.offset + this.offset);
        if (!result.getAction().isEmpty()) {
            writer.write("<wfs:FAILED/>");
        } else {
            writer.write("<wfs:SUCCESS/>");
        }
        writer.write(this.indent + this.offset + "</wfs:Status>");
        if (!result.getAction().isEmpty()) {
            ActionType action = (ActionType)result.getAction().get(0);
            if (action.getLocator() != null) {
                writer.write(this.indent + this.offset + "<wfs:Locator>");
                writer.write(action.getLocator() + "</wfs:Locator>");
            }
            if (action.getMessage() != null) {
                writer.write(this.indent + this.offset + "<wfs:Message>");
                ResponseUtils.writeEscapedString((Writer)writer, (String)action.getMessage());
                writer.write("</wfs:Message>");
            }
        }
        writer.write(this.indent + "</wfs:TransactionResult>");
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("</wfs:WFS_TransactionResponse>");
        writer.flush();
    }

    public void v_1_1(TransactionResponseType response, OutputStream output, Operation operation) throws IOException, ServiceException {
        if (!response.getTransactionResults().getAction().isEmpty()) {
            ActionType action = (ActionType)response.getTransactionResults().getAction().iterator().next();
            throw new WFSException(action.getMessage(), action.getCode(), action.getLocator());
        }
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        TransactionType req = (TransactionType)operation.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)req.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.1.0/wfs.xsd"));
        try {
            encoder.encode((Object)response, org.geoserver.wfs.xml.v1_1_0.WFS.TRANSACTIONRESPONSE, output);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

