/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import net.sf.json.JSONException;
import org.eclipse.emf.common.util.EList;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.response.GeoJSONBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;

public class GeoJSONOutputFormat
extends WFSGetFeatureOutputFormat {
    private final Logger LOGGER = Logger.getLogger(((Object)((Object)this)).getClass().toString());
    public static final String FORMAT = "json";

    public GeoJSONOutputFormat() {
        super(FORMAT);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/json";
    }

    public String getCapabilitiesElementName() {
        return "GEOJSON";
    }

    protected String getContentDisposition(FeatureCollectionType featureCollection) {
        StringBuffer sb = new StringBuffer();
        Iterator f = featureCollection.getFeature().iterator();
        while (f.hasNext()) {
            FeatureCollection fc = (FeatureCollection)f.next();
            sb.append(fc.getSchema().getTypeName() + "_");
        }
        sb.setLength(sb.length() - 1);
        return "inline; filename=" + sb.toString() + ".txt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(output));
        GeoJSONBuilder jsonWriter = new GeoJSONBuilder(outWriter);
        EList resultsList = featureCollection.getFeature();
        this.LOGGER.info("about to encode JSON");
        try {
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            jsonWriter.key("members");
            jsonWriter.array();
            for (int i = 0; i < resultsList.size(); ++i) {
                FeatureCollection collection = (FeatureCollection)resultsList.get(i);
                FeatureIterator iterator = collection.features();
                try {
                    while (iterator.hasNext()) {
                        Feature feature = iterator.next();
                        jsonWriter.object();
                        jsonWriter.key("type").value((Object)"Feature");
                        jsonWriter.key("id");
                        jsonWriter.value(feature.getID());
                        FeatureType fType = feature.getFeatureType();
                        AttributeType[] types = fType.getAttributeTypes();
                        GeometryAttributeType defaultGeomType = fType.getDefaultGeometry();
                        jsonWriter.key("geometry");
                        if (feature.getDefaultGeometry() != null) {
                            jsonWriter.writeGeom(feature.getDefaultGeometry());
                        } else {
                            jsonWriter.value("null");
                        }
                        jsonWriter.key("geometry_name").value((Object)defaultGeomType.getLocalName());
                        jsonWriter.key("properties");
                        jsonWriter.object();
                        for (int j = 0; j < types.length; ++j) {
                            Object value = feature.getAttribute(j);
                            if (value != null) {
                                if (value instanceof Geometry) {
                                    if (types[j].equals(defaultGeomType)) continue;
                                    jsonWriter.key(types[j].getLocalName());
                                    jsonWriter.writeGeom((Geometry)value);
                                    continue;
                                }
                                jsonWriter.key(types[j].getLocalName());
                                jsonWriter.value(value);
                                continue;
                            }
                            jsonWriter.key(types[j].getLocalName());
                            jsonWriter.value("null");
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                    }
                }
                finally {
                    collection.close(iterator);
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
                ((Writer)outWriter).flush();
            }
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause(jsonException);
            throw serviceException;
        }
    }
}

