/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Writer;
import net.sf.json.JSONException;
import net.sf.json.util.JSONBuilder;

public class GeoJSONBuilder
extends JSONBuilder {
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int MULTIPOINT = 4;
    protected static final int MULTILINESTRING = 5;
    protected static final int MULTIPOLYGON = 6;
    protected static final int MULTIGEOMETRY = 7;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$GeometryCollection;

    public GeoJSONBuilder(Writer w) {
        super(w);
    }

    public JSONBuilder writeGeom(Geometry geometry) throws JSONException {
        this.object();
        this.key("type");
        this.value(GeoJSONBuilder.getGeometryName(geometry));
        int geometryType = GeoJSONBuilder.getGeometryType(geometry);
        if (geometryType != 7) {
            this.key("coordinates");
            switch (geometryType) {
                case 1: {
                    this.writeCoordinate(geometry.getCoordinate());
                    break;
                }
                case 2: 
                case 4: {
                    this.writeCoordinates(geometry.getCoordinates());
                    break;
                }
                case 3: {
                    this.writePolygon((Polygon)geometry);
                    break;
                }
                case 5: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writeCoordinates(geometry.getGeometryN(i).getCoordinates());
                    }
                    this.endArray();
                    break;
                }
                case 6: {
                    this.array();
                    int n = geometry.getNumGeometries();
                    for (int i = 0; i < n; ++i) {
                        this.writePolygon((Polygon)geometry.getGeometryN(i));
                    }
                    this.endArray();
                }
            }
        } else {
            this.writeGeomCollection((GeometryCollection)geometry);
        }
        return this.endObject();
    }

    private JSONBuilder writeGeomCollection(GeometryCollection collection) {
        this.array();
        this.key("members");
        int n = collection.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            this.writeGeom(collection.getGeometryN(i));
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinates(Coordinate[] coords) throws JSONException {
        this.array();
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coord = coords[i];
            this.writeCoordinate(coord);
        }
        return this.endArray();
    }

    private JSONBuilder writeCoordinate(Coordinate coord) {
        this.array();
        this.value(coord.x);
        this.value(coord.y);
        return this.endArray();
    }

    private void writePolygon(Polygon geometry) throws JSONException {
        this.array();
        this.writeCoordinates(geometry.getExteriorRing().getCoordinates());
        int ii = geometry.getNumInteriorRing();
        for (int i = 0; i < ii; ++i) {
            this.writeCoordinates(geometry.getInteriorRingN(i).getCoordinates());
        }
        this.endArray();
    }

    public static String getGeometryName(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        String returnValue = null;
        returnValue = geomClass.equals(class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point) ? "Point" : (geomClass.equals(class$com$vividsolutions$jts$geom$LineString == null ? (class$com$vividsolutions$jts$geom$LineString = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.LineString")) : class$com$vividsolutions$jts$geom$LineString) ? "LineString" : (geomClass.equals(class$com$vividsolutions$jts$geom$Polygon == null ? (class$com$vividsolutions$jts$geom$Polygon = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.Polygon")) : class$com$vividsolutions$jts$geom$Polygon) ? "Polygon" : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) ? "MultiPoint" : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString) ? "MultiLineString" : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon) ? "MultiPolygon" : (geomClass.equals(class$com$vividsolutions$jts$geom$GeometryCollection == null ? (class$com$vividsolutions$jts$geom$GeometryCollection = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.GeometryCollection")) : class$com$vividsolutions$jts$geom$GeometryCollection) ? "GeometryCollection" : null))))));
        return returnValue;
    }

    public static int getGeometryType(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        int returnValue = -1;
        returnValue = geomClass.equals(class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point) ? 1 : (geomClass.equals(class$com$vividsolutions$jts$geom$LineString == null ? (class$com$vividsolutions$jts$geom$LineString = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.LineString")) : class$com$vividsolutions$jts$geom$LineString) ? 2 : (geomClass.equals(class$com$vividsolutions$jts$geom$Polygon == null ? (class$com$vividsolutions$jts$geom$Polygon = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.Polygon")) : class$com$vividsolutions$jts$geom$Polygon) ? 3 : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint) ? 4 : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString) ? 5 : (geomClass.equals(class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon) ? 6 : (geomClass.equals(class$com$vividsolutions$jts$geom$GeometryCollection == null ? (class$com$vividsolutions$jts$geom$GeometryCollection = GeoJSONBuilder.class$("com.vividsolutions.jts.geom.GeometryCollection")) : class$com$vividsolutions$jts$geom$GeometryCollection) ? 7 : -1))))));
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

