/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.filter.Filter;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.util.requests.FilterHandlerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class FilterKvpParser
extends KvpParser {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$vfny$geoserver$util$requests$readers$XmlRequestReader;

    public FilterKvpParser() {
        super("filter", class$java$util$List == null ? (class$java$util$List = FilterKvpParser.class$("java.util.List")) : class$java$util$List);
    }

    public Object parse(String value) throws Exception {
        OGCConfiguration configuration = new OGCConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        List unparsed = KvpUtils.readFlat((String)value, (String)"()");
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            String string = (String)i.next();
            ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes());
            try {
                Filter filter = (Filter)parser.parse((InputStream)input);
                if (filter == null) {
                    throw new NullPointerException();
                }
                filters.add(filter);
            }
            catch (Exception e) {
                String msg = "Unable to parse filter: " + string;
                KvpParser.LOGGER.log(Level.WARNING, msg, e);
                Filter filter = this.parseXMLFilterWithOldParser(new StringReader(string));
                if (filter == null) continue;
                filters.add(filter);
            }
        }
        return filters;
    }

    protected Filter parseXMLFilterWithOldParser(Reader rawRequest) throws ServiceException {
        InputSource requestSource = new InputSource(rawRequest);
        FilterHandlerImpl contentHandler = new FilterHandlerImpl();
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)documentFilter);
            adapter.parse(requestSource);
            KvpParser.LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            throw new ServiceException((Throwable)e, "XML getFeature request SAX parsing error", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = FilterKvpParser.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "XML get feature request input error", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = FilterKvpParser.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException((Throwable)e, "Some sort of issue creating parser", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = FilterKvpParser.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        KvpParser.LOGGER.fine("passing filter: " + contentHandler.getFilter());
        return contentHandler.getFilter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

