/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.ServiceException;

public class BBoxKvpParser
extends KvpParser {
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Envelope;

    public BBoxKvpParser() {
        super("bbox", class$com$vividsolutions$jts$geom$Envelope == null ? (class$com$vividsolutions$jts$geom$Envelope = BBoxKvpParser.class$("com.vividsolutions.jts.geom.Envelope")) : class$com$vividsolutions$jts$geom$Envelope);
    }

    public Object parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (String)",");
        if (unparsed.size() < 4) {
            throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
        }
        double[] bbox = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i));
            }
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double maxx = bbox[2];
        double maxy = bbox[3];
        if (minx > maxx) {
            throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
        }
        if (miny > maxy) {
            throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
        }
        CoordinateReferenceSystem crs = null;
        if (unparsed.size() > 4) {
            crs = CRS.decode((String)((String)unparsed.get(4)));
        }
        return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

