/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Iterator;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WFSLogger
implements MethodInterceptor {
    Logger logger = Logger.getLogger("org.geoserver.wfs");

    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer log = new StringBuffer();
        log.append("\nRequest: " + invocation.getMethod().getName());
        if (invocation.getArguments().length > 0) {
            EObject requestBean = null;
            for (int i = 0; i < invocation.getArguments().length; ++i) {
                Object argument = invocation.getArguments()[i];
                if (!(argument instanceof EObject)) continue;
                requestBean = (EObject)argument;
                break;
            }
            if (requestBean != null) {
                this.log(requestBean, 1, log);
            }
        }
        Object result = invocation.proceed();
        log.append("\n\nResult:");
        this.logger.info(log.toString());
        return result;
    }

    void log(EObject object, int level, StringBuffer log) {
        EList properties = object.eClass().getEAllStructuralFeatures();
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            EStructuralFeature property = (EStructuralFeature)p.next();
            Object value = object.eGet(property);
            log.append("\n");
            for (int i = 0; i < level; ++i) {
                log.append("\t");
            }
            log.append(property.getName());
            if (value instanceof EObject && level < 2) {
                log.append(":");
                this.log((EObject)value, level + 1, log);
                continue;
            }
            log.append(" = " + value);
        }
    }
}

