/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoValidator;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WFSDTO;

public class WFS
extends Service {
    public static final String WEB_CONTAINER_KEY = "WFS";
    public static final int SERVICE_BASIC = 1;
    public static final int SERVICE_INSERT = 2;
    public static final int SERVICE_UPDATE = 4;
    public static final int SERVICE_DELETE = 8;
    public static final int SERVICE_LOCKING = 16;
    public static final int BASIC = 1;
    public static final int TRANSACTIONAL = 15;
    public static final int COMPLETE = 31;
    private GeoValidator gv;
    private int serviceLevel;
    private boolean srsXmlStyle;
    private boolean citeConformanceHacks;
    private boolean featureBounding;

    public WFS(WFSDTO config) {
        super(config.getService());
        this.setId("wfs");
        this.setSrsXmlStyle(config.isSrsXmlStyle());
        this.setServiceLevel(config.getServiceLevel());
        this.setCiteConformanceHacks(config.getCiteConformanceHacks());
        this.setFeatureBounding(config.isFeatureBounding());
    }

    public WFS(Config config, Data data, GeoServer geoServer, GeoValidator validator) throws ConfigurationException {
        this(config.getXMLReader().getWfs());
        this.setData(data);
        this.setGeoServer(geoServer);
        this.setValidation(validator);
    }

    WFS() {
        super(new ServiceDTO());
        this.setId("wfs");
    }

    public void load(WFSDTO config) {
        super.load(config.getService());
        this.setSrsXmlStyle(config.isSrsXmlStyle());
        this.setServiceLevel(config.getServiceLevel());
        this.setCiteConformanceHacks(config.getCiteConformanceHacks());
        this.setFeatureBounding(config.isFeatureBounding());
    }

    public Object toDTO() {
        WFSDTO dto = new WFSDTO();
        dto.setService((ServiceDTO)super.toDTO());
        dto.setServiceLevel(this.serviceLevel);
        dto.setSrsXmlStyle(this.srsXmlStyle);
        dto.setCiteConformanceHacks(this.citeConformanceHacks);
        dto.setFeatureBounding(this.featureBounding);
        return dto;
    }

    public boolean isSrsXmlStyle() {
        return this.srsXmlStyle;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        this.srsXmlStyle = doXmlStyle;
    }

    public String getSrsPrefix() {
        return this.srsXmlStyle ? "http://www.opengis.net/gml/srs/epsg.xml#" : "EPSG:";
    }

    public GeoValidator getValidation() {
        return this.gv;
    }

    void setValidation(GeoValidator gv) {
        this.gv = gv;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setCiteConformanceHacks(boolean on) {
        this.citeConformanceHacks = on;
    }

    public boolean getCiteConformanceHacks() {
        return this.citeConformanceHacks;
    }

    public boolean isFeatureBounding() {
        return this.featureBounding;
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.featureBounding = featureBounding;
    }
}

