/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class UpdateElementHandler
implements TransactionElementHandler {
    static Logger LOGGER = Logger.getLogger("org.geoserver.wfs");
    private WFS wfs;
    static /* synthetic */ Class class$net$opengis$wfs$UpdateElementType;

    public UpdateElementHandler(WFS wfs) {
        this.wfs = wfs;
    }

    public void checkValidity(EObject element, Map typeInfos) throws WFSTransactionException {
        if ((this.wfs.getServiceLevel() & 4) == 0) {
            throw new WFSException("Transaction Update support is not enabled");
        }
        UpdateElementType update = (UpdateElementType)element;
        try {
            FeatureTypeInfo meta = (FeatureTypeInfo)typeInfos.values().iterator().next();
            FeatureType featureType = meta.getFeatureType();
            Iterator prop = update.getProperty().iterator();
            while (prop.hasNext()) {
                String propertyName;
                AttributeType attributeType;
                PropertyType property = (PropertyType)prop.next();
                if (property.getValue() != null || (attributeType = featureType.getAttributeType(propertyName = property.getName().getLocalPart())) == null || attributeType.getMinOccurs() <= 0) continue;
                String msg = "Property '" + attributeType.getLocalName() + "' is mandatory but no value specified.";
                throw new WFSException(msg, "MissingParameterValue");
            }
        }
        catch (IOException e) {
            throw new WFSTransactionException("Could not locate feature type information for " + update.getTypeName(), e, update.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(EObject element, TransactionType request, Map featureStores, TransactionResponseType response, TransactionListener listener) throws WFSTransactionException {
        HashSet<String> fids;
        UpdateElementType update = (UpdateElementType)element;
        QName elementName = update.getTypeName();
        String handle = update.getHandle();
        long updated = response.getTransactionSummary().getTotalUpdated().longValue();
        FeatureStore store = (FeatureStore)featureStores.get(elementName);
        if (store == null) {
            throw new WFSException("Could not locate FeatureStore for '" + elementName + "'");
        }
        LOGGER.finer("Transaction Update:" + element);
        try {
            Filter filter = update.getFilter();
            AttributeType[] types = new AttributeType[update.getProperty().size()];
            Object[] values = new Object[update.getProperty().size()];
            for (int j = 0; j < update.getProperty().size(); ++j) {
                PropertyType property = (PropertyType)update.getProperty().get(j);
                types[j] = store.getSchema().getAttributeType(property.getName().getLocalPart());
                values[j] = property.getValue();
                if (!(values[j] instanceof Geometry)) continue;
                Geometry geometry = (Geometry)values[j];
                CoordinateReferenceSystem source = null;
                if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                    source = (CoordinateReferenceSystem)geometry.getUserData();
                }
                CoordinateReferenceSystem target = null;
                if (types[j] instanceof GeometricAttributeType) {
                    target = ((GeometricAttributeType)types[j]).getCoordinateSystem();
                }
                if (this.wfs.getCiteConformanceHacks()) {
                    JTS.checkCoordinatesRange((Geometry)geometry, (CoordinateReferenceSystem)(source != null ? source : target));
                }
                if (source == null || target == null || CRS.equalsIgnoreMetadata((Object)source, (Object)target)) continue;
                try {
                    MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
                    GeometryCoordinateSequenceTransformer gtx = new GeometryCoordinateSequenceTransformer();
                    gtx.setMathTransform(tx);
                    values[j] = gtx.transform(geometry);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Failed to reproject geometry:" + e.getLocalizedMessage();
                    throw new WFSTransactionException(msg, e);
                }
            }
            fids = new HashSet<String>();
            LOGGER.finer("Preprocess to remember modification as a set of fids");
            FeatureCollection features = store.getFeatures(filter);
            listener.dataStoreChange(new TransactionEvent(TransactionEventType.PRE_UPDATE, features));
            Iterator preprocess = features.iterator();
            try {
                while (preprocess.hasNext()) {
                    Feature feature = (Feature)preprocess.next();
                    fids.add(feature.getID());
                }
            }
            catch (NoSuchElementException e) {
                throw new WFSException("Could not aquire FeatureIDs", e);
            }
            finally {
                features.close(preprocess);
            }
            try {
                if (types.length == 1) {
                    store.modifyFeatures(types[0], values[0], filter);
                } else {
                    store.modifyFeatures(types, values, filter);
                }
                Object var24_27 = null;
            }
            catch (Throwable throwable) {
                Object var24_28 = null;
                if (request.getLockId() != null && store instanceof FeatureLocking && request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                    FeatureLocking locking = (FeatureLocking)store;
                    locking.unLockFeatures(filter);
                }
                throw throwable;
            }
            if (request.getLockId() != null && store instanceof FeatureLocking && request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                FeatureLocking locking = (FeatureLocking)store;
                locking.unLockFeatures(filter);
            }
            if (!fids.isEmpty()) {
                LOGGER.finer("Post process update for boundary update and featureValidation");
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                Iterator f = fids.iterator();
                while (f.hasNext()) {
                    featureIds.add(ff.featureId((String)f.next()));
                }
                Id modified = ff.id(featureIds);
                FeatureCollection changed = store.getFeatures((Filter)modified);
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.POST_UPDATE, changed));
            }
        }
        catch (IOException ioException) {
            throw new WFSTransactionException(ioException, null, handle);
        }
        catch (PointOutsideEnvelopeException poe) {
            throw new WFSTransactionException(poe, null, handle);
        }
        response.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(updated += (long)fids.size()));
    }

    public Class getElementClass() {
        return class$net$opengis$wfs$UpdateElementType == null ? (class$net$opengis$wfs$UpdateElementType = UpdateElementHandler.class$("net.opengis.wfs.UpdateElementType")) : class$net$opengis$wfs$UpdateElementType;
    }

    public QName[] getTypeNames(EObject element) throws WFSTransactionException {
        return new QName[]{((UpdateElementType)element).getTypeName()};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

