/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.ActionType;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.InsertedFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.WfsFactory;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.TransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.TransactionPlugin;
import org.geoserver.wfs.TransactionPluginComparator;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSTransactionException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.FilterFactory;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class Transaction {
    static Logger LOGGER = Logger.getLogger("org.geoserver.wfs");
    protected WFS wfs;
    protected Data catalog;
    protected FilterFactory filterFactory;
    protected org.geotools.data.Transaction transaction;
    protected List transactionElementHandlers = new ArrayList();
    protected List transactionListeners = new ArrayList();
    protected List transactionPlugins = new ArrayList();
    static /* synthetic */ Class class$org$geoserver$wfs$TransactionElementHandler;
    static /* synthetic */ Class class$org$geoserver$wfs$TransactionListener;
    static /* synthetic */ Class class$org$geoserver$wfs$TransactionPlugin;

    public Transaction(WFS wfs, Data catalog, ApplicationContext context) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.transactionElementHandlers.addAll(GeoServerExtensions.extensions((Class)(class$org$geoserver$wfs$TransactionElementHandler == null ? (class$org$geoserver$wfs$TransactionElementHandler = Transaction.class$("org.geoserver.wfs.TransactionElementHandler")) : class$org$geoserver$wfs$TransactionElementHandler)));
        this.transactionListeners.addAll(GeoServerExtensions.extensions((Class)(class$org$geoserver$wfs$TransactionListener == null ? (class$org$geoserver$wfs$TransactionListener = Transaction.class$("org.geoserver.wfs.TransactionListener")) : class$org$geoserver$wfs$TransactionListener)));
        this.transactionPlugins.addAll(GeoServerExtensions.extensions((Class)(class$org$geoserver$wfs$TransactionPlugin == null ? (class$org$geoserver$wfs$TransactionPlugin = Transaction.class$("org.geoserver.wfs.TransactionPlugin")) : class$org$geoserver$wfs$TransactionPlugin)));
        this.transactionListeners.removeAll(this.transactionPlugins);
        Collections.sort(this.transactionPlugins, new TransactionPluginComparator());
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public TransactionResponseType transaction(TransactionType request) throws WFSException {
        if ((this.wfs.getServiceLevel() & 0xF) == 0) {
            throw new WFSException("Transaction support is not enabled");
        }
        try {
            return this.execute(request);
        }
        catch (WFSException e) {
            this.abort(request);
            throw e;
        }
        catch (Exception e) {
            this.abort(request);
            throw new WFSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionResponseType execute(TransactionType request) throws Exception {
        TransactionPlugin tp;
        Iterator it;
        if (request.getReleaseAction() == null) {
            request.setReleaseAction(AllSomeType.ALL_LITERAL);
        }
        Iterator it2 = this.transactionPlugins.iterator();
        while (it2.hasNext()) {
            TransactionPlugin tp2 = (TransactionPlugin)it2.next();
            tp2.beforeTransaction(request);
        }
        TransactionListenerMux multiplexer = new TransactionListenerMux();
        this.transaction = this.getDatastoreTransaction(request);
        HashMap<QName, FeatureSource> stores = new HashMap<QName, FeatureSource>();
        HashMap<String, FeatureSource> stores2 = new HashMap<String, FeatureSource>();
        Map elementHandlers = this.gatherElementHandlers(request.getGroup());
        Iterator it3 = elementHandlers.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry entry = it3.next();
            EObject element = (EObject)entry.getKey();
            TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
            HashMap<QName, FeatureTypeInfo> featureTypeInfos = new HashMap<QName, FeatureTypeInfo>();
            QName[] typeNames = handler.getTypeNames(element);
            for (int i = 0; i < typeNames.length; ++i) {
                QName typeName = typeNames[i];
                String name = typeName.getLocalPart();
                String namespaceURI = typeName.getNamespaceURI() != null ? typeName.getNamespaceURI() : this.catalog.getDefaultNameSpace().getURI();
                LOGGER.fine("Locating FeatureSource uri:'" + namespaceURI + "' name:'" + name + "'");
                FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(name, namespaceURI);
                if (meta == null) {
                    String msg = name + " is not available: ";
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, (String)null, handle);
                }
                featureTypeInfos.put(typeName, meta);
            }
            handler.checkValidity(element, featureTypeInfos);
            Iterator m = featureTypeInfos.values().iterator();
            while (m.hasNext()) {
                String msg;
                FeatureTypeInfo meta = (FeatureTypeInfo)m.next();
                String typeRef = meta.getDataStoreInfo().getId() + ":" + meta.getTypeName();
                String URI2 = meta.getNameSpace().getURI();
                QName elementName = new QName(URI2, meta.getTypeName(), meta.getNameSpace().getPrefix());
                QName elementNameDefault = null;
                if (this.catalog.getDefaultNameSpace().getURI().equals(URI2)) {
                    elementNameDefault = new QName(meta.getTypeName());
                }
                LOGGER.fine("located FeatureType w/ typeRef '" + typeRef + "' and elementName '" + elementName + "'");
                if (stores.containsKey(elementName)) continue;
                try {
                    FeatureSource source = meta.getFeatureSource();
                    if (source instanceof FeatureStore) {
                        FeatureStore store = (FeatureStore)source;
                        store.setTransaction(this.transaction);
                        stores.put(elementName, source);
                        if (elementNameDefault != null) {
                            stores.put(elementNameDefault, source);
                        }
                        stores2.put(typeRef, source);
                        continue;
                    }
                    msg = elementName + " is read-only";
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, (String)null, handle);
                }
                catch (IOException ioException) {
                    msg = elementName + " is not available: " + ioException.getLocalizedMessage();
                    String handle = (String)EMFUtils.get((EObject)element, (String)"handle");
                    throw new WFSTransactionException(msg, ioException, handle);
                }
            }
        }
        String authorizationID = request.getLockId();
        if (authorizationID != null) {
            if ((this.wfs.getServiceLevel() & 0x10) == 0) {
                throw new WFSException("Lock support is not enabled");
            }
            LOGGER.finer("got lockId: " + authorizationID);
            if (!this.lockExists(authorizationID)) {
                String mesg = "Attempting to use a lockID that does not exist, it has either expired or was entered wrong.";
                throw new WFSException(mesg, "InvalidParameterValue");
            }
            try {
                this.transaction.addAuthorization(authorizationID);
            }
            catch (IOException ioException) {
                throw new WFSException("Authorization ID '" + authorizationID + "' not useable", ioException);
            }
        }
        TransactionResponseType result = WfsFactory.eINSTANCE.createTransactionResponseType();
        result.setTransactionResults(WfsFactory.eINSTANCE.createTransactionResultsType());
        result.getTransactionResults().setHandle(request.getHandle());
        result.setTransactionSummary(WfsFactory.eINSTANCE.createTransactionSummaryType());
        result.getTransactionSummary().setTotalInserted(BigInteger.valueOf(0L));
        result.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(0L));
        result.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(0L));
        result.setInsertResults(WfsFactory.eINSTANCE.createInsertResultsType());
        boolean exception = false;
        try {
            Iterator it4 = elementHandlers.entrySet().iterator();
            while (it4.hasNext()) {
                Map.Entry entry = it4.next();
                EObject element = (EObject)entry.getKey();
                TransactionElementHandler handler = (TransactionElementHandler)entry.getValue();
                handler.execute(element, request, stores, result, multiplexer);
            }
        }
        catch (WFSTransactionException e) {
            exception = true;
            LOGGER.log(Level.SEVERE, "Transaction failed", (Throwable)((Object)e));
            ActionType action = WfsFactory.eINSTANCE.createActionType();
            if (e.getCode() != null) {
                action.setCode(e.getCode());
            } else {
                action.setCode("InvalidParameterValue");
            }
            action.setLocator(e.getLocator());
            action.setMessage(((Throwable)((Object)e)).getMessage());
            result.getTransactionResults().getAction().add(action);
        }
        boolean committed = false;
        try {
            if (exception) {
                this.transaction.rollback();
            } else {
                it = this.transactionPlugins.iterator();
                while (it.hasNext()) {
                    tp = (TransactionPlugin)it.next();
                    tp.beforeCommit();
                }
                this.transaction.commit();
                committed = true;
                if (request.getLockId() != null) {
                    if (request.getReleaseAction() == AllSomeType.ALL_LITERAL) {
                        this.lockRelease(request.getLockId());
                    } else if (request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                        this.lockRefresh(request.getLockId());
                    }
                }
            }
        }
        finally {
            this.transaction.close();
            this.transaction = null;
        }
        it = this.transactionPlugins.iterator();
        while (it.hasNext()) {
            tp = (TransactionPlugin)it.next();
            tp.afterTransaction(committed);
        }
        if (result.getInsertResults().getFeature().isEmpty()) {
            InsertedFeatureType insertedFeature = WfsFactory.eINSTANCE.createInsertedFeatureType();
            insertedFeature.getFeatureId().add(this.filterFactory.featureId("none"));
            result.getInsertResults().getFeature().add(insertedFeature);
        }
        return result;
    }

    private Map gatherElementHandlers(FeatureMap group) throws WFSTransactionException {
        LinkedHashMap<EObject, TransactionElementHandler> map = new LinkedHashMap<EObject, TransactionElementHandler>();
        Iterator it = group.iterator();
        while (it.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)it.next();
            EObject element = (EObject)entry.getValue();
            map.put(element, this.findElementHandler(element.getClass()));
        }
        return map;
    }

    protected final TransactionElementHandler findElementHandler(Class type) throws WFSTransactionException {
        ArrayList<TransactionElementHandler> matches = new ArrayList<TransactionElementHandler>();
        Iterator it = this.transactionElementHandlers.iterator();
        while (it.hasNext()) {
            TransactionElementHandler handler = (TransactionElementHandler)it.next();
            if (!handler.getElementClass().isAssignableFrom(type)) continue;
            matches.add(handler);
        }
        if (matches.isEmpty()) {
            String msg = "No transaction element handler for : ( " + type + " )";
            throw new WFSTransactionException(msg);
        }
        if (matches.size() > 1) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    TransactionElementHandler h1 = (TransactionElementHandler)o1;
                    TransactionElementHandler h2 = (TransactionElementHandler)o2;
                    if (h2.getElementClass().isAssignableFrom(h1.getElementClass())) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(matches, comparator);
        }
        return (TransactionElementHandler)matches.get(0);
    }

    protected DefaultTransaction getDatastoreTransaction(TransactionType request) throws IOException {
        Object principal;
        DefaultTransaction transaction = new DefaultTransaction();
        String username = "anonymous";
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof UserDetails) {
            username = ((UserDetails)principal).getUsername();
        }
        transaction.putProperty((Object)"PgVersionedCommitAuthor", (Object)username);
        transaction.putProperty((Object)"PgVersionedCommitMessage", (Object)request.getHandle());
        return transaction;
    }

    public void abort(TransactionType request) {
        if (this.transaction == null) {
            return;
        }
        try {
            this.transaction.rollback();
            this.transaction.close();
        }
        catch (IOException ioException) {
            LOGGER.log(Level.SEVERE, "Failed trying to rollback a transaction:" + ioException);
        }
        if (request.getLockId() != null) {
            if (request.getReleaseAction() == AllSomeType.SOME_LITERAL) {
                try {
                    this.lockRefresh(request.getLockId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured refreshing lock", e);
                }
            } else if (request.getReleaseAction() == AllSomeType.ALL_LITERAL) {
                try {
                    this.lockRelease(request.getLockId());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured releasing lock", e);
                }
            }
        }
    }

    void lockRelease(String lockId) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.release(lockId);
    }

    private boolean lockExists(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        return lockFeature.exists(lockId);
    }

    private void lockRefresh(String lockId) throws Exception {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.refresh(lockId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransactionListenerMux
    implements TransactionListener {
        private TransactionListenerMux() {
        }

        public void dataStoreChange(List listeners, TransactionEvent event) throws WFSException {
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                TransactionListener listener = (TransactionListener)it.next();
                listener.dataStoreChange(event);
            }
        }

        public void dataStoreChange(TransactionEvent event) throws WFSException {
            this.dataStoreChange(Transaction.this.transactionPlugins, event);
            this.dataStoreChange(Transaction.this.transactionListeners, event);
        }
    }
}

