/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFilterVisitor
extends DuplicatingFilterVisitor {
    FeatureType featureType;

    public ReprojectingFilterVisitor(FilterFactory2 factory, FeatureType featureType) {
        super(factory);
        this.featureType = featureType;
    }

    private CoordinateReferenceSystem findPropertyCRS(PropertyName propertyName) {
        AttributeType at = (AttributeType)propertyName.evaluate((Object)this.featureType);
        if (at instanceof GeometryAttributeType) {
            GeometryAttributeType gat = (GeometryAttributeType)at;
            return gat.getCoordinateSystem();
        }
        throw new IllegalArgumentException("Property '" + propertyName + "' is not a geometric one, the filter is invalid");
    }

    public Object visit(BBOX filter, Object extraData) {
        String srs = filter.getSRS();
        if (srs == null || "".equals(srs.trim())) {
            return super.visit(filter, extraData);
        }
        try {
            double minx = filter.getMinX();
            double miny = filter.getMinY();
            double maxx = filter.getMaxX();
            double maxy = filter.getMaxY();
            CoordinateReferenceSystem crs = CRS.decode((String)srs);
            String propertyName = filter.getPropertyName();
            CoordinateReferenceSystem targetCrs = this.findPropertyCRS(this.factory.property(propertyName));
            if (crs != null && targetCrs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)targetCrs)) {
                ReferencedEnvelope envelope = new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
                envelope = envelope.transform(targetCrs, true);
                minx = envelope.getMinX();
                miny = envelope.getMinY();
                maxx = envelope.getMaxX();
                maxy = envelope.getMaxY();
                srs = targetCrs.getIdentifiers().iterator().next().toString();
            }
            return this.getFactory(extraData).bbox(propertyName, minx, miny, maxx, maxy, srs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode srs '" + srs + "'", e);
        }
    }

    public Object visit(Beyond filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Beyond)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                Beyond filter = (Beyond)bso;
                return ReprojectingFilterVisitor.this.factory.beyond(ex1, ex2, filter.getDistance(), filter.getDistanceUnits());
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Contains)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.contains(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Crosses)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.crosses(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Disjoint)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.disjoint(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((DWithin)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                DWithin filter = (DWithin)bso;
                return ReprojectingFilterVisitor.this.factory.dwithin(ex1, ex2, filter.getDistance(), filter.getDistanceUnits());
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Intersects)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.intersects(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Overlaps)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.overlaps(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Touches)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.touches(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return new GeometryFilterTransformer(){

            Object cloneFilter(BinarySpatialOperator filter, Object extraData) {
                return ReprojectingFilterVisitor.super.visit((Within)filter, extraData);
            }

            Object cloneFilter(BinarySpatialOperator bso, Object extraData, Expression ex1, Expression ex2) {
                return ReprojectingFilterVisitor.this.factory.within(ex1, ex2);
            }
        }.transform((BinarySpatialOperator)filter, extraData);
    }

    private abstract class GeometryFilterTransformer {
        private GeometryFilterTransformer() {
        }

        Object transform(BinarySpatialOperator filter, Object extraData) {
            if (!(filter.getExpression1() instanceof PropertyName)) {
                throw new IllegalArgumentException("Binary geometry filter, but first expression is not a property name? (it's a " + filter.getExpression1().getClass() + ")");
            }
            CoordinateReferenceSystem propertyCrs = ReprojectingFilterVisitor.this.findPropertyCRS((PropertyName)filter.getExpression1());
            if (propertyCrs == null) {
                return this.cloneFilter(filter, extraData);
            }
            if (!(filter.getExpression2() instanceof Literal)) {
                throw new IllegalArgumentException("Binary geometry filter, but second expression is not a literal? (it's a " + filter.getExpression1().getClass() + ")");
            }
            Object value = ((Literal)filter.getExpression2()).getValue();
            if (!(value instanceof Geometry)) {
                throw new IllegalArgumentException("Binary geometry filter, but second expression is not a geometry literal? (it's a " + value.getClass() + ")");
            }
            Geometry geom = (Geometry)value;
            if (geom.getUserData() == null || !(geom.getUserData() instanceof CoordinateReferenceSystem)) {
                return this.cloneFilter(filter, extraData);
            }
            try {
                CoordinateReferenceSystem geomCRS = (CoordinateReferenceSystem)geom.getUserData();
                Geometry transformed = JTS.transform((Geometry)geom, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)geomCRS, (CoordinateReferenceSystem)propertyCrs, (boolean)true));
                transformed.setUserData((Object)propertyCrs);
                Expression ex1 = (Expression)filter.getExpression1().accept((ExpressionVisitor)ReprojectingFilterVisitor.this, extraData);
                Literal ex2 = ReprojectingFilterVisitor.this.factory.literal((Object)transformed);
                return this.cloneFilter(filter, extraData, ex1, (Expression)ex2);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not reproject geometry filter " + filter, e);
            }
        }

        abstract Object cloneFilter(BinarySpatialOperator var1, Object var2);

        abstract Object cloneFilter(BinarySpatialOperator var1, Object var2, Expression var3, Expression var4);
    }
}

