/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.common.util.EList;
import org.geoserver.wfs.FeatureBoundsFeatureCollection;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.ReprojectingFilterVisitor;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.referencing.CRS;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class GetFeature {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    protected Data catalog;
    protected WFS wfs;
    protected FilterFactory filterFactory;

    public GetFeature(WFS wfs, Data catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public Data getCatalog() {
        return this.catalog;
    }

    public WFS getWFS() {
        return this.wfs;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public FeatureCollectionType run(GetFeatureType request) throws WFSException {
        EList queries = request.getQuery();
        if (queries.isEmpty()) {
            throw new WFSException("No query specified");
        }
        if (EMFUtils.isUnset((List)queries, (String)"typeName")) {
            String msg = "No feature types specified";
            throw new WFSException(msg);
        }
        if (request.getMaxFeatures() == null) {
            request.setMaxFeatures(BigInteger.valueOf(Integer.MAX_VALUE));
        }
        int maxFeatures = Math.min(request.getMaxFeatures().intValue(), this.wfs.getGeoServer().getMaxFeatures());
        FeatureCollectionType result = WfsFactory.eINSTANCE.createFeatureCollectionType();
        int count = 0;
        try {
            for (int i = 0; i < request.getQuery().size() && count <= maxFeatures; ++i) {
                QueryType query = (QueryType)request.getQuery().get(i);
                FeatureTypeInfo meta = null;
                if (query.getTypeName().size() == 1) {
                    meta = this.featureTypeInfo((QName)query.getTypeName().get(0));
                }
                FeatureSource source = meta.getFeatureSource();
                List atts = meta.getAttributes();
                List attNames = meta.getAttributeNames();
                EList propNames = query.getPropertyName();
                Iterator iter = propNames.iterator();
                while (iter.hasNext()) {
                    String propName = (String)iter.next();
                    if (propName.indexOf(58) != -1) {
                        propName = propName.substring(propName.indexOf(58) + 1);
                    }
                    if (attNames.contains(propName)) continue;
                    String mesg = "Requested property: " + propName + " is " + "not available " + "for " + query.getTypeName() + ".  " + "The possible propertyName " + "values are: " + attNames;
                    throw new WFSException(mesg);
                }
                ArrayList<String> extraGeometries = new ArrayList<String>();
                ArrayList<String> properties = new ArrayList<String>();
                if (propNames.size() != 0) {
                    Iterator ii = atts.iterator();
                    while (ii.hasNext()) {
                        AttributeTypeInfo ati = (AttributeTypeInfo)ii.next();
                        LOGGER.finer("checking to see if " + propNames + " contains" + ati);
                        if (ati.getMinOccurs() > 0 && ati.getMaxOccurs() != 0) {
                            properties.add(ati.getName());
                            continue;
                        }
                        Iterator p = propNames.iterator();
                        while (p.hasNext()) {
                            String propName = (String)p.next();
                            if (!propName.matches("(\\w+:)?" + ati.getName())) continue;
                            properties.add(ati.getName());
                            break;
                        }
                        if (!this.wfs.isFeatureBounding() || !(meta.getFeatureType().getAttributeType(ati.getName()) instanceof GeometryAttributeType) || properties.contains(ati.getName())) continue;
                        properties.add(ati.getName());
                        extraGeometries.add(ati.getName());
                    }
                    query.getPropertyName().clear();
                    query.getPropertyName().addAll(properties);
                }
                if (query.getFilter() != null) {
                    final FeatureType featureType = source.getSchema();
                    AbstractExpressionVisitor visitor = new AbstractExpressionVisitor(){

                        public Object visit(PropertyName name, Object data) {
                            if (name.evaluate((Object)featureType) == null) {
                                throw new WFSException("Illegal property name: " + name.getPropertyName(), "InvalidParameterValue");
                            }
                            return name;
                        }
                    };
                    query.getFilter().accept((FilterVisitor)new AbstractFilterVisitor((ExpressionVisitor)visitor), null);
                }
                Query gtQuery = this.toDataQuery(query, maxFeatures - count, source);
                LOGGER.fine("Query is " + query + "\n To gt2: " + gtQuery);
                Object features = source.getFeatures(gtQuery);
                count += features.size();
                if (extraGeometries.size() > 0) {
                    ArrayList residualProperties = new ArrayList(properties);
                    residualProperties.removeAll(extraGeometries);
                    String[] residualNames = residualProperties.toArray(new String[residualProperties.size()]);
                    FeatureType targetType = DataUtilities.createSubType((FeatureType)features.getSchema(), (String[])residualNames);
                    features = new FeatureBoundsFeatureCollection((FeatureCollection)features, targetType);
                }
                result.getFeature().add(features);
            }
        }
        catch (IOException e) {
            throw new WFSException("Error occurred getting features", e, request.getHandle());
        }
        catch (SchemaException e) {
            throw new WFSException("Error occurred getting features", e, request.getHandle());
        }
        if (request instanceof GetFeatureWithLockType) {
            GetFeatureWithLockType withLockRequest = (GetFeatureWithLockType)request;
            LockFeatureType lockRequest = WfsFactory.eINSTANCE.createLockFeatureType();
            lockRequest.setExpiry(withLockRequest.getExpiry());
            lockRequest.setHandle(withLockRequest.getHandle());
            lockRequest.setLockAction(AllSomeType.ALL_LITERAL);
            for (int i = 0; i < request.getQuery().size(); ++i) {
                QueryType query = (QueryType)request.getQuery().get(i);
                LockType lock = WfsFactory.eINSTANCE.createLockType();
                lock.setFilter(query.getFilter());
                lock.setHandle(query.getHandle());
                lock.setTypeName((QName)query.getTypeName().get(0));
                lockRequest.getLock().add(lock);
            }
            LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
            lockFeature.setFilterFactory(this.filterFactory);
            LockFeatureResponseType response = lockFeature.lockFeature(lockRequest);
            result.setLockId(response.getLockId());
        }
        result.setNumberOfFeatures(BigInteger.valueOf(count));
        result.setTimeStamp(Calendar.getInstance());
        return result;
    }

    public Query toDataQuery(QueryType query, int maxFeatures, FeatureSource source) throws WFSException {
        CoordinateReferenceSystem crs;
        Filter filter;
        if (maxFeatures <= 0) {
            maxFeatures = Integer.MAX_VALUE;
        }
        String[] props = null;
        if (!query.getPropertyName().isEmpty()) {
            props = new String[query.getPropertyName().size()];
            for (int p = 0; p < query.getPropertyName().size(); ++p) {
                String propertyName;
                props[p] = propertyName = (String)query.getPropertyName().get(p);
            }
        }
        if ((filter = query.getFilter()) == null) {
            filter = Filter.INCLUDE;
        }
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        ReprojectingFilterVisitor visitor = new ReprojectingFilterVisitor(ff, source.getSchema());
        Filter transformedFilter = (Filter)filter.accept((FilterVisitor)visitor, null);
        QName typeName = (QName)query.getTypeName().get(0);
        DefaultQuery dataQuery = new DefaultQuery(typeName.getLocalPart(), transformedFilter, maxFeatures, props, query.getHandle());
        CoordinateReferenceSystem coordinateReferenceSystem = crs = source.getSchema().getDefaultGeometry() != null ? source.getSchema().getDefaultGeometry().getCoordinateSystem() : null;
        if (crs == null) {
            try {
                crs = CRS.decode((String)"EPSG:4326");
                dataQuery.setCoordinateSystem(crs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (query.getSrsName() != null) {
            CoordinateReferenceSystem target;
            try {
                target = CRS.decode((String)query.getSrsName().toString());
            }
            catch (Exception e) {
                String msg = "Unable to support srsName: " + query.getSrsName();
                throw new WFSException(msg, e);
            }
            if (!crs.equals(target)) {
                dataQuery.setCoordinateSystemReproject(target);
            }
        }
        if (query.getSortBy() != null) {
            EList sortBy = query.getSortBy();
            dataQuery.setSortBy(sortBy.toArray(new SortBy[sortBy.size()]));
        }
        if (query.getFeatureVersion() != null) {
            dataQuery.setVersion(query.getFeatureVersion());
        }
        return dataQuery;
    }

    FeatureTypeInfo featureTypeInfo(QName name) throws WFSException, IOException {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(name.getLocalPart(), name.getNamespaceURI());
        if (meta == null) {
            String msg = "Could not locate " + name + " in catalog.";
            throw new WFSException(msg);
        }
        return meta;
    }
}

