/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.geoserver.wfs.DescribeFeatureType;
import org.geoserver.wfs.GetCapabilities;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.Transaction;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WebFeatureService;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.filter.FilterFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class DefaultWebFeatureService
implements WebFeatureService,
ApplicationContextAware {
    protected WFS wfs;
    protected Data catalog;
    protected FilterFactory filterFactory;
    protected ApplicationContext context;

    public DefaultWebFeatureService(WFS wfs, Data catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public TransformerBase getCapabilities(GetCapabilitiesType request) throws WFSException {
        return new GetCapabilities(this.wfs, this.catalog).run(request);
    }

    public FeatureTypeInfo[] describeFeatureType(DescribeFeatureTypeType request) throws WFSException {
        return new DescribeFeatureType(this.wfs, this.catalog).run(request);
    }

    public FeatureCollectionType getFeature(GetFeatureType request) throws WFSException {
        GetFeature getFeature = new GetFeature(this.wfs, this.catalog);
        getFeature.setFilterFactory(this.filterFactory);
        return getFeature.run(request);
    }

    public FeatureCollectionType getFeatureWithLock(GetFeatureWithLockType request) throws WFSException {
        return this.getFeature((GetFeatureType)request);
    }

    public LockFeatureResponseType lockFeature(LockFeatureType request) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.setFilterFactory(this.filterFactory);
        return lockFeature.lockFeature(request);
    }

    public TransactionResponseType transaction(TransactionType request) throws WFSException {
        Transaction transaction = new Transaction(this.wfs, this.catalog, this.context);
        transaction.setFilterFactory(this.filterFactory);
        return transaction.transaction(request);
    }

    public void releaseLock(String lockId) throws WFSException {
        new LockFeature(this.wfs, this.catalog).release(lockId);
    }

    public void releaseAllLocks() throws WFSException {
        new LockFeature(this.wfs, this.catalog).releaseAll();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

