/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import net.opengis.wfs.GetCapabilitiesType;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geotools.filter.FunctionExpression;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.expression.Function;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.FeatureTypeInfoTitleComparator;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class CapabilitiesTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logger.getLogger((class$org$geoserver$wfs$CapabilitiesTransformer == null ? (class$org$geoserver$wfs$CapabilitiesTransformer = CapabilitiesTransformer.class$("org.geoserver.wfs.CapabilitiesTransformer")) : class$org$geoserver$wfs$CapabilitiesTransformer).getPackage().getName());
    private static final String HTTP_GET = "Get";
    private static final String HTTP_POST = "Post";
    protected static final String WFS_URI = "http://www.opengis.net/wfs";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String OGC_PREFIX = "ogc";
    protected static final String OGC_URI = "http://www.opengis.net/ogc";
    protected WFS wfs;
    protected Data catalog;
    static /* synthetic */ Class class$org$geoserver$wfs$CapabilitiesTransformer;
    static /* synthetic */ Class class$org$geoserver$wfs$WFSGetFeatureOutputFormat;
    static /* synthetic */ Class class$org$opengis$filter$expression$Function;

    public CapabilitiesTransformer(WFS wfs, Data catalog) {
        this.setNamespaceDeclarationEnabled(false);
        this.wfs = wfs;
        this.catalog = catalog;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WFS1_1
    extends CapabilitiesTransformer {
        public WFS1_1(WFS wfs, Data catalog) {
            super(wfs, catalog);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_1(handler);
        }

        class CapabilitiesTranslator1_1
        extends TransformerBase.TranslatorSupport {
            GetCapabilitiesType request;

            public CapabilitiesTranslator1_1(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = (GetCapabilitiesType)object;
                String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WFS1_1.this.wfs.getGeoServer().getProxyBaseUrl());
                AttributesImpl attributes = this.attributes(new String[]{"version", "1.1.0", "xmlns:xsi", CapabilitiesTransformer.XSI_URI, "xmlns", CapabilitiesTransformer.WFS_URI, "xmlns:wfs", CapabilitiesTransformer.WFS_URI, "xmlns:ows", "http://www.opengis.net/ows", "xmlns:gml", "http://www.opengis.net/gml", "xmlns:ogc", CapabilitiesTransformer.OGC_URI, "xmlns:xlink", "http://www.w3.org/1999/xlink", "xsi:schemaLocation", "http://www.opengis.net/wfs " + ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.1.0/wfs.xsd")});
                NameSpaceInfo[] namespaces = WFS1_1.this.catalog.getNameSpaces();
                for (int i = 0; i < namespaces.length; ++i) {
                    NameSpaceInfo namespace = namespaces[i];
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                this.start("wfs:WFS_Capabilities", attributes);
                this.serviceIdentification();
                this.serviceProvider();
                this.operationsMetadata();
                this.featureTypeList();
                this.filterCapabilities();
                this.end("wfs:WFS_Capabilities");
            }

            void serviceIdentification() {
                this.start("ows:ServiceIdentification");
                this.element("ows:Title", WFS1_1.this.wfs.getTitle());
                this.element("ows:Abstract", WFS1_1.this.wfs.getAbstract());
                this.keywords(WFS1_1.this.wfs.getKeywords());
                this.element("ows:ServiceType", "WFS");
                this.element("ows:ServiceTypeVersion", "1.1.0");
                this.element("ows:Fees", WFS1_1.this.wfs.getFees());
                this.element("ows:AccessConstraints", WFS1_1.this.wfs.getAccessConstraints());
                this.end("ows:ServiceIdentification");
            }

            void serviceProvider() {
                this.start("ows:ServiceProvider");
                this.element("ows:ProviderName", null);
                this.element("ows:ProviderSite", null);
                this.element("ows:ServiceContact", null);
                this.end("ows:ServiceProvider");
            }

            void operationsMetadata() {
                this.start("ows:OperationsMetadata");
                this.getCapabilities();
                this.describeFeatureType();
                this.getFeature();
                if (WFS1_1.this.wfs.getServiceLevel() == 31) {
                    this.lockFeature();
                    this.getFeatureWithLock();
                }
                if (WFS1_1.this.wfs.getServiceLevel() >= 15) {
                    this.transaction();
                }
                this.end("ows:OperationsMetadata");
            }

            void getCapabilities() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("AcceptVersions", new String[]{"1.0.0", "1.1.0"}), this.parameter("AcceptFormats", new String[]{"text/xml"})};
                this.operation("GetCapabilities", parameters, true, true);
            }

            void describeFeatureType() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("outputFormat", new String[]{"text/gml; subtype=gml/3.1.1"})};
                this.operation("DescribeFeatureType", parameters, true, true);
            }

            void getFeature() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("resultType", new String[]{"results", "hits"}), this.parameter("outputFormat", new String[]{"text/gml; subtype=gml/3.1.1"})};
                this.operation("GetFeature", parameters, true, true);
            }

            void getFeatureWithLock() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("resultType", new String[]{"results", "hits"}), this.parameter("outputFormat", new String[]{"text/gml; subtype=gml/3.1.1"})};
                this.operation("GetFeatureWithLock", parameters, true, true);
            }

            void lockFeature() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("LockFeature", parameters, true, true);
            }

            void transaction() {
                Map.Entry[] parameters = new Map.Entry[]{this.parameter("inputFormat", new String[]{"text/gml; subtype=gml/3.1.1"}), this.parameter("idgen", new String[]{"GenerateNew", "UseExisting", "ReplaceDuplicate"}), this.parameter("releaseAction", new String[]{"ALL", "SOME"})};
                this.operation("Transaction", parameters, true, true);
            }

            void featureTypeList() {
                this.start("FeatureTypeList");
                this.start("Operations");
                if ((WFS1_1.this.wfs.getServiceLevel() | 1) != 0) {
                    this.element("Operation", "Query");
                }
                if ((WFS1_1.this.wfs.getServiceLevel() | 2) != 0) {
                    this.element("Operation", "Insert");
                }
                if ((WFS1_1.this.wfs.getServiceLevel() | 4) != 0) {
                    this.element("Operation", "Update");
                }
                if ((WFS1_1.this.wfs.getServiceLevel() | 8) != 0) {
                    this.element("Operation", "Delete");
                }
                if ((WFS1_1.this.wfs.getServiceLevel() | 0x10) != 0) {
                    this.element("Operation", "Lock");
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_1.this.catalog.getFeatureTypeInfos().values());
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                Iterator i = featureTypes.iterator();
                while (i.hasNext()) {
                    FeatureTypeInfo featureType = (FeatureTypeInfo)i.next();
                    this.featureType(featureType);
                }
                this.end("FeatureTypeList");
            }

            void featureType(FeatureTypeInfo featureType) {
                String prefix = featureType.getNameSpace().getPrefix();
                String uri = featureType.getNameSpace().getURI();
                this.start("FeatureType", this.attributes(new String[]{"xmlns:" + prefix, uri}));
                this.element("Name", featureType.getName());
                this.element("Title", featureType.getTitle());
                this.element("Abstract", featureType.getAbstract());
                this.keywords(featureType.getKeywords());
                this.element("DefaultSRS", "urn:x-ogc:def:crs:EPSG:6.11.2:" + featureType.getSRS());
                this.start("OutputFormats");
                this.element("Format", "text/gml; subtype=gml/3.1.1");
                this.end("OutputFormats");
                Envelope bbox = null;
                try {
                    bbox = featureType.getLatLongBoundingBox();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.start("ows:WGS84BoundingBox");
                this.element("ows:LowerCorner", bbox.getMinX() + " " + bbox.getMinY());
                this.element("ows:UpperCorner", bbox.getMaxX() + " " + bbox.getMaxY());
                this.end("ows:WGS84BoundingBox");
                this.end("FeatureType");
            }

            void supportsGMLObjectTypeList() {
                this.element("SupportsGMLObjectTypeList", null);
            }

            void filterCapabilities() {
                this.start("ogc:Filter_Capabilities");
                this.start("ogc:Spatial_Capabilities");
                this.start("ogc:GeometryOperands");
                this.element("ogc:GeometryOperand", "gml:Envelope");
                this.element("ogc:GeometryOperand", "gml:Point");
                this.element("ogc:GeometryOperand", "gml:LineString");
                this.element("ogc:GeometryOperand", "gml:Polygon");
                this.end("ogc:GeometryOperands");
                this.start("ogc:SpatialOperators");
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Disjoint"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Equals"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "DWithin"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Beyond"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Intersects"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Touches"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Crosses"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Contains"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "Overlaps"}));
                this.element("ogc:SpatialOperator", null, this.attributes(new String[]{"name", "BBOX"}));
                this.end("ogc:SpatialOperators");
                this.end("ogc:Spatial_Capabilities");
                this.start("ogc:Scalar_Capabilities");
                this.element("ogc:LogicalOperators", null);
                this.start("ogc:ComparisonOperators");
                this.element("ogc:ComparisonOperator", "LessThan");
                this.element("ogc:ComparisonOperator", "GreaterThan");
                this.element("ogc:ComparisonOperator", "LessThanEqualTo");
                this.element("ogc:ComparisonOperator", "GreaterThanEqualTo");
                this.element("ogc:ComparisonOperator", "EqualTo");
                this.element("ogc:ComparisonOperator", "NotEqualTo");
                this.element("ogc:ComparisonOperator", "Like");
                this.element("ogc:ComparisonOperator", "Between");
                this.element("ogc:ComparisonOperator", "NullCheck");
                this.end("ogc:ComparisonOperators");
                this.start("ogc:ArithmeticOperators");
                this.element("ogc:SimpleArithmetic", null);
                this.functions();
                this.end("ogc:ArithmeticOperators");
                this.end("ogc:Scalar_Capabilities");
                this.start("ogc:Id_Capabilities");
                this.element("ogc:FID", null);
                this.element("ogc:EID", null);
                this.end("ogc:Id_Capabilities");
                this.end("ogc:Filter_Capabilities");
            }

            void functions() {
                this.start("ogc:Functions");
                Iterator<Object> itr = ServiceRegistry.lookupProviders(class$org$opengis$filter$expression$Function == null ? (class$org$opengis$filter$expression$Function = CapabilitiesTransformer.class$("org.opengis.filter.expression.Function")) : class$org$opengis$filter$expression$Function);
                if (itr.hasNext()) {
                    this.start("ogc:FunctionNames");
                    TreeSet sortedFunctions = new TreeSet(new Comparator(this){
                        private final /* synthetic */ CapabilitiesTranslator1_1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public int compare(Object o1, Object o2) {
                            String n1 = ((Function)o1).getName();
                            String n2 = ((Function)o2).getName();
                            return n1.toLowerCase().compareTo(n2.toLowerCase());
                        }
                    });
                    while (itr.hasNext()) {
                        sortedFunctions.add(itr.next());
                    }
                    itr = sortedFunctions.iterator();
                    while (itr.hasNext()) {
                        Function fe = (Function)itr.next();
                        String name = fe.getName();
                        int nargs = fe.getParameters().size();
                        this.element("ogc:FunctionName", name, this.attributes(new String[]{"nArgs", "" + nargs}));
                    }
                    this.end("ogc:FunctionNames");
                }
                this.end("ogc:Functions");
            }

            void keywords(String[] keywords) {
                if (keywords == null || keywords.length == 0) {
                    return;
                }
                this.start("ows:Keywords");
                for (int i = 0; i < keywords.length; ++i) {
                    this.element("ows:Keyword", keywords[i]);
                }
                this.end("ows:Keywords");
            }

            void keywords(List keywords) {
                this.keywords(keywords.toArray(new String[keywords.size()]));
            }

            void operation(String name, Map.Entry[] parameters, boolean get, boolean post) {
                this.start("ows:Operation", this.attributes(new String[]{"name", name}));
                this.start("ows:DCP");
                this.start("ows:HTTP");
                String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WFS1_1.this.wfs.getGeoServer().getProxyBaseUrl());
                if (proxifiedBaseUrl.endsWith("?")) {
                    proxifiedBaseUrl = proxifiedBaseUrl.substring(0, proxifiedBaseUrl.length() - 1);
                }
                if (proxifiedBaseUrl.indexOf(63) != -1) {
                    proxifiedBaseUrl = proxifiedBaseUrl.substring(0, proxifiedBaseUrl.indexOf(63));
                }
                if (get) {
                    this.element("ows:Get", null, this.attributes(new String[]{"xlink:href", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"wfs?")}));
                }
                if (post) {
                    this.element("ows:Post", null, this.attributes(new String[]{"xlink:href", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"wfs?")}));
                }
                this.end("ows:HTTP");
                this.end("ows:DCP");
                for (int i = 0; i < parameters.length; ++i) {
                    String pname = (String)parameters[i].getKey();
                    String[] pvalues = (String[])parameters[i].getValue();
                    this.start("ows:Parameter", this.attributes(new String[]{"name", pname}));
                    for (int j = 0; j < pvalues.length; ++j) {
                        this.element("ows:Value", pvalues[j]);
                    }
                    this.end("ows:Parameter");
                }
                this.end("ows:Operation");
            }

            AttributesImpl attributes(String[] nameValues) {
                AttributesImpl atts = new AttributesImpl();
                for (int i = 0; i < nameValues.length; i += 2) {
                    String name = nameValues[i];
                    String valu = nameValues[i + 1];
                    atts.addAttribute(null, null, name, null, valu);
                }
                return atts;
            }

            Map.Entry parameter(String name, String[] values) {
                return new Map.Entry(this, name, values){
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ String[] val$values;
                    private final /* synthetic */ CapabilitiesTranslator1_1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$name = val$name;
                        this.val$values = val$values;
                    }

                    public Object getKey() {
                        return this.val$name;
                    }

                    public Object getValue() {
                        return this.val$values;
                    }

                    public Object setValue(Object value) {
                        return null;
                    }
                };
            }
        }
    }

    public static class WFS1_0
    extends CapabilitiesTransformer {
        public WFS1_0(WFS wfs, Data catalog) {
            super(wfs, catalog);
        }

        public Translator createTranslator(ContentHandler handler) {
            return new CapabilitiesTranslator1_0(handler);
        }

        class CapabilitiesTranslator1_0
        extends TransformerBase.TranslatorSupport {
            GetCapabilitiesType request;

            public CapabilitiesTranslator1_0(ContentHandler handler) {
                super(handler, null, null);
            }

            public void encode(Object object) throws IllegalArgumentException {
                this.request = (GetCapabilitiesType)object;
                String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WFS1_0.this.wfs.getGeoServer().getProxyBaseUrl());
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "version", "version", "", "1.0.0");
                attributes.addAttribute("", "xmlns", "xmlns", "", CapabilitiesTransformer.WFS_URI);
                NameSpaceInfo[] namespaces = WFS1_0.this.catalog.getNameSpaces();
                for (int i = 0; i < namespaces.length; ++i) {
                    NameSpaceInfo namespace = namespaces[i];
                    String prefix = namespace.getPrefix();
                    String uri = namespace.getURI();
                    if ("xml".equals(prefix)) continue;
                    String prefixDef = "xmlns:" + prefix;
                    attributes.addAttribute("", prefixDef, prefixDef, "", uri);
                }
                attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", CapabilitiesTransformer.OGC_URI);
                attributes.addAttribute("", "xmlns:xsi", "xmlns:xsi", "", CapabilitiesTransformer.XSI_URI);
                String locationAtt = "xsi:schemaLocation";
                String locationDef = "http://www.opengis.net/wfs " + ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.0.0/WFS-capabilities.xsd");
                attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
                this.start("WFS_Capabilities", attributes);
                this.handleService();
                this.handleCapability();
                this.handleFeatureTypes();
                this.handleFilterCapabilities();
                this.end("WFS_Capabilities");
            }

            private void handleService() {
                this.start("Service");
                this.element("Name", WFS1_0.this.wfs.getName());
                this.element("Title", WFS1_0.this.wfs.getTitle());
                this.element("Abstract", WFS1_0.this.wfs.getAbstract());
                this.handleKeywords(WFS1_0.this.wfs.getKeywords());
                String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WFS1_0.this.wfs.getGeoServer().getProxyBaseUrl());
                this.element("OnlineResource", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"wfs"));
                this.element("Fees", WFS1_0.this.wfs.getFees());
                this.element("AccessConstraints", WFS1_0.this.wfs.getAccessConstraints());
                this.end("Service");
            }

            private void handleKeywords(String[] kwlist) {
                if (kwlist == null) {
                    this.handleKeywords((List)null);
                } else {
                    this.handleKeywords(Arrays.asList(kwlist));
                }
            }

            private void handleKeywords(List kwlist) {
                StringBuffer kwds = new StringBuffer();
                for (int i = 0; kwlist != null && i < kwlist.size(); ++i) {
                    kwds.append(kwlist.get(i));
                    if (i == kwlist.size() - 1) continue;
                    kwds.append(", ");
                }
                this.element("Keywords", kwds.toString());
            }

            private void handleCapability() {
                this.start("Capability");
                this.start("Request");
                this.handleGetCapabilities();
                this.handleDescribeFT();
                this.handleGetFeature();
                if (WFS1_0.this.wfs.getServiceLevel() >= 15) {
                    this.handleTransaction();
                }
                if (WFS1_0.this.wfs.getServiceLevel() == 31) {
                    this.handleLock();
                    this.handleFeatureWithLock();
                }
                this.end("Request");
                this.end("Capability");
            }

            private void handleGetCapabilities() {
                String capName = "GetCapabilities";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDescribeFT() {
                String capName = "DescribeFeatureType";
                this.start(capName);
                this.start("SchemaDescriptionLanguage");
                this.element("XMLSCHEMA", null);
                this.end("SchemaDescriptionLanguage");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleGetFeature() {
                String capName = "GetFeature";
                this.start(capName);
                String resultFormat = "ResultFormat";
                this.start(resultFormat);
                if (WFS1_0.this.wfs.getCiteConformanceHacks()) {
                    this.element("GML2", null);
                } else {
                    List featureProducers = GeoServerExtensions.extensions((Class)(class$org$geoserver$wfs$WFSGetFeatureOutputFormat == null ? (class$org$geoserver$wfs$WFSGetFeatureOutputFormat = CapabilitiesTransformer.class$("org.geoserver.wfs.WFSGetFeatureOutputFormat")) : class$org$geoserver$wfs$WFSGetFeatureOutputFormat));
                    HashMap<String, Object> dupes = new HashMap<String, Object>();
                    Iterator i = featureProducers.iterator();
                    while (i.hasNext()) {
                        WFSGetFeatureOutputFormat format = (WFSGetFeatureOutputFormat)((Object)i.next());
                        if (dupes.containsKey(format.getCapabilitiesElementName())) continue;
                        this.element(format.getCapabilitiesElementName(), null);
                        dupes.put(format.getCapabilitiesElementName(), new Object());
                    }
                }
                this.end(resultFormat);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleTransaction() {
                String capName = "Transaction";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleLock() {
                String capName = "LockFeature";
                this.start(capName);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleFeatureWithLock() {
                String capName = "GetFeatureWithLock";
                this.start(capName);
                this.start("ResultFormat");
                this.element("GML2", null);
                this.end("ResultFormat");
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_GET);
                this.handleDcpType(capName, CapabilitiesTransformer.HTTP_POST);
                this.end(capName);
            }

            private void handleDcpType(String capabilityName, String httpMethod) {
                String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)WFS1_0.this.wfs.getGeoServer().getProxyBaseUrl());
                if (proxifiedBaseUrl.endsWith("?")) {
                    proxifiedBaseUrl = proxifiedBaseUrl.substring(0, proxifiedBaseUrl.length() - 1);
                }
                if (CapabilitiesTransformer.HTTP_GET.equals(httpMethod)) {
                    proxifiedBaseUrl = ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)("wfs?request=" + capabilityName));
                } else if (CapabilitiesTransformer.HTTP_POST.equals(httpMethod)) {
                    proxifiedBaseUrl = ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"wfs?");
                }
                this.start("DCPType");
                this.start("HTTP");
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "onlineResource", "onlineResource", "", proxifiedBaseUrl);
                this.element(httpMethod, null, atts);
                this.end("HTTP");
                this.end("DCPType");
            }

            private void handleFeatureTypes() {
                if (!WFS1_0.this.wfs.isEnabled()) {
                    // empty if block
                }
                this.start("FeatureTypeList");
                this.start("Operations");
                if ((WFS1_0.this.wfs.getServiceLevel() | 1) != 0) {
                    this.element("Query", null);
                }
                if ((WFS1_0.this.wfs.getServiceLevel() | 2) != 0) {
                    this.element("Insert", null);
                }
                if ((WFS1_0.this.wfs.getServiceLevel() | 4) != 0) {
                    this.element("Update", null);
                }
                if ((WFS1_0.this.wfs.getServiceLevel() | 8) != 0) {
                    this.element("Delete", null);
                }
                if ((WFS1_0.this.wfs.getServiceLevel() | 0x10) != 0) {
                    this.element("Lock", null);
                }
                this.end("Operations");
                ArrayList featureTypes = new ArrayList(WFS1_0.this.catalog.getFeatureTypeInfos().values());
                Collections.sort(featureTypes, new FeatureTypeInfoTitleComparator());
                Iterator it = featureTypes.iterator();
                while (it.hasNext()) {
                    FeatureTypeInfo ftype = (FeatureTypeInfo)it.next();
                    this.handleFeatureType(ftype);
                }
                this.end("FeatureTypeList");
            }

            private void handleFeatureType(FeatureTypeInfo info) {
                Envelope bbox = null;
                try {
                    bbox = info.getLatLongBoundingBox();
                }
                catch (IOException e) {
                    String msg = "Could not calculate bbox for: " + info.getName();
                    LOGGER.log(Level.SEVERE, msg, e);
                    return;
                }
                this.start("FeatureType");
                this.element("Name", info.getName());
                this.element("Title", info.getTitle());
                this.element("Abstract", info.getAbstract());
                this.handleKeywords(info.getKeywords());
                this.element("SRS", "EPSG:" + info.getSRS());
                String minx = String.valueOf(bbox.getMinX());
                String miny = String.valueOf(bbox.getMinY());
                String maxx = String.valueOf(bbox.getMaxX());
                String maxy = String.valueOf(bbox.getMaxY());
                AttributesImpl bboxAtts = new AttributesImpl();
                bboxAtts.addAttribute("", "minx", "minx", "", minx);
                bboxAtts.addAttribute("", "miny", "miny", "", miny);
                bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
                bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
                this.element("LatLongBoundingBox", null, bboxAtts);
                this.end("FeatureType");
            }

            private void handleFilterCapabilities() {
                String ogc = "ogc:";
                this.start(ogc + "Filter_Capabilities");
                this.start(ogc + "Spatial_Capabilities");
                this.start(ogc + "Spatial_Operators");
                this.element(ogc + "Disjoint", null);
                this.element(ogc + "Equals", null);
                this.element(ogc + "DWithin", null);
                this.element(ogc + "Beyond", null);
                this.element(ogc + "Intersect", null);
                this.element(ogc + "Touches", null);
                this.element(ogc + "Crosses", null);
                this.element(ogc + "Within", null);
                this.element(ogc + "Contains", null);
                this.element(ogc + "Overlaps", null);
                this.element(ogc + "BBOX", null);
                this.end(ogc + "Spatial_Operators");
                this.end(ogc + "Spatial_Capabilities");
                this.start(ogc + "Scalar_Capabilities");
                this.element(ogc + "Logical_Operators", null);
                this.start(ogc + "Comparison_Operators");
                this.element(ogc + "Simple_Comparisons", null);
                this.element(ogc + "Between", null);
                this.element(ogc + "Like", null);
                this.element(ogc + "NullCheck", null);
                this.end(ogc + "Comparison_Operators");
                this.start(ogc + "Arithmetic_Operators");
                this.element(ogc + "Simple_Arithmetic", null);
                this.handleFunctions(ogc);
                this.end(ogc + "Arithmetic_Operators");
                this.end(ogc + "Scalar_Capabilities");
                this.end(ogc + "Filter_Capabilities");
            }

            private void handleFunctions(String prefix) {
                this.start(prefix + "Functions");
                this.start(prefix + "Function_Names");
                Iterator<Object> it = ServiceRegistry.lookupProviders(class$org$opengis$filter$expression$Function == null ? (class$org$opengis$filter$expression$Function = CapabilitiesTransformer.class$("org.opengis.filter.expression.Function")) : class$org$opengis$filter$expression$Function);
                TreeSet sortedFunctions = new TreeSet(new Comparator(this){
                    private final /* synthetic */ CapabilitiesTranslator1_0 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int compare(Object o1, Object o2) {
                        String n1 = ((Function)o1).getName();
                        String n2 = ((Function)o2).getName();
                        return n1.toLowerCase().compareTo(n2.toLowerCase());
                    }
                });
                while (it.hasNext()) {
                    sortedFunctions.add(it.next());
                }
                it = sortedFunctions.iterator();
                while (it.hasNext()) {
                    Function fe = (Function)it.next();
                    if (!(fe instanceof FunctionExpression)) continue;
                    String funName = fe.getName();
                    int funNArgs = ((FunctionExpression)fe).getArgCount();
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "nArgs", "nArgs", "", funNArgs + "");
                    this.element(prefix + "Function_Name", funName, atts);
                }
                this.end(prefix + "Function_Names");
                this.end(prefix + "Functions");
            }
        }
    }
}

