/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.servlets;

import java.util.Map;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.servlets.FileStrategy;
import org.vfny.geoserver.servlets.ServiceStrategy;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wfs.requests.readers.DeleteKvpReader;
import org.vfny.geoserver.wfs.requests.readers.TransactionXmlReader;
import org.vfny.geoserver.wfs.responses.TransactionResponse;
import org.vfny.geoserver.wfs.servlets.WFService;

public class Transaction
extends WFService {
    FileStrategy fileStrategy;

    public Transaction(WFS wfs) {
        super("Transaction", wfs);
    }

    public void setFileStrategy(FileStrategy fileStrategy) {
        this.fileStrategy = fileStrategy;
    }

    public FileStrategy getFileStrategy() {
        return this.fileStrategy;
    }

    protected Response getResponseHandler() {
        return new TransactionResponse();
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new DeleteKvpReader(params, this);
    }

    protected XmlRequestReader getXmlRequestReader() {
        return new TransactionXmlReader(this);
    }

    protected ServiceStrategy createServiceStrategy() throws ServiceException {
        try {
            return (ServiceStrategy)this.fileStrategy.clone();
        }
        catch (CloneNotSupportedException e) {
            String msg = "Unable to clone " + this.fileStrategy.getClass();
            throw new ServiceException(msg, (Throwable)e);
        }
    }
}

