/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WfsTransResponse {
    private static final Logger LOG = Logger.getLogger("org.vfny.geoserver.responses");
    public static final short SUCCESS = 0;
    public static final short FAILED = 1;
    public static final short PARTIAL = 2;
    public static final String ROOT = "TransactionResponse";
    public static final String INSERT_RESULT = "InsertResult";
    public static final String TRANS_RESULT = "TransactionResult";
    public static final String VERSION = "version";
    public static final String CUR_VERSION = "1.0.0";
    public static final String HANDLE = "handle";
    public static final String STATUS = "Status";
    public static final String V_OFFSET = "   ";
    private boolean verbose = false;
    private String indent = " ";
    private String offset = "";
    public final short status;
    private String handle;
    private String locator = null;
    private String message = null;
    private List insertResults;

    public WfsTransResponse(short status, boolean verbose) {
        this.status = status;
        this.verbose = verbose;
        this.indent = verbose ? "\n   " : " ";
        this.offset = verbose ? V_OFFSET : "";
    }

    public WfsTransResponse(short status, String handle, boolean verbose) {
        this.status = status;
        this.handle = handle;
        this.verbose = verbose;
        this.indent = verbose ? "\n   " : " ";
        this.offset = verbose ? V_OFFSET : "";
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void addInsertResult(String handle, Collection featureIds) {
        if (this.insertResults == null) {
            this.insertResults = new ArrayList();
        }
        this.insertResults.add(new InsertResult(handle, featureIds));
    }

    public void writeXmlResponse(Writer writer, WFSRequest request) throws IOException {
        String encoding = request == null ? "UTF-8" : request.getWFS().getGeoServer().getCharSet().name();
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("<wfs:WFS_TransactionResponse");
        writer.write(String.valueOf(this.indent) + "version=\"" + CUR_VERSION + "\"");
        writer.write(String.valueOf(this.indent) + "xmlns:wfs=\"http://www.opengis.net/wfs\"");
        writer.write(String.valueOf(this.indent) + "xmlns:ogc=\"http://www.opengis.net/ogc\"");
        writer.write(String.valueOf(this.indent) + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.write(this.indent);
        writer.write("xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        String baseUrl = request == null ? "http://schemas.opengis.net/" : request.getSchemaBaseUrl();
        writer.write(baseUrl);
        writer.write("wfs/1.0.0/WFS-transaction.xsd\">");
        if (this.insertResults != null) {
            Iterator iter = this.insertResults.iterator();
            while (iter.hasNext()) {
                ((InsertResult)iter.next()).writeXml(writer);
            }
        }
        writer.write(String.valueOf(this.indent) + "<wfs:TransactionResult");
        if (this.handle != null) {
            writer.write(" handle=\"" + this.handle + "\"");
        }
        writer.write(">");
        writer.write(String.valueOf(this.indent) + this.offset + "<wfs:Status>");
        writer.write(String.valueOf(this.indent) + this.offset + this.offset);
        switch (this.status) {
            case 0: {
                writer.write("<wfs:SUCCESS/>");
                break;
            }
            case 2: {
                writer.write("<wfs:PARTIAL/>");
                break;
            }
            default: {
                writer.write("<wfs:FAILED/>");
            }
        }
        writer.write(String.valueOf(this.indent) + this.offset + "</wfs:Status>");
        if (this.locator != null) {
            writer.write(String.valueOf(this.indent) + this.offset + "<wfs:Locator>");
            writer.write(String.valueOf(this.locator) + "</wfs:Locator>");
        }
        if (this.message != null) {
            writer.write(String.valueOf(this.indent) + this.offset + "<wfs:Message>");
            ResponseUtils.writeEscapedString((Writer)writer, (String)this.message);
            writer.write("</wfs:Message>");
        }
        writer.write(String.valueOf(this.indent) + "</wfs:TransactionResult>");
        if (this.verbose) {
            writer.write("\n");
        }
        writer.write("</wfs:WFS_TransactionResponse>");
    }

    public String getXmlResponse(WFSRequest gs) {
        StringWriter writer = new StringWriter();
        try {
            this.writeXmlResponse(writer, gs);
        }
        catch (IOException e) {
            return null;
        }
        return writer.toString();
    }

    private boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    private class InsertResult {
        private String handle;
        private Collection featureIds;

        public InsertResult(String handle, Collection featureIds) {
            this.handle = handle;
            this.featureIds = featureIds;
        }

        public void writeXml(Writer writer) throws IOException {
            writer.write(WfsTransResponse.this.indent);
            writer.write("<wfs:InsertResult");
            if (this.handle != null) {
                writer.write(" handle=\"" + this.handle + "\"");
            }
            writer.write(">");
            Iterator iter = this.featureIds.iterator();
            while (iter.hasNext()) {
                writer.write(String.valueOf(WfsTransResponse.this.indent) + WfsTransResponse.this.offset + "<ogc:FeatureId fid=\"");
                writer.write(iter.next() + "\"/>");
            }
            writer.write(String.valueOf(WfsTransResponse.this.indent) + "</wfs:InsertResult>");
        }

        public void getDOM(Element root, Document doc) {
            Element insResultElem = doc.createElement(WfsTransResponse.INSERT_RESULT);
            if (!WfsTransResponse.this.isEmpty(this.handle)) {
                insResultElem.setAttribute(WfsTransResponse.HANDLE, this.handle);
            }
            root.appendChild(insResultElem);
            if (this.featureIds != null) {
                LOG.finest("there is a list of feature ids in insertRes");
                Iterator iter = this.featureIds.iterator();
                while (iter.hasNext()) {
                    Element fid = doc.createElement("FeatureId");
                    fid.setAttribute("fid", iter.next().toString());
                    LOG.finest("adding fid " + fid);
                    insResultElem.appendChild(fid);
                }
            }
        }
    }
}

