/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureType;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;

public class ShapeFeatureResponseDelegate
implements FeatureResponseDelegate {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wfs.responses");
    public static final String formatName = "SHAPE-ZIP";
    private static int counter = 0;
    String vmTempDir = null;
    private GetFeatureResults results;
    private String featureTypeName;

    public boolean canProduce(String outputFormat) {
        return formatName.equalsIgnoreCase(outputFormat);
    }

    public void prepare(String outputFormat, GetFeatureResults results) throws IOException {
        this.results = results;
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not succeed. <results> is null");
        }
        this.vmTempDir = System.getProperty("java.io.tmpdir");
        if (this.vmTempDir == null) {
            throw new NullPointerException("<tempDir> is null. There is a problem with the java.io.tempdir directory.");
        }
    }

    public String getContentType(GeoServer gs) {
        return "application/zip";
    }

    public String getContentEncoding() {
        return formatName;
    }

    /*
     * Exception decompiling
     */
    public void encode(OutputStream output) throws ServiceException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 561->565)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean removeDirectory(File tempDir) {
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            return false;
        }
        File[] files = tempDir.listFiles();
        if (files == null) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.removeDirectory(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        return tempDir.delete();
    }

    private void readInWriteOutBytes(OutputStream output, InputStream in) throws IOException {
        int c;
        while (-1 != (c = in.read())) {
            output.write(c);
        }
    }

    private void writeOut(String name, File tempDir, FeatureType schema, FeatureReader reader) throws IOException, ServiceException {
        File file = new File(tempDir, name);
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        FeatureStore store = (FeatureStore)sfds.getFeatureSource(name);
        store.addFeatures(reader);
    }

    public String getContentDisposition(String featureTypeName) {
        return "attachment; filename=" + featureTypeName + ".zip";
    }

    private synchronized File createTempDirectory() throws IOException {
        File testFolder;
        while ((testFolder = new File(this.vmTempDir, "wfsshp" + ++counter)).exists() || !testFolder.mkdir()) {
        }
        return testFolder;
    }
}

