/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.LockRequest;
import org.vfny.geoserver.wfs.requests.WFSRequest;

public class LockResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    private static boolean verbose = false;
    private static String nl = "";
    private String xmlResponse = null;
    FeatureLock featureLock = null;
    LockRequest request = null;

    public LockResponse(GeoServer gs) {
        verbose = gs.isVerbose();
        nl = verbose ? "\n" : "";
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request r) throws WfsException {
        WFSRequest req = (WFSRequest)r;
        if (!(req instanceof LockRequest)) {
            throw new WfsException("bad request, expected LockRequest, got " + (Object)((Object)req));
        }
        if ((req.getWFS().getServiceLevel() & 0x10) == 0) {
            throw new WfsException("Locking support is not enabled");
        }
        this.request = (LockRequest)req;
        this.xmlResponse = LockResponse.getXmlResponse(this.request);
    }

    public String getContentType(GeoServer gs) {
        return gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    public void writeTo(OutputStream out) throws ServiceException {
        try {
            byte[] content = this.xmlResponse.getBytes();
            out.write(content);
        }
        catch (IOException ex) {
            throw new WfsException(ex, "", this.getClass().getName());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String performLock(LockRequest request, boolean getXml) throws WfsException, IOException {
        LOGGER.finer("about to do Lock response on:" + (Object)((Object)request));
        List locks = request.getLocks();
        if (locks.size() == 0) {
            throw new WfsException("A LockFeature request must contain at least one LOCK element");
        }
        LockRequest.Lock curLock = (LockRequest.Lock)locks.get(0);
        boolean lockAll = request.getLockAll();
        FeatureLock fLock = request.toFeatureLock();
        HashSet<String> lockedFids = new HashSet<String>();
        HashSet<String> lockFailedFids = new HashSet<String>();
        GeoServer config = request.getGeoServer();
        Data catalog = request.getWFS().getData();
        FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
        LOGGER.info("locks size is " + locks.size());
        if (locks.size() == 0) {
            throw new WfsException("Lock Request must contain at least one  Lock element, your request is " + (Object)((Object)request));
        }
        int i = 0;
        int n = locks.size();
        while (true) {
            block16: {
                Object var25_26;
                if (i >= n) {
                    if (!lockAll || lockFailedFids.isEmpty()) break;
                    throw new WfsException("Could not aquire locks for:" + lockFailedFids);
                }
                curLock = (LockRequest.Lock)locks.get(i);
                LOGGER.info("curLock is " + curLock);
                String curTypeName = curLock.getFeatureType();
                Filter curFilter = curLock.getFilter();
                FeatureTypeInfo meta = catalog.getFeatureTypeInfo(curTypeName);
                NameSpaceInfo namespace = meta.getDataStoreInfo().getNameSpace();
                FeatureSource source = meta.getFeatureSource();
                FeatureCollection features = source.getFeatures(curFilter);
                if (source instanceof FeatureLocking) {
                    ((FeatureLocking)source).setFeatureLock(fLock);
                }
                FeatureReader reader = null;
                try {
                    try {
                        reader = features.reader();
                        while (reader.hasNext()) {
                            Feature feature = reader.next();
                            String fid = feature.getID();
                            if (!(source instanceof FeatureLocking)) {
                                LOGGER.fine("Lock " + fid + " not supported by data store (authID:" + fLock.getAuthorization() + ")");
                                lockFailedFids.add(fid);
                                continue;
                            }
                            FidFilter fidFilter = filterFactory.createFidFilter(fid);
                            DefaultQuery query = new DefaultQuery(meta.getTypeName(), (Filter)fidFilter, Integer.MAX_VALUE, Query.ALL_NAMES, curLock.getHandle());
                            int numberLocked = ((FeatureLocking)source).lockFeatures((Query)query);
                            if (numberLocked == 1) {
                                LOGGER.fine("Lock " + fid + " (authID:" + fLock.getAuthorization() + ")");
                                lockedFids.add(fid);
                                continue;
                            }
                            if (numberLocked == 0) {
                                LOGGER.fine("Lock " + fid + " conflict (authID:" + fLock.getAuthorization() + ")");
                                lockFailedFids.add(fid);
                                continue;
                            }
                            LOGGER.warning("Lock " + numberLocked + " " + fid + " (authID:" + fLock.getAuthorization() + ") duplicated FeatureID!");
                            lockedFids.add(fid);
                        }
                    }
                    catch (IllegalAttributeException e) {
                        throw new WfsException("Lock request " + curFilter + " did not match " + curTypeName);
                    }
                }
                catch (Throwable throwable) {
                    var25_26 = null;
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                {
                    var25_26 = null;
                    if (reader == null) break block16;
                }
                reader.close();
            }
            ++i;
        }
        if (getXml) {
            return LockResponse.generateXml(fLock.getAuthorization(), lockAll, lockedFids, lockFailedFids, request);
        }
        return fLock.getAuthorization();
    }

    private static String getXmlResponse(LockRequest request) throws WfsException {
        try {
            return LockResponse.performLock(request, true);
        }
        catch (IOException ioException) {
            ioException.printStackTrace(System.out);
            WfsException wfsException = new WfsException("Problem aquiring lock");
            wfsException.initCause(ioException);
            throw wfsException;
        }
    }

    private static String generateXml(String lockId, boolean lockAll, Set lockedFeatures, Set notLockedFeatures, WFSRequest request) {
        String indent = verbose ? "   " : "";
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"" + request.getWFS().getGeoServer().getCharSet().name() + "\"?>";
        StringBuffer returnXml = new StringBuffer(xmlHeader);
        returnXml.append(String.valueOf(nl) + "<WFS_LockFeatureResponse " + nl);
        returnXml.append(String.valueOf(indent) + "xmlns=\"http://www.opengis.net/wfs\" " + nl);
        if (!lockAll) {
            returnXml.append(String.valueOf(indent) + "xmlns:ogc=\"http://www.opengis.net/ogc\" " + nl);
        }
        returnXml.append(String.valueOf(indent) + "xmlns:xsi=\"http://www.w3.org/2001/" + "XMLSchema-instance\" " + nl);
        returnXml.append(String.valueOf(indent) + "xsi:schemaLocation=\"http://www.opengis");
        returnXml.append(".net/wfs ");
        returnXml.append(request.getSchemaBaseUrl());
        returnXml.append("wfs/1.0.0/WFS-transaction.xsd\">");
        returnXml.append(nl);
        returnXml.append(String.valueOf(indent) + "<LockId>" + lockId + "</LockId>" + nl);
        if (!lockAll) {
            Iterator i;
            if (lockedFeatures != null && lockedFeatures.size() > 0) {
                returnXml.append(String.valueOf(indent) + "<FeaturesLocked>" + nl);
                i = lockedFeatures.iterator();
                while (i.hasNext()) {
                    returnXml.append(String.valueOf(indent) + indent);
                    returnXml.append("<ogc:FeatureId fid=\"" + i.next() + "\"/>" + nl);
                }
                returnXml.append(String.valueOf(indent) + "</FeaturesLocked>" + nl);
            }
            if (notLockedFeatures != null && notLockedFeatures.size() > 0) {
                returnXml.append("<FeaturesNotLocked>" + nl);
                i = notLockedFeatures.iterator();
                while (i.hasNext()) {
                    returnXml.append(String.valueOf(indent) + indent);
                    returnXml.append("<ogc:FeatureId fid=\"" + i.next() + "\"/>" + nl);
                }
                returnXml.append("</FeaturesNotLocked>" + nl);
            }
        }
        returnXml.append("</WFS_LockFeatureResponse>");
        return returnXml.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abort(Service gs) {
        if (this.request == null) {
            return;
        }
        if (this.featureLock == null) {
            return;
        }
        Data catalog = gs.getData();
        try {
            GeoServer config = gs.getGeoServer();
            Iterator i = this.request.getLocks().iterator();
            while (true) {
                Object var10_11;
                if (!i.hasNext()) {
                    return;
                }
                LockRequest.Lock curLock = (LockRequest.Lock)i.next();
                String curTypeName = curLock.getFeatureType();
                FeatureTypeInfo meta = catalog.getFeatureTypeInfo(curTypeName);
                FeatureLocking source = (FeatureLocking)meta.getFeatureSource();
                DefaultTransaction t = new DefaultTransaction();
                try {
                    t.addAuthorization(this.featureLock.getAuthorization());
                    source.getDataStore().getLockingManager().release(this.featureLock.getAuthorization(), (Transaction)t);
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    t.close();
                    throw throwable;
                }
                {
                    var10_11 = null;
                }
                t.close();
            }
        }
        catch (IOException ioException) {
            LOGGER.warning("Abort not complete:" + ioException);
        }
    }

    public String getContentDisposition() {
        return null;
    }
}

