/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.wfs.FeatureResponseDelegateProducerSpi;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GML2FeatureResponseDelegate;

public class GML2FeatureResponseDelegateFactory
implements FeatureResponseDelegateProducerSpi {
    static HashSet supportedFormats = new HashSet();

    static {
        supportedFormats.add("GML2");
        supportedFormats.add("GML2-GZIP");
    }

    public String getName() {
        return "GML2 Ouput (uncompressed or gziped)";
    }

    public Set getSupportedFormats() {
        return supportedFormats;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String outputFormat) {
        return "GML2".equalsIgnoreCase(outputFormat) || "GML2-GZIP".equalsIgnoreCase(outputFormat);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public FeatureResponseDelegate createFeatureDelegateProducer(String format) throws IllegalArgumentException {
        if (this.canProduce(format)) {
            return new GML2FeatureResponseDelegate();
        }
        throw new IllegalArgumentException("cannot produce " + format);
    }
}

