/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.LockHandler;
import org.vfny.geoserver.wfs.requests.LockRequest;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class LockXmlReader
extends XmlRequestReader {
    static /* synthetic */ Class class$0;

    public LockXmlReader(WFService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WfsException {
        InputSource requestSource = new InputSource(reader);
        LockHandler contentHandler = new LockHandler((WFService)this.getServiceRef());
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            LOGGER.finest("about to create parser");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            LOGGER.finest("setting the content handler");
            LOGGER.finest("content handler = " + documentFilter);
            adapter.setContentHandler((ContentHandler)documentFilter);
            LOGGER.finest("about to parse");
            LOGGER.finest("calling parse on " + requestSource);
            adapter.parse(requestSource);
            LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            e.printStackTrace(System.out);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WfsException(e, "XML getFeature request SAX parsing error", clazz.getName());
        }
        catch (IOException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WfsException(e, "XML get feature request input error", clazz.getName());
        }
        catch (ParserConfigurationException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.vfny.geoserver.util.requests.readers.XmlRequestReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WfsException(e, "Some sort of issue creating parser", clazz.getName());
        }
        LockRequest r = contentHandler.getRequest(req);
        return r;
    }
}

