/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.CapabilitiesHandler;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class CapabilitiesXmlReader
extends XmlRequestReader {
    public CapabilitiesXmlReader(WFService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WfsException {
        InputSource requestSource = new InputSource(reader);
        CapabilitiesHandler currentRequest = new CapabilitiesHandler(this.getServiceRef());
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)currentRequest);
            adapter.parse(requestSource);
            LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            throw new WfsException(e, "XML capabilities request parsing error", ((Object)((Object)this)).getClass().getName());
        }
        catch (IOException e) {
            throw new WfsException(e, "XML capabilities request input error", ((Object)((Object)this)).getClass().getName());
        }
        catch (ParserConfigurationException e) {
            throw new WfsException(e, "Some sort of issue creating parser", ((Object)((Object)this)).getClass().getName());
        }
        CapabilitiesRequest r = currentRequest.getRequest(req);
        return r;
    }
}

