/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.vfny.geoserver.wfs.requests.SubTransactionRequest;

public class UpdateRequest
extends SubTransactionRequest {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private List properties;
    private Filter filter = Filter.NONE;
    protected boolean releaseAll = true;

    public UpdateRequest() {
        this.properties = new ArrayList();
    }

    public void addProperty(String propertyName, Object value) {
        String[] splitName = propertyName.split("[.:/]");
        String newPropName = propertyName;
        newPropName = splitName.length == 1 ? splitName[0] : splitName[splitName.length - 1];
        this.properties.add(new Property(newPropName, value));
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean getReleaseAll() {
        return this.releaseAll;
    }

    public void setReleaseAll(boolean releaseAll) {
        this.releaseAll = releaseAll;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Object[] getValues() {
        int arrSize = this.properties.size();
        Object[] retArr = new Object[arrSize];
        int i = 0;
        while (i < arrSize) {
            retArr[i] = ((Property)this.properties.get(i)).getValue();
            ++i;
        }
        return retArr;
    }

    public String[] getPropertyNames() {
        int arrSize = this.properties.size();
        String[] retArr = new String[arrSize];
        int i = 0;
        while (i < arrSize) {
            retArr[i] = ((Property)this.properties.get(i)).getName();
            ++i;
        }
        return retArr;
    }

    public AttributeType[] getTypes(FeatureType schema) throws SchemaException {
        int arrSize = this.properties.size();
        AttributeType[] retArr = new AttributeType[arrSize];
        int i = 0;
        while (i < arrSize) {
            String curName = ((Property)this.properties.get(i)).getName();
            AttributeType curType = schema.getAttributeType(curName);
            if (curType == null) {
                String message = "Could not find property named: " + curName + " in schema: " + schema.getTypeName();
                throw new SchemaException(message);
            }
            retArr[i] = curType;
            ++i;
        }
        return retArr;
    }

    public short getOpType() {
        return 0;
    }

    private boolean testField(Object mine, Object test) {
        if (mine != null) {
            return mine.equals(test);
        }
        return test == null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            UpdateRequest testUpdate = (UpdateRequest)obj;
            boolean isEqual = true;
            isEqual = this.testField(this.filter, testUpdate.filter) && isEqual;
            isEqual = this.testField(this.typeName, testUpdate.typeName) && isEqual;
            isEqual = this.testField(this.handle, testUpdate.handle) && isEqual;
            boolean bl = isEqual = this.releaseAll == testUpdate.releaseAll && isEqual;
            if (this.properties.size() == testUpdate.properties.size()) {
                int i = 0;
                while (i < testUpdate.properties.size()) {
                    isEqual = isEqual && this.properties.contains(testUpdate.properties.get(i));
                    ++i;
                }
            } else {
                isEqual = false;
            }
            return isEqual;
        }
        return false;
    }

    public String toString() {
        StringBuffer uRequest = new StringBuffer("TypeName: " + this.typeName);
        uRequest.append("\nhandle: " + this.handle);
        uRequest.append("\nReleaseAll: " + this.releaseAll);
        uRequest.append("\nfilter: " + this.filter + "\n");
        int i = 0;
        while (i < this.properties.size()) {
            uRequest.append(String.valueOf(this.properties.get(i).toString()) + "\n");
            ++i;
        }
        return uRequest.toString();
    }

    private class Property {
        private String name;
        private Object value;

        public Property(String name, Object value) {
            this.name = name;
            this.value = value;
            LOGGER.finer("New property " + this.toString());
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == this.getClass()) {
                Property prop = (Property)obj;
                return UpdateRequest.this.testField(this.name, prop.getName()) && UpdateRequest.this.testField(this.value, prop.getValue());
            }
            return false;
        }

        public String toString() {
            return "Property - Name: " + this.name + ", Value: " + this.value;
        }
    }
}

