/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.net.URI;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.Filter;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.SubTransactionRequest;

public class InsertRequest
extends SubTransactionRequest {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private FeatureCollection features = FeatureCollections.newCollection();
    private boolean releaseAll;

    public boolean getReleaseAll() {
        return this.releaseAll;
    }

    public void setReleaseAll(boolean releaseAll) {
        this.releaseAll = releaseAll;
    }

    public void addFeature(Feature feature) throws WfsException {
        if (this.typeName == null) {
            this.features.add((Object)feature);
            String name = feature.getFeatureType().getTypeName();
            URI uri = feature.getFeatureType().getNamespace();
            LOGGER.info("got type " + name + "," + uri);
            this.setTypeName(feature.getFeatureType().getTypeName());
        } else {
            String addTypeName = feature.getFeatureType().getTypeName();
            if (this.typeName.equals(addTypeName)) {
                this.features.add((Object)feature);
            } else {
                throw new WfsException("features do not match- added typeName: " + addTypeName + ", set typeName: " + this.typeName, this.handle);
            }
        }
    }

    public void addFeatures(Feature[] features) throws WfsException {
        int i = 0;
        while (i < features.length) {
            this.addFeature(features[i]);
            ++i;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public FeatureCollection getFeatures() {
        return this.features;
    }

    public void setFilter(Filter filter) throws WfsException {
        throw new WfsException("Attempted to add filter (" + filter + ") to update request: " + this.handle);
    }

    public short getOpType() {
        return 1;
    }

    public String toString() {
        StringBuffer iRequest = new StringBuffer("Handle: " + this.handle);
        iRequest.append("\nReleaseAll: " + this.releaseAll);
        iRequest.append("\nTypeName: " + this.typeName + "\n");
        Iterator featIter = this.features.iterator();
        while (featIter.hasNext()) {
            iRequest.append(String.valueOf(featIter.next().toString()) + "\n");
        }
        return iRequest.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InsertRequest)) {
            return false;
        }
        InsertRequest testInsert = (InsertRequest)obj;
        boolean isEqual = true;
        isEqual = this.handle != null ? this.handle.equals(testInsert.handle) : testInsert == null;
        LOGGER.finest("handles are equal: " + isEqual);
        isEqual = this.releaseAll == testInsert.releaseAll && isEqual;
        LOGGER.finest("releaseAll equal: " + isEqual);
        if (this.features.size() != testInsert.getFeatures().size()) {
            isEqual = false;
        }
        LOGGER.finest("features are equal " + isEqual);
        return isEqual;
    }
}

