/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterHandler;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.requests.FeatureWithLockRequest;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class FeatureHandler
extends XMLFilterImpl
implements ContentHandler,
FilterHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private WFService service;
    private FeatureRequest request = null;
    private String insideTag = new String();
    private boolean insideQuery = false;
    private Query currentQuery = new Query();
    private StringBuffer characters = new StringBuffer();

    public FeatureHandler(WFService service) {
        this.service = service;
        this.request = new FeatureRequest(service);
    }

    public FeatureRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        block13: {
            block12: {
                LOGGER.finest("at start element: " + localName);
                this.characters.setLength(0);
                this.insideTag = localName;
                if (!this.insideTag.equals("Query")) break block12;
                this.currentQuery = new Query();
                this.insideQuery = true;
                int i = 0;
                int n = atts.getLength();
                while (i < n) {
                    String name = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    LOGGER.finest("found attribute '" + name + "'=" + value);
                    if (name.equals("typeName")) {
                        this.currentQuery.setTypeName(value);
                    } else if (name.equals("handle")) {
                        this.currentQuery.setHandle(value);
                    }
                    ++i;
                }
                break block13;
            }
            if (!this.insideTag.startsWith("GetFeature")) break block13;
            this.request = this.insideTag.equals("GetFeatureWithLock") ? new FeatureWithLockRequest(this.service) : new FeatureRequest(this.service);
            int i = 0;
            while (i < atts.getLength()) {
                String curAtt = atts.getLocalName(i);
                if (curAtt.equals("maxFeatures")) {
                    LOGGER.finest("found max features: " + atts.getValue(i));
                    this.request.setMaxFeatures(atts.getValue(i));
                } else if (curAtt.equals("outputFormat")) {
                    LOGGER.finest("found outputFormat: " + atts.getValue(i));
                    this.request.setOutputFormat(atts.getValue(i));
                } else if (curAtt.equals("expiry") && this.request instanceof FeatureWithLockRequest) {
                    int expiry = -1;
                    try {
                        expiry = Integer.parseInt(atts.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("expiry should parse to an integer", e);
                    }
                    ((FeatureWithLockRequest)this.request).setExpiry(expiry);
                }
                ++i;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finer("at end element: " + localName);
        this.handleCharacters();
        this.insideTag = "NULL";
        if (localName.equals("Query")) {
            LOGGER.finest("adding query: " + this.currentQuery.toString());
            this.insideQuery = false;
            this.request.addQuery(this.currentQuery);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public void filter(Filter filter) {
        LOGGER.finest("found filter: " + filter.toString());
        if (this.insideQuery) {
            LOGGER.finest("add filter " + filter + " to query: " + this.currentQuery);
            this.currentQuery.addFilter(filter);
        } else {
            LOGGER.finest("adding filter to all queries: " + filter);
            int i = 0;
            int n = this.request.queries.size();
            while (i < n) {
                Query query = (Query)this.request.queries.get(i);
                Filter queryFilter = query.getFilter();
                if (queryFilter != null) {
                    query.addFilter(queryFilter.and(filter));
                } else {
                    query.addFilter(filter);
                }
                ++i;
            }
        }
    }

    private void handleCharacters() {
        if (this.characters.length() == 0) {
            return;
        }
        if (this.insideTag.equals("PropertyName")) {
            String name = this.characters.toString().trim();
            this.characters.setLength(0);
            LOGGER.finest("found property name: " + name);
            this.currentQuery.addPropertyName(name);
        }
    }
}

