/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geotools.factory.FactoryFinder;
import org.geotools.filter.FunctionExpression;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wfs.FeatureResponseDelegateProducerSpi;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WFSCapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wfs$responses$WFSCapsTransformer == null ? (class$org$vfny$geoserver$wfs$responses$WFSCapsTransformer = WFSCapsTransformer.class$("org.vfny.geoserver.wfs.responses.WFSCapsTransformer")) : class$org$vfny$geoserver$wfs$responses$WFSCapsTransformer).getPackage().getName());
    private static final String HTTP_GET = "Get";
    private static final String HTTP_POST = "Post";
    protected static final String WFS_URI = "http://www.opengis.net/wfs";
    protected static final String CUR_VERSION = "1.0.0";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected WFSRequest request;
    static /* synthetic */ Class class$org$vfny$geoserver$wfs$responses$WFSCapsTransformer;
    static /* synthetic */ Class class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi;
    static /* synthetic */ Class class$org$geotools$filter$FunctionExpression;

    public WFSCapsTransformer() {
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WFSCapsTranslator(handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WFSCapsTranslator
    extends TransformerBase.TranslatorSupport {
        private static final String EPSG = "EPSG:";
        private CapabilitiesRequest request;

        public WFSCapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof CapabilitiesRequest)) {
                throw new IllegalArgumentException("Not a CapabilitiesRequest: " + o);
            }
            this.request = (CapabilitiesRequest)o;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WFSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns", "xmlns", "", WFSCapsTransformer.WFS_URI);
            WFS wfs = (WFS)this.request.getServiceRef().getServiceRef();
            NameSpaceInfo[] namespaces = wfs.getData().getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String prefixDef = "xmlns:" + namespaces[i].getPrefix();
                String uri = namespaces[i].getUri();
                attributes.addAttribute("", prefixDef, prefixDef, "", uri);
            }
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            String prefixDef = "xmlns:xsi";
            attributes.addAttribute("", prefixDef, prefixDef, "", WFSCapsTransformer.XSI_URI);
            String locationAtt = "xsi:schemaLocation";
            String locationDef = "http://www.opengis.net/wfs " + this.request.getSchemaBaseUrl() + "wfs/1.0.0/" + "WFS-capabilities.xsd";
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            this.start("WFS_Capabilities", attributes);
            this.handleService();
            this.handleCapability();
            this.handleFeatureTypes();
            this.handleFilterCapabilities();
            this.end("WFS_Capabilities");
        }

        private void handleService() {
            WFS wfs = (WFS)this.request.getServiceRef().getServiceRef();
            this.start("Service");
            this.element("Name", wfs.getName());
            this.element("Title", wfs.getTitle());
            this.element("Abstract", wfs.getAbstract());
            List kwlist = wfs.getKeywords();
            this.handleKeywords(kwlist);
            URL or = wfs.getOnlineResource();
            this.element("OnlineResource", or == null ? "" : or.toExternalForm());
            this.element("Fees", wfs.getFees());
            this.element("AccessConstraints", wfs.getAccessConstraints());
            this.end("Service");
        }

        private void handleKeywords(List kwlist) {
            StringBuffer kwds = new StringBuffer();
            Iterator it = kwlist.iterator();
            while (it.hasNext()) {
                kwds.append(String.valueOf(it.next()));
                if (!it.hasNext()) continue;
                kwds.append(", ");
            }
            this.element("Keywords", kwds.toString());
        }

        private void handleCapability() {
            WFS config = (WFS)this.request.getServiceRef().getServiceRef();
            this.start("Capability");
            this.start("Request");
            this.handleGetCapabilities();
            this.handleDescribeFT();
            this.handleGetFeature();
            if (config.getServiceLevel() >= 15) {
                this.handleTransaction();
            }
            if (config.getServiceLevel() == 31) {
                this.handleLock();
                this.handleFeatureWithLock();
            }
            this.end("Request");
            this.end("Capability");
        }

        private void handleGetCapabilities() {
            String capName = "GetCapabilities";
            this.start(capName);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleDescribeFT() {
            String capName = "DescribeFeatureType";
            this.start(capName);
            this.start("SchemaDescriptionLanguage");
            this.element("XMLSCHEMA", null);
            this.end("SchemaDescriptionLanguage");
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleGetFeature() {
            String capName = "GetFeature";
            this.start(capName);
            String resultFormat = "ResultFormat";
            this.start(resultFormat);
            WFS config = (WFS)this.request.getServiceRef().getServiceRef();
            boolean onlyGML2 = config.getCiteConformanceHacks();
            if (onlyGML2) {
                this.element("GML2", null);
            } else {
                Iterator spi_it = FactoryFinder.factories((Class)(class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi == null ? (class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi = WFSCapsTransformer.class$("org.vfny.geoserver.wfs.FeatureResponseDelegateProducerSpi")) : class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi));
                while (spi_it.hasNext()) {
                    FeatureResponseDelegateProducerSpi spi = (FeatureResponseDelegateProducerSpi)spi_it.next();
                    Set formats = spi.getSupportedFormats();
                    Iterator it = formats.iterator();
                    while (it.hasNext()) {
                        String format = (String)it.next();
                        this.element(format, null);
                    }
                }
            }
            this.end(resultFormat);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleTransaction() {
            String capName = "Transaction";
            this.start(capName);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleLock() {
            String capName = "LockFeature";
            this.start(capName);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleFeatureWithLock() {
            String capName = "GetFeatureWithLock";
            this.start(capName);
            this.start("ResultFormat");
            this.element("GML2", null);
            this.end("ResultFormat");
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_GET);
            this.handleDcpType(capName, WFSCapsTransformer.HTTP_POST);
            this.end(capName);
        }

        private void handleDcpType(String capabilityName, String httpMethod) {
            String baseUrl = this.request.getBaseUrl() + "wfs";
            String url = null;
            url = this.request.isDispatchedRequest() ? baseUrl + "?" : baseUrl + "/" + capabilityName + "?";
            this.start("DCPType");
            this.start("HTTP");
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "onlineResource", "onlineResource", "", url);
            this.element(httpMethod, null, atts);
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleFeatureTypes() {
            WFS wfs = (WFS)this.request.getServiceRef().getServiceRef();
            if (!wfs.isEnabled()) {
                // empty if block
            }
            this.start("FeatureTypeList");
            this.start("Operations");
            if ((wfs.getServiceLevel() | 1) != 0) {
                this.element("Query", null);
            }
            if ((wfs.getServiceLevel() | 2) != 0) {
                this.element("Insert", null);
            }
            if ((wfs.getServiceLevel() | 4) != 0) {
                this.element("Update", null);
            }
            if ((wfs.getServiceLevel() | 8) != 0) {
                this.element("Delete", null);
            }
            if ((wfs.getServiceLevel() | 0x10) != 0) {
                this.element("Lock", null);
            }
            this.end("Operations");
            Collection featureTypes = wfs.getData().getFeatureTypeInfos().values();
            Iterator it = featureTypes.iterator();
            while (it.hasNext()) {
                FeatureTypeInfo ftype = (FeatureTypeInfo)it.next();
                if (!ftype.isEnabled()) continue;
                this.handleFeatureType(ftype);
            }
            this.end("FeatureTypeList");
        }

        protected void handleFeatureType(FeatureTypeInfo ftype) {
            this.start("FeatureType");
            Envelope bbox = null;
            try {
                bbox = ftype.getLatLongBoundingBox();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't obtain latLongBBox of " + ftype.getName() + ": " + ex.getMessage(), ex);
            }
            this.element("Name", ftype.getName());
            this.element("Title", ftype.getTitle());
            this.element("Abstract", ftype.getAbstract());
            this.handleKeywords(ftype.getKeywords());
            this.element("SRS", EPSG + ftype.getSRS());
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLongBoundingBox", null, bboxAtts);
            this.end("FeatureType");
        }

        private void handleFilterCapabilities() {
            String ogc = "ogc:";
            this.start(ogc + "Filter_Capabilities");
            this.start(ogc + "Spatial_Capabilities");
            this.start(ogc + "Spatial_Operators");
            this.element(ogc + "Disjoint", null);
            this.element(ogc + "Equals", null);
            this.element(ogc + "DWithin", null);
            this.element(ogc + "Beyond", null);
            this.element(ogc + "Intersect", null);
            this.element(ogc + "Touches", null);
            this.element(ogc + "Crosses", null);
            this.element(ogc + "Within", null);
            this.element(ogc + "Contains", null);
            this.element(ogc + "Overlaps", null);
            this.element(ogc + "BBOX", null);
            this.end(ogc + "Spatial_Operators");
            this.end(ogc + "Spatial_Capabilities");
            this.start(ogc + "Scalar_Capabilities");
            this.element(ogc + "Logical_Operators", null);
            this.start(ogc + "Comparison_Operators");
            this.element(ogc + "Simple_Comparisons", null);
            this.element(ogc + "Between", null);
            this.element(ogc + "Like", null);
            this.element(ogc + "NullCheck", null);
            this.end(ogc + "Comparison_Operators");
            this.start(ogc + "Arithmetic_Operators");
            this.element(ogc + "Simple_Arithmetic", null);
            this.handleFunctions(ogc);
            this.end(ogc + "Arithmetic_Operators");
            this.end(ogc + "Scalar_Capabilities");
            this.end(ogc + "Filter_Capabilities");
        }

        public void handleFunctions(String prefix) {
            this.start(prefix + "Functions");
            this.start(prefix + "Function_Names");
            Iterator it = FactoryFinder.factories((Class)(class$org$geotools$filter$FunctionExpression == null ? (class$org$geotools$filter$FunctionExpression = WFSCapsTransformer.class$("org.geotools.filter.FunctionExpression")) : class$org$geotools$filter$FunctionExpression));
            TreeSet sortedFunctions = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    String n1 = ((FunctionExpression)o1).getName();
                    String n2 = ((FunctionExpression)o2).getName();
                    return n1.toLowerCase().compareTo(n2.toLowerCase());
                }
            });
            while (it.hasNext()) {
                sortedFunctions.add(it.next());
            }
            Object exp = null;
            it = sortedFunctions.iterator();
            while (it.hasNext()) {
                FunctionExpression fe = (FunctionExpression)it.next();
                String funName = fe.getName();
                int funNArgs = fe.getArgCount();
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "nArgs", "nArgs", "", funNArgs + "");
                this.element(prefix + "Function_Name", funName, atts);
            }
            this.end(prefix + "Function_Names");
            this.end(prefix + "Functions");
        }
    }
}

