/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;

public class ShapeFeatureResponseDelegate
implements FeatureResponseDelegate {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wfs.responses");
    String tempDir = null;
    public static final String formatName = "SHAPE-ZIP";
    private GetFeatureResults results;

    public boolean canProduce(String outputFormat) {
        return formatName.equalsIgnoreCase(outputFormat);
    }

    public void prepare(String outputFormat, GetFeatureResults results) throws IOException {
        this.results = results;
        if (results == null) {
            throw new IllegalStateException("It seems prepare() has not succeed. <results> is null");
        }
        this.tempDir = System.getProperty("java.io.tmpdir");
        if (this.tempDir != null && !this.tempDir.endsWith(File.separator)) {
            this.tempDir = this.tempDir + File.separator;
        }
        if (this.tempDir == null) {
            throw new NullPointerException("<tempDir> is null. There is a problem with the java.io.tempdir directory.");
        }
    }

    public String getContentType(GeoServer gs) {
        return "application/zip";
    }

    public String getContentEncoding() {
        return formatName;
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.results == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        ZipOutputStream zipOut = new ZipOutputStream(output);
        output = zipOut;
        List resultsList = this.results.getFeatures();
        FeatureResults[] featureResults = resultsList.toArray(new FeatureResults[resultsList.size()]);
        FeatureReader reader = featureResults[0].reader();
        String name = featureResults[0].getSchema().getTypeName();
        String namePath = this.tempDir + name;
        this.writeOut(name, this.tempDir, featureResults, reader);
        ZipEntry entry = new ZipEntry(name + ".shp");
        zipOut.putNextEntry(entry);
        FileInputStream shp_in = new FileInputStream(namePath + ".shp");
        this.readInWriteOutBytes(output, shp_in);
        zipOut.closeEntry();
        ((InputStream)shp_in).close();
        entry = new ZipEntry(name + ".dbf");
        zipOut.putNextEntry(entry);
        FileInputStream dbf_in = new FileInputStream(namePath + ".dbf");
        this.readInWriteOutBytes(output, dbf_in);
        zipOut.closeEntry();
        ((InputStream)dbf_in).close();
        entry = new ZipEntry(name + ".shx");
        zipOut.putNextEntry(entry);
        FileInputStream shx_in = new FileInputStream(namePath + ".shx");
        this.readInWriteOutBytes(output, shx_in);
        zipOut.closeEntry();
        ((InputStream)shx_in).close();
        zipOut.finish();
        ((FilterOutputStream)zipOut).flush();
        zipOut.close();
    }

    private void readInWriteOutBytes(OutputStream output, InputStream in) throws IOException {
        int c;
        while (-1 != (c = in.read())) {
            output.write(c);
        }
    }

    private void writeOut(String name, String tempDir, FeatureResults[] featureResults, FeatureReader reader) throws IOException {
        File file = new File(tempDir, name);
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        sfds.createSchema(featureResults[0].getSchema());
        FeatureStore store = (FeatureStore)sfds.getFeatureSource(name);
        store.addFeatures(reader);
    }
}

